<?php
/**
 * @author  UiGigs
 * @since   1.0
 * @version 1.0
 */

namespace UiGigs\staco;
use UiGigs\staco\staco;
use UiGigs\staco\Helper;

$body_color    = staco::$options['body_color'];
$heading_color = staco::$options['heading_color'];
$primary_color = staco::$options['primary_color'];
$secondary_color = staco::$options['secondary_color'];

//Typography Settings
Helper::requires( 'views/typography.php' );
//Menu Color
Helper::requires( 'views/menu-color.php' );
?>
<?php 
	$logo1_size = staco::$options['logo1_size'];
	$logo1_m_size = staco::$options['logo1_m_size'];
?>
.header-logo a {
    width: <?php echo esc_html( $logo1_size ); ?>px;
}

@media only screen and (max-width: 767px) {
	.header-logo a {
		width: <?php echo esc_html( $logo1_m_size ); ?>px;
	}
}

@media (max-width: 400px) {
	.header-logo a {
		width: 110px;
	}
	.sticky-on.sticky-header .header-logo a {
		width: 110px;
	}
}

:root {
	--uigigs-body-color: <?php echo esc_html( $body_color ? $body_color : '#ffffffcc' ) ?>;
	--uigigs-heading-color: <?php echo esc_html( $heading_color ? $heading_color : '#ffffff' ) ?>;
	--uigigs-primary-color: <?php echo esc_html( $primary_color ? $primary_color : '#00ffa3' ) ?>;
	--uigigs-secondary-color: <?php echo esc_html( $secondary_color ? $secondary_color : '#5865F2' ) ?>;
}