<?php
/**
 * @author  UiGigs
 * @since   1.0
 * @version 1.0
 */

namespace UiGigs\staco;
use UiGigs\staco\staco;
use UiGigs\staco\Helper;

class General_Setup {

	public function __construct() {
		add_action( 'after_setup_theme',                       array( $this, 'theme_setup' ) );	
		add_action( 'widgets_init',                            array( $this, 'register_sidebars' ), 0 );		
		add_filter( 'body_class',                              array( $this, 'body_classes' ) );
		add_filter( 'post_class',                              array( $this, 'post_classes' ) );
		add_filter( 'wp_list_categories',                      array( $this, 'staco_cat_count_span' ) );
		add_filter( 'get_archives_link',                       array( $this, 'staco_archive_cat_count_span' ) );
		add_action( 'wp_head',                                 array( $this, 'noscript_hide_preloader' ), 1 );
		add_filter( 'get_search_form',                         array( $this, 'search_form' ) );
		add_filter( 'comment_form_fields',                     array( $this, 'move_textarea_to_bottom' ) );
		add_filter( 'excerpt_more',                            array( $this, 'excerpt_more' ) );		
		add_filter( 'elementor/widgets/wordpress/widget_args', array( $this, 'elementor_widget_args' ) );
		add_action( 'wp_head',                                 array( $this, 'staco_pingback_header' ), 996 );
		add_action( 'site_prealoader',                         array( $this, 'staco_preloader' ) );
		add_action( 'wp_kses_allowed_html',                    array( $this, 'staco_kses_allowed_html' ), 10, 2 );
		add_action( 'template_redirect',                       array( $this, 'w3c_validator' ) );
		add_filter( 'upload_mimes', 						   array($this, 'staco_custom_mime_types' ));
		add_action( 'wp_ajax_load_more_ports', 				   array($this, 'uigigs_load_more_func' ));
		add_action( 'wp_ajax_nopriv_load_more_ports', 		   array($this, 'uigigs_load_more_func' ));
	}


	/**
	* Add a pingback url auto-discovery header for single posts, pages, or attachments.
	*/
	public function staco_pingback_header() {
		if ( is_singular() && pings_open() ) {
			printf( '<link rel="pingback" href="%s">', esc_url( get_bloginfo( 'pingback_url' ) ) );
		}
	}

	public function theme_setup() {
		$prefix = staco_THEME_PREFIX;		

		// Theme supports
		add_theme_support( 'woocommerce' );
		add_theme_support( 'title-tag' );
		add_theme_support( 'post-thumbnails' );
		add_theme_support( 'automatic-feed-links' );
		add_theme_support( 'wp-block' );
		add_theme_support( 'html5', array( 'comment-list', 'comment-form', 'search-form', 'gallery', 'caption' ) );
		add_editor_style();
		add_theme_support( 'admin-bar', array( 'callback' => '__return_false' ) );
		// For gutenberg
		remove_theme_support( 'widgets-block-editor' );
		add_theme_support( 'align-wide' );
		add_theme_support( 'editor-color-palette', array(
			array(
				'name'  => esc_html__( 'Primary', 'staco' ),
				'slug'  => 'staco-primary',
				'color' => '#00ffa3',
			),
			array(
				'name'  => esc_html__('Secondary', 'staco' ),
				'slug'  => 'staco-secondary',
				'color' => '#5865F2',
			),
			array(
				'name'  => esc_html__('Light', 'staco' ),
				'slug'  => 'staco-light',
				'color' => '#ffffff',
			),
			array(
				'name'  => esc_html__('Black', 'staco' ),
				'slug'  => 'staco-black',
				'color'  => '#000000',
			),
			array(
				'name'  => esc_html__('Dark', 'staco' ),
				'slug'  => 'staco-dark',
				'color'  => '#5a5a5a',
			),
			
		) );
		add_theme_support( 'editor-font-sizes', array(
			array(
				'name' => esc_html__('Small', 'staco' ),
				'size'  => 12,
				'slug'  => 'small'
			),
			array(
				'name'  => esc_html__('Normal', 'staco' ),
				'size'  => 16,
				'slug'  => 'normal'
			),
			array(
				'name'  => esc_html__('Medium', 'staco' ),
				'size'  => 18,
				'slug'  => 'medium'
			),
			array(
				'name'  => esc_html__('Large', 'staco' ),
				'size'  => 32,
				'slug'  => 'large'
			),
			array(
				'name'  => esc_html__('Huge', 'staco' ),
				'size'  => 48,
				'slug'  => 'huge'
			)
		) );

		add_theme_support( 'wp-block-styles' );
		add_theme_support( 'responsive-embeds' );
		add_theme_support( 'editor-styles');		
	
		// Image sizes
		add_image_size( 'staco_medium', 700, 600, true ); //Default medium size overrite
		add_image_size( 'staco_medium2', 450, 540, true ); //Medium size 2
		add_image_size( 'staco_small', 80, 80, true ); //Medium size 2

		// Register menus
		register_nav_menus( array(
			'primary'  => esc_html__( 'Primary', 'staco' ),
			'copyright_menu'  => esc_html__( 'Copy Right Menu', 'staco' ),
		) );

		// Custom Logo
		add_theme_support( 'custom-logo', array(
			'height'      => 65,
			'width'       => 245,
			'flex-height' => true,
			'header-text' => array( 'site-title', 'site-description' ),
		) );

		// Set up the WordPress core custom background feature.
		add_theme_support('custom-background', apply_filters('staco_custom_background_args', array(
			'default-color' => 'ffffff',
			'default-image' => '',
		)));
	}

	public function register_sidebars() {
		register_sidebar( array(
			'name'          => esc_html__( 'Sidebar Widgets', 'staco' ),
			'id'            => 'sidebar',
			'description'   => esc_html__('Sidebar widgets area', 'staco'),
			'before_widget' => '<div id="%1$s" class="widget %2$s sidebar-widget ">',
			'after_widget'  => '</div>',
			'before_title'  => '<div class="widget-heading heading-dark"><h4 class="heading-title">',
			'after_title'   => '</h4></div>',
		) );
	}


	public function body_classes( $classes ) {
		$classes[] = 'mobile-menu-wrapper';
		if ( staco::$options['sticky_header'] == 1 ) {
			$classes[] = 'sticky-header';
		}
		$classes[] = 'header-style-'. staco::$header_style;
        // Sidebar
		$classes[] = ( staco::$layout == 'full-width' ) ? 'no-sidebar' : 'has-sidebar';
		if ( is_page_template( 'templates/box-layout.php' ) ) { 
			$classes[] = 'full-page-background';
		}
		if ( staco::$tr_header === 1 || staco::$tr_header === 'on' ) {
			$classes[] = 'transparent-header';
		} else {
			$classes[] = 'non-transparent-header';
		}

		return $classes;
	}

	public function post_classes( $classes ) {
		$post_thumb = '';
		if ( has_post_thumbnail() ){
			$classes[] = 'have-post-thumb';
		}
		return $classes;
	}

    /*----------------------------------------------------------------------------------------*/
    /* Categories/Archive List count wrap by span
    /*----------------------------------------------------------------------------------------*/
    public function staco_cat_count_span($links) {        
        $links = str_replace('(', '<span class="float-right">(', $links);
        $links = str_replace(')', ')</span>', $links);
        return $links;
    }

    public function staco_archive_cat_count_span($links) {        
        $links = str_replace('(', '<span class="float-right">(', $links);
        $links = str_replace(')', ')</span>', $links);
        return $links;
    }

	public function noscript_hide_preloader(){
		// Hide preloader if js is disabled
		echo '<noscript><style>#preloader{display:none;}</style></noscript>';
	}

	public function scroll_to_top_html(){
		// Back-to-top link
		if ( staco::$options['page_scrolltop'] == '1' ){
		echo '<a href="#wrapper" data-type="section-switch" class="scrollup back-top">
			<i class="far fa-hand-point-up"></i>
		</a>';
		}
	}
	public function search_form(){
		$output = '
		<div class="letest-blog-search-section">
			<form role="search" method="get" class="search-form" action="' . esc_url( home_url( '/' ) ) . '">
				<input type="text" class="form-control" placeholder="' . esc_attr__( 'Search here ...', 'staco' ) . '" value="' . get_search_query() . '" name="s" />
				<button type="submit"><img src="'.esc_url( Helper::get_img( 'search-icon.svg' ) ).'"></button>
			</form>
		</div>
		';
		return $output;
	}

	public function move_textarea_to_bottom( $fields ) {
		$temp = $fields['comment'];
		unset( $fields['comment'] );
		$fields['comment'] = $temp;
		return $fields;
	}

	public function excerpt_more() {
		return esc_html__( '...', 'staco' ) ;
	}
	
	public function elementor_widget_args( $args ) {
		$args['before_widget'] = '<div class="widget single-sidebar padding-bottom1">';
		$args['after_widget']  = '</div>';
		$args['before_title']  = '<h3>';
		$args['after_title']   = '</h3>';
		return $args;
	}

	function staco_custom_mime_types( $mimes ) {
		// New allowed mime types.
		$mimes['svg'] = 'image/svg+xml';
		$mimes['svgz'] = 'image/svg+xml';
		$mimes['doc'] = 'application/msword';
		// Optional. Remove a mime type.
		unset( $mimes['exe'] );

		return $mimes;
	}
	
	
	public function staco_preloader() {
        echo '
         	<!--Preloader area start here-->
	        <section class="loader_first">
	            <div class="circular-spinner"></div>
	        </section>
	        <!--Preloader area End here-->
        ';
	}

	public function staco_kses_allowed_html($tags, $context) {
		switch($context) {
			case 'social':
			$tags = array(
				'a' => array('href' => array()),
				'b' => array()
			);
			return $tags;
			case 'alltext_allow':
			$tags = array(
				'a' => array(
					'class' => array(),
					'href'  => array(),
					'rel'   => array(),
					'title' => array(),
					'target' => array(),
				),
				'abbr' => array(
					'title' => array(),
				),
				'b' => array(),
				'br' => array(),
				'blockquote' => array(
					'cite'  => array(),
				),
				'cite' => array(
					'title' => array(),
				),
				'code' => array(),
				'del' => array(
					'datetime' => array(),
					'title' => array(),
				),
				'dd' => array(),
				'div' => array(
					'class' => array(),
					'title' => array(),
					'style' => array(),
					'id' => array(),
				),
				'dl' => array(),
				'dt' => array(),
				'em' => array(),
				'h1' => array(),
				'h2' => array(),
				'h3' => array(),
				'h4' => array(),
				'h5' => array(),
				'h6' => array(),
				'i' => array(),
				'img' => array(
					'alt'    => array(),
					'class'  => array(),
					'height' => array(),
					'src'    => array(),
					'srcset' => array(),
					'width'  => array(),
				),
				'li' => array(
					'class' => array(),
				),
				'ol' => array(
					'class' => array(),
				),
				'p' => array(
					'class' => array(),
				),
				'q' => array(
					'cite' => array(),
					'title' => array(),
				),
				'span' => array(
					'class' => array(),
					'title' => array(),
					'style' => array(),
				),
				'strike' => array(),
				'strong' => array(),
				'ul' => array(
					'class' => array(),
				),
			);
			return $tags;
			default:
			return $tags;
		}
	}

	/* - staco Post and taxonomy slug change
	--------------------------------------------------------*/
	public function update_staco_custom_post_slug( $args, $post_type ) {
		$prefix = staco_THEME_PREFIX;
		$theme = wp_get_theme(); // gets the current theme
		if ( 'staco' == $theme->name || 'staco' == $theme->parent_theme ) {
			$portfolio_slug = staco::$options['single_portfolio_slug'];
			$event_slug = staco::$options['single_event_slug'];
			$team_slug = staco::$options['single_speaker_slug'];
		    if ( $prefix.'_portfolio' === $post_type ) {
		        $portfolio = array(
		            'rewrite' => array( 'slug' => $portfolio_slug, 'with_front' => false )
		        );
		        return array_merge( $args, $portfolio );
		    }
		    if ( $prefix.'_event' === $post_type ) {
		        $event = array(
		            'rewrite' => array( 'slug' => $event_slug, 'with_front' => false )
		        );
		        return array_merge( $args, $event );
		    }
		    if ( $prefix.'_team' === $post_type ) {
		        $team = array(
		            'rewrite' => array( 'slug' => $team_slug, 'with_front' => false )
		        );
		        return array_merge( $args, $team );
		    }
		}
		return $args;
	}

	public function staco_change_taxonomies_slug( $args, $taxonomy ) {
		$prefix = staco_THEME_PREFIX;
		$portfolio_cat_slug = staco::$options['portfolio_cat_slug'];
		$event_cat_slug = staco::$options['event_cat_slug'];
	    /*item and event pro locations*/
	    if ( $prefix.'_portfolio_category' === $taxonomy ) {
	    	$args['rewrite']['slug'] = $portfolio_cat_slug;
	    }
	    if ( $prefix.'_event_category' === $taxonomy ) {
	    	$args['rewrite']['slug'] = $event_cat_slug;
	    }
		return $args;
	}


	/* - Ajax Callback Function
	--------------------------------------------------------*/
	public function uigigs_load_more_func() {

		$posts_no = staco::$options['portfolio_archive_number'];
	    $page = (isset($_GET['pageNumber'])) ? $_GET['pageNumber'] : 0;

		query_posts(array(
			'post_type' => 'staco_portfolio',
			'posts_per_page' => $posts_no,
			'post_status'   => 'publish',
			'paged'          => $page,
			'post__not_in' => get_option( 'sticky_posts')
		)); 

	    if(have_posts()) : while(have_posts()) : the_post();

	    $cols = staco::$options['portfolio_grid_cols'];
	    $location = get_post_meta( get_the_ID(), "staco_portfolio_location", true );

	    ?>

		<div class="col-lg-<?php echo esc_attr( $cols ); ?> col-md-6 col-12 gallery-item masonry-item single-grid-item">
	        <div class="project-layout2">
	        	<div class="item-figure">
		            <?php the_post_thumbnail( 'staco-size-2' ); ?>
		            <div class="item-icon">
		            	<a href="<?php echo esc_url( get_the_post_thumbnail_url() ); ?>" class="popup-zoom" data-fancybox-group="gallery" title="<?php echo esc_attr( get_the_title() ); ?>">
			                <span class="line1"></span>
			                <span class="line2"></span>
		             	</a>
		            </div>
	          	</div>
	        	<div class="item-content">                  
		            <h3 class="item-title"><a href="<?php the_permalink(); ?>"><?php the_title(); ?></a></h3>
		            <div class="item-sub-title"><?php echo esc_html( $location ); ?></div>
	        	</div>
	        </div>
	    </div>

	    <?php endwhile;endif;
	      wp_reset_query();
	      die();
	} // End of ajax callback function

	public function w3c_validator() {
		/*----------------------------------------------------------------------------------------------------*/
		/*  W3C validator passing code
		/*----------------------------------------------------------------------------------------------------*/
	    ob_start( function( $buffer ){
	        $buffer = str_replace( array( '<script type="text/javascript">', "<script type='text/javascript'>" ), '<script>', $buffer );
	        return $buffer;
	    });
	    ob_start( function( $buffer2 ){
	        $buffer2 = str_replace( array( "<script type='text/javascript' src" ), '<script src', $buffer2 );
	        return $buffer2;
	    });
	    ob_start( function( $buffer3 ){
	        $buffer3 = str_replace( array( 'type="text/css"', "type='text/css'", 'type="text/css"', ), '', $buffer3 );
	        return $buffer3;
	    });
	    ob_start( function( $buffer4 ){
	        $buffer4 = str_replace( array( '<iframe frameborder="0" scrolling="no" marginheight="0" marginwidth="0"', ), '<iframe', $buffer4 );
	        return $buffer4;
	    });
		ob_start( function( $buffer5 ){
	        $buffer5 = str_replace( array( 'aria-required="true"', ), '', $buffer5 );
	        return $buffer5;
	    });
	}
}
new General_Setup;