<?php
/**
 * @author  UiGigs
 * @since   1.0
 * @version 1.0
 */

namespace UiGigs\staco;
use UiGigs\staco\staco;
use UiGigs\staco\Helper;
use WP_Query;

trait CustomQueryTrait {

  /**
   * Portfolio Elements
   * ==========================================================================
   */
  public static function portfolio_query() {
    $cpt = staco_THEME_CPT_PREFIX;
    $filter_enable = staco::$options['portfolio_filter'];
    $cats_slug = staco::$options['portfolio_cats_slug'];
    $terms = explode(',', $cats_slug);


    if ( $filter_enable == 1 && !empty( $terms ) ) {
      $args = array(
        'post_type'      => "{$cpt}_portfolio",
        'posts_per_page' => staco::$options['portfolio_archive_number'],
        'orderby'        => staco::$options['portfolio_orderby'],
        'tax_query' => array(
          array(
            'taxonomy' => $cpt.'_portfolio_category',
            'field' => 'id',
            'terms' => $terms
          )
        ),
      );
    } else {
      $args = array(
        'post_type'      => "{$cpt}_portfolio",
        'posts_per_page' => staco::$options['portfolio_archive_number'],
        'orderby'        => staco::$options['portfolio_orderby'],
      );
    }

    if ( get_query_var('paged') ) {
      $args['paged'] = get_query_var('paged');
    }
    elseif ( get_query_var('page') ) {
      $args['paged'] = get_query_var('page');
    }
    else {
      $args['paged'] = 1;
    }

    $query = new WP_Query( $args );

    return $query;
  }

  public static function get_portfolio_cat_slug(){
    $cpt = staco_THEME_CPT_PREFIX;
    $cat_slug = '';
    $terms = get_the_terms( get_the_ID(), "{$cpt}_portfolio_category" );          
    if ( $terms && ! is_wp_error( $terms ) ) {
      $slug_list = array();
      foreach ( $terms as $term ) {
        $slug_list[] = $term->slug;
      }        
      $cat_slug = join( " ", $slug_list );
    }
    return $cat_slug;
  }

  /**
   * Getting Custom taxanomy for portfolio - category- single service
   */
  public static function portfolio_categories_slug() {
    $cpt = staco_THEME_CPT_PREFIX;
    if( class_exists( 'Staco_Core' ) ) {
      $terms = get_terms( "staco_portfolio_category");
      if(!empty($terms)){
        $category_links = array();
        foreach ($terms as $key => $value) {
          $category_links[$value->term_id] = $value->name;
        }
        return $category_links;
      }
    }
  }

  /**
  * Service Elements
  * ==========================================================================
  */
  public static function event_query() {
    $cpt = staco_THEME_CPT_PREFIX;
    $args = array(
      'post_type'      => "{$cpt}_event",
      'posts_per_page' => staco::$options['event_archive_number'],
      'orderby'        => staco::$options['event_orderby'],
    );

    $orderby = '';
    $order = 'ASC';
    if ( $orderby ) {
      $args['order'] = $order;
    }

    if ( get_query_var('paged') ) {
      $args['paged'] = get_query_var('paged');
    } elseif ( get_query_var('page') ) {
      $args['paged'] = get_query_var('page');
    } else {
      $args['paged'] = 1;
    }

    $query = new WP_Query( $args );

    return $query;
  }

  public static function event_categories_slug() {
    $cpt = staco_THEME_CPT_PREFIX;
    $terms = get_terms( "{$cpt}_event_category" );
    if(!empty($terms)){
      $category_links = array();
      foreach ($terms as $key => $value) {
        $category_links[$value->term_id] = $value->name;  
      }
      return $category_links;
    }
  }

  /**
  * Team Elements
  * ==========================================================================
  */
  public static function speaker_query() {
    $cpt = staco_THEME_CPT_PREFIX;
    $args = array(
      'post_type'      => "{$cpt}_speaker",
      'posts_per_page' => staco::$options['speaker_archive_number'],
      'orderby'        => staco::$options['speaker_orderby'],
    );

    $orderby = '';
    $order = 'ASC';
    if ( $orderby ) {
      $args['order'] = $order;
    }

    if ( get_query_var('paged') ) {
      $args['paged'] = get_query_var('paged');
    }
    elseif ( get_query_var('page') ) {
      $args['paged'] = get_query_var('page');
    }
    else {
      $args['paged'] = 1;
    }

    $query = new WP_Query( $args );

    return $query;
  }

  public static function team_categories_slug() {
    $cpt = staco_THEME_CPT_PREFIX;
    $terms = get_terms( "{$cpt}_speaker_category" );
    if(!empty($terms)){
      $category_links = array();
      foreach ($terms as $key => $value) {
        $category_links[$value->term_id] = $value->name;  
      }
      return $category_links;
    }
  }

 
  /**
   * Global Code
   * ==========================================================================
   */
  static function generate_array_iterator_postfix( $array, $index, $postfix = ', ' ) {
    $length = count($array);
    if ($length) {
      $last_index = $length - 1;
      return $index < $last_index ? $postfix : '';
    }
  }

  public static function wp_set_temp_query( $query ){
    global $wp_query;
    $temp = $wp_query;
    $wp_query = $query;
    return $temp;
  }

  public static function wp_reset_temp_query( $temp ){
    global $wp_query;
    $wp_query = $temp;
    wp_reset_postdata();
  }

  public static function set_order_orderby($rd_field){
    $orderby = '';
    $order   = 'DESC';
    switch ( staco::$options[ $rd_field ] ) {
      case 'title':
      case 'menu_order':
      $orderby = staco::$options[ $rd_field ];
      $order = 'ASC';
      break;
    }
    if ( $orderby ) {
      $args['orderby'] = $orderby;
      $args['order'] = $order;
    }
    return $args;
  } 

  public static function set_args_orderby( $args, $rd_field ){
    $orderby = '';
    $order   = 'DESC';
    switch ( staco::$options[ $rd_field ] ) {
      case 'title':
      case 'menu_order':
      $orderby = staco::$options[ $rd_field ];
      $order = 'ASC';
      break;
    }
    if ( $orderby ) {
      $args['orderby'] = $orderby;
      $args['order'] = $order;
    }
    return $args;
  }

  /**
   * for setting up pagination for custom post type
   * we have to pass paged key
   */
  public static function set_args_paged ($args) {
    if ( get_query_var('paged') ) {
      $args['paged'] = get_query_var('paged');
    }
    elseif ( get_query_var('page') ) {
      $args['paged'] = get_query_var('page');
    }
    else {
      $args['paged'] = 1;
    }
    return $args;
  }

}
