<?php
/**
 * @author  UiGigs
 * @since   1.0
 * @version 1.0
 */

namespace UiGigs\staco;
use UiGigs\staco\staco;
trait DataTrait {
  public static function staco_get_post_meta( $post_id, $padmin, $pdate, $pcats ) { 
      $post_meta_holder= "";
      $post_meta  = staco::$options['post_meta_admin'] || staco::$options['post_meta_date'] || staco::$options['post_meta_com'] || staco::$options['post_meta_cats'] ? true : false;
      if ( $post_meta ){ ?>
        <div class="staco-blog-meta"> 
          <?php if ( $pcats && has_category() ){ ?>
            <span><?php the_category( ', ' ); ?></span>
          <?php } if ( $pdate ){ ?> . <?php echo get_the_date(); ?> <?php } ?>
        </div>
    <?php }
    return $post_meta_holder;
  }
  public static function staco_get_attach_img( $img_id, $size ) {
    $attach_img = '';
    if (!empty( $img_id )) {
      $attach_img = wp_get_attachment_image( $img_id, $size );
    } else {
      $attach_img = '';
    }
    return $attach_img;
  }
  public static function hsocials(){
    $header_socials = array(
      'hsocial_opensea' => array(
        'text' => 'Opensea',
        'icon' => 'fa-brands fa-opensea',
        'url'  => staco::$options['hsocial_opensea'],
      ),
      'hsocial_twitter' => array(
        'text' => 'Twitter',
        'icon' => 'fab fa-twitter',
        'url'  => staco::$options['hsocial_twitter'],
      ), 
      'hsocial_discord' => array(
        'text' => 'Discord',
        'icon' => 'fa-brands fa-discord',
        'url'  => staco::$options['hsocial_discord'],
      ),
      'hsocial_facebook' => array(
        'text' => 'Facebook',
        'icon' => 'fab fa-facebook-f',
        'url'  => staco::$options['hsocial_facebook'],
      ),
    );
    return array_filter( $header_socials, array( __CLASS__ , 'filter_social' ) );
  }

  public static function socials(){
    $stacotheme_socials = array(
      'social_opensea' => array(
        'text' => 'Opensea',
        'icon' => 'fa-brands fa-opensea',
        'url'  => staco::$options['social_opensea'],
      ),
      'social_facebook' => array(
        'text' => 'Facebook',
        'icon' => 'fab fa-facebook-f',
        'url'  => staco::$options['social_facebook'],
      ),
      'social_twitter' => array(
        'text' => 'Twitter',
        'icon' => 'fab fa-twitter',
        'url'  => staco::$options['social_twitter'],
      ), 
      'social_discord' => array(
        'text' => 'Discord',
        'icon' => 'fa-brands fa-discord',
        'url'  => staco::$options['social_discord'],
      ),
      'social_pinterest' => array(
        'text' => 'Pinterest',
        'icon' => 'fab fa-pinterest-p',
        'url'  => staco::$options['social_pinterest'],
      ),
      'social_instagram' => array(
        'text' => 'Instagram',
        'icon' => 'fab fa-instagram',
        'url'  => staco::$options['social_instagram'],
      ),
    );
    return array_filter( $stacotheme_socials, array( __CLASS__ , 'filter_social' ) );
  }
  public static function filter_social( $args ){
    return ( $args['url'] != '' );
  }
  public static function rt_rating( $count ){ ?>
    <div class="item-rating">
      <?php 
        for ($i=0; $i <=4 ; $i++) {
          if ($i < $count) {
            $full = 'sactive';
          } else {
            $full = 'sdeactive';
          }
          echo "<i class=\"flaticon-star $full\"></i>";
        }
      ?>
    </div>
    <?php 
  }
  public static function hex2rgb($hex) {
    $hex = str_replace("#", "", $hex);
    if(strlen($hex) == 3) {
      $r = hexdec(substr($hex,0,1).substr($hex,0,1));
      $g = hexdec(substr($hex,1,1).substr($hex,1,1));
      $b = hexdec(substr($hex,2,1).substr($hex,2,1));
    } else {
      $r = hexdec(substr($hex,0,2));
      $g = hexdec(substr($hex,2,2));
      $b = hexdec(substr($hex,4,2));
    }
    $rgb = "$r, $g, $b";
    return $rgb;
  }

}

