<?php
/**
 * @author  UiGigs
 * @since   1.0
 * @version 1.0
 */

namespace UiGigs\staco;


trait IconTrait {

      public static function get_icons(){
            $font_awesomes = self::get_font_awesome_5_icons();
            $flaticons = self::get_flaticon_icons();
            return array_merge($flaticons, $font_awesomes );
      }

      public static function get_flaticon_icons(){
            return [
                  "flaticon-shopping-bags" => "shopping-bags",
                  "flaticon-search" =>        "search",
                  "flaticon-floor-plans" =>   "floor-plans",
                  "flaticon-carpet" =>        "carpet",
                  "flaticon-home" =>          "home",
                  "flaticon-key" =>           "key",
                  "flaticon-right-quote" =>   "right-quote",
                  "flaticon-tech" =>          "tech",
                  "flaticon-brainstorming" => "brainstorming",
                  "flaticon-ruler" =>         "ruler",
                  "flaticon-building" =>      "building",
                  "flaticon-left-arrow" =>    "left-arrow",
                  "flaticon-right-arrow" =>   "right-arrow",
                  "flaticon-optimization" =>  "optimization",
                  "flaticon-client" =>        "client",
                  "flaticon-pin" =>             "pin"
            ];
      }

      public static function get_font_awesome_5_icons(){
            return [
                  "fab fa-500px" => "fa-500px",
                  "fab fa-accessible-icon" => "fa-accessible-icon",
                  "fab fa-accusoft" => "fa-accusoft",
                  "fas fa-address-book" => "fa-address-book",
                  "far fa-address-book" => "fa-address-book",
                  "fas fa-address-card" => "fa-address-card",
                  "far fa-address-card" => "fa-address-card",
                  "fas fa-adjust" => "fa-adjust",
                  "fab fa-adn" => "fa-adn",
                  "fab fa-adversal" => "fa-adversal",
                  "fab fa-affiliatetheme" => "fa-affiliatetheme",
                  "fab fa-algolia" => "fa-algolia",
                  "fas fa-align-center" => "fa-align-center",
                  "fas fa-align-justify" => "fa-align-justify",
                  "fas fa-align-left" => "fa-align-left",
                  "fas fa-align-right" => "fa-align-right",
                  "fab fa-amazon" => "fa-amazon",
                  "fab fa-amazon-pay" => "fa-amazon-pay",
                  "fas fa-ambulance" => "fa-ambulance",
                  "fas fa-american-sign-language-interpreting" => "fa-american-sign-language-interpreting",
                  "fab fa-amilia" => "fa-amilia",
                  "fas fa-anchor" => "fa-anchor",
                  "fab fa-android" => "fa-android",
                  "fab fa-angellist" => "fa-angellist",
                  "fas fa-angle-double-down" => "fa-angle-double-down",
                  "fas fa-angle-double-left" => "fa-angle-double-left",
                  "fas fa-angle-double-right" => "fa-angle-double-right",
                  "fas fa-angle-double-up" => "fa-angle-double-up",
                  "fas fa-angle-down" => "fa-angle-down",
                  "fas fa-angle-left" => "fa-angle-left",
                  "fas fa-angle-right" => "fa-angle-right",
                  "fas fa-angle-up" => "fa-angle-up",
                  "fab fa-angrycreative" => "fa-angrycreative",
                  "fab fa-angular" => "fa-angular",
                  "fab fa-app-store" => "fa-app-store",
                  "fab fa-app-store-ios" => "fa-app-store-ios",
                  "fab fa-apper" => "fa-apper",
                  "fab fa-apple" => "fa-apple",
                  "fab fa-apple-pay" => "fa-apple-pay",
                  "fas fa-archive" => "fa-archive",
                  "fas fa-arrow-alt-circle-down" => "fa-arrow-alt-circle-down",
                  "far fa-arrow-alt-circle-down" => "fa-arrow-alt-circle-down",
                  "fas fa-arrow-alt-circle-left" => "fa-arrow-alt-circle-left",
                  "far fa-arrow-alt-circle-left" => "fa-arrow-alt-circle-left",
                  "fas fa-arrow-alt-circle-right" => "fa-arrow-alt-circle-right",
                  "far fa-arrow-alt-circle-right" => "fa-arrow-alt-circle-right",
                  "fas fa-arrow-alt-circle-up" => "fa-arrow-alt-circle-up",
                  "far fa-arrow-alt-circle-up" => "fa-arrow-alt-circle-up",
                  "fas fa-arrow-circle-down" => "fa-arrow-circle-down",
                  "fas fa-arrow-circle-left" => "fa-arrow-circle-left",
                  "fas fa-arrow-circle-right" => "fa-arrow-circle-right",
                  "fas fa-arrow-circle-up" => "fa-arrow-circle-up",
                  "fas fa-arrow-down" => "fa-arrow-down",
                  "fas fa-arrow-left" => "fa-arrow-left",
                  "fas fa-arrow-right" => "fa-arrow-right",
                  "fas fa-arrow-up" => "fa-arrow-up",
                  "fas fa-arrows-alt" => "fa-arrows-alt",
                  "fas fa-arrows-alt-h" => "fa-arrows-alt-h",
                  "fas fa-arrows-alt-v" => "fa-arrows-alt-v",
                  "fas fa-assistive-listening-systems" => "fa-assistive-listening-systems",
                  "fas fa-asterisk" => "fa-asterisk",
                  "fab fa-asymmetrik" => "fa-asymmetrik",
                  "fas fa-at" => "fa-at",
                  "fab fa-audible" => "fa-audible",
                  "fas fa-audio-description" => "fa-audio-description",
                  "fab fa-autoprefixer" => "fa-autoprefixer",
                  "fab fa-avianex" => "fa-avianex",
                  "fab fa-aviato" => "fa-aviato",
                  "fab fa-aws" => "fa-aws",
                  "fas fa-backward" => "fa-backward",
                  "fas fa-balance-scale" => "fa-balance-scale",
                  "fas fa-ban" => "fa-ban",
                  "fas fa-band-aid" => "fa-band-aid",
                  "fab fa-bandcamp" => "fa-bandcamp",
                  "fas fa-barcode" => "fa-barcode",
                  "fas fa-bars" => "fa-bars",
                  "fas fa-baseball-ball" => "fa-baseball-ball",
                  "fas fa-basketball-ball" => "fa-basketball-ball",
                  "fas fa-bath" => "fa-bath",
                  "fas fa-battery-empty" => "fa-battery-empty",
                  "fas fa-battery-full" => "fa-battery-full",
                  "fas fa-battery-half" => "fa-battery-half",
                  "fas fa-battery-quarter" => "fa-battery-quarter",
                  "fas fa-battery-three-quarters" => "fa-battery-three-quarters",
                  "fas fa-bed" => "fa-bed",
                  "fas fa-beer" => "fa-beer",
                  "fab fa-behance" => "fa-behance",
                  "fab fa-behance-square" => "fa-behance-square",
                  "fas fa-bell" => "fa-bell",
                  "far fa-bell" => "fa-bell",
                  "fas fa-bell-slash" => "fa-bell-slash",
                  "far fa-bell-slash" => "fa-bell-slash",
                  "fas fa-bicycle" => "fa-bicycle",
                  "fab fa-bimobject" => "fa-bimobject",
                  "fas fa-binoculars" => "fa-binoculars",
                  "fas fa-birthday-cake" => "fa-birthday-cake",
                  "fab fa-bitbucket" => "fa-bitbucket",
                  "fab fa-bitcoin" => "fa-bitcoin",
                  "fab fa-bity" => "fa-bity",
                  "fab fa-black-tie" => "fa-black-tie",
                  "fab fa-blackberry" => "fa-blackberry",
                  "fas fa-blind" => "fa-blind",
                  "fab fa-blogger" => "fa-blogger",
                  "fab fa-blogger-b" => "fa-blogger-b",
                  "fab fa-bluetooth" => "fa-bluetooth",
                  "fab fa-bluetooth-b" => "fa-bluetooth-b",
                  "fas fa-bold" => "fa-bold",
                  "fas fa-bolt" => "fa-bolt",
                  "fas fa-bomb" => "fa-bomb",
                  "fas fa-book" => "fa-book",
                  "fas fa-bookmark" => "fa-bookmark",
                  "far fa-bookmark" => "fa-bookmark",
                  "fas fa-bowling-ball" => "fa-bowling-ball",
                  "fas fa-box" => "fa-box",
                  "fas fa-boxes" => "fa-boxes",
                  "fas fa-braille" => "fa-braille",
                  "fas fa-briefcase" => "fa-briefcase",
                  "fab fa-btc" => "fa-btc",
                  "fas fa-bug" => "fa-bug",
                  "fas fa-building" => "fa-building",
                  "far fa-building" => "fa-building",
                  "fas fa-bullhorn" => "fa-bullhorn",
                  "fas fa-bullseye" => "fa-bullseye",
                  "fab fa-buromobelexperte" => "fa-buromobelexperte",
                  "fas fa-bus" => "fa-bus",
                  "fab fa-buysellads" => "fa-buysellads",
                  "fas fa-calculator" => "fa-calculator",
                  "fas fa-calendar" => "fa-calendar",
                  "far fa-calendar" => "fa-calendar",
                  "fas fa-calendar-alt" => "fa-calendar-alt",
                  "far fa-calendar-alt" => "fa-calendar-alt",
                  "fas fa-calendar-check" => "fa-calendar-check",
                  "far fa-calendar-check" => "fa-calendar-check",
                  "fas fa-calendar-minus" => "fa-calendar-minus",
                  "far fa-calendar-minus" => "fa-calendar-minus",
                  "fas fa-calendar-plus" => "fa-calendar-plus",
                  "far fa-calendar-plus" => "fa-calendar-plus",
                  "fas fa-calendar-times" => "fa-calendar-times",
                  "far fa-calendar-times" => "fa-calendar-times",
                  "fas fa-camera" => "fa-camera",
                  "fas fa-camera-retro" => "fa-camera-retro",
                  "fas fa-car" => "fa-car",
                  "fas fa-caret-down" => "fa-caret-down",
                  "fas fa-caret-left" => "fa-caret-left",
                  "fas fa-caret-right" => "fa-caret-right",
                  "fas fa-caret-square-down" => "fa-caret-square-down",
                  "far fa-caret-square-down" => "fa-caret-square-down",
                  "fas fa-caret-square-left" => "fa-caret-square-left",
                  "far fa-caret-square-left" => "fa-caret-square-left",
                  "fas fa-caret-square-right" => "fa-caret-square-right",
                  "far fa-caret-square-right" => "fa-caret-square-right",
                  "fas fa-caret-square-up" => "fa-caret-square-up",
                  "far fa-caret-square-up" => "fa-caret-square-up",
                  "fas fa-caret-up" => "fa-caret-up",
                  "fas fa-cart-arrow-down" => "fa-cart-arrow-down",
                  "fas fa-cart-plus" => "fa-cart-plus",
                  "fab fa-cc-amazon-pay" => "fa-cc-amazon-pay",
                  "fab fa-cc-amex" => "fa-cc-amex",
                  "fab fa-cc-apple-pay" => "fa-cc-apple-pay",
                  "fab fa-cc-diners-club" => "fa-cc-diners-club",
                  "fab fa-cc-discover" => "fa-cc-discover",
                  "fab fa-cc-jcb" => "fa-cc-jcb",
                  "fab fa-cc-mastercard" => "fa-cc-mastercard",
                  "fab fa-cc-paypal" => "fa-cc-paypal",
                  "fab fa-cc-stripe" => "fa-cc-stripe",
                  "fab fa-cc-visa" => "fa-cc-visa",
                  "fab fa-centercode" => "fa-centercode",
                  "fas fa-certificate" => "fa-certificate",
                  "fas fa-chart-area" => "fa-chart-area",
                  "fas fa-chart-bar" => "fa-chart-bar",
                  "far fa-chart-bar" => "fa-chart-bar",
                  "fas fa-chart-line" => "fa-chart-line",
                  "fas fa-chart-pie" => "fa-chart-pie",
                  "fas fa-check" => "fa-check",
                  "fas fa-check-circle" => "fa-check-circle",
                  "far fa-check-circle" => "fa-check-circle",
                  "fas fa-check-square" => "fa-check-square",
                  "far fa-check-square" => "fa-check-square",
                  "fas fa-chess" => "fa-chess",
                  "fas fa-chess-bishop" => "fa-chess-bishop",
                  "fas fa-chess-board" => "fa-chess-board",
                  "fas fa-chess-king" => "fa-chess-king",
                  "fas fa-chess-knight" => "fa-chess-knight",
                  "fas fa-chess-pawn" => "fa-chess-pawn",
                  "fas fa-chess-queen" => "fa-chess-queen",
                  "fas fa-chess-rook" => "fa-chess-rook",
                  "fas fa-chevron-circle-down" => "fa-chevron-circle-down",
                  "fas fa-chevron-circle-left" => "fa-chevron-circle-left",
                  "fas fa-chevron-circle-right" => "fa-chevron-circle-right",
                  "fas fa-chevron-circle-up" => "fa-chevron-circle-up",
                  "fas fa-chevron-down" => "fa-chevron-down",
                  "fas fa-chevron-left" => "fa-chevron-left",
                  "fas fa-chevron-right" => "fa-chevron-right",
                  "fas fa-chevron-up" => "fa-chevron-up",
                  "fas fa-child" => "fa-child",
                  "fab fa-chrome" => "fa-chrome",
                  "fas fa-circle" => "fa-circle",
                  "far fa-circle" => "fa-circle",
                  "fas fa-circle-notch" => "fa-circle-notch",
                  "fas fa-clipboard" => "fa-clipboard",
                  "far fa-clipboard" => "fa-clipboard",
                  "fas fa-clipboard-check" => "fa-clipboard-check",
                  "fas fa-clipboard-list" => "fa-clipboard-list",
                  "fas fa-clock" => "fa-clock",
                  "far fa-clock" => "fa-clock",
                  "fas fa-clone" => "fa-clone",
                  "far fa-clone" => "fa-clone",
                  "fas fa-closed-captioning" => "fa-closed-captioning",
                  "far fa-closed-captioning" => "fa-closed-captioning",
                  "fas fa-cloud" => "fa-cloud",
                  "fas fa-cloud-download-alt" => "fa-cloud-download-alt",
                  "fas fa-cloud-upload-alt" => "fa-cloud-upload-alt",
                  "fab fa-cloudscale" => "fa-cloudscale",
                  "fab fa-cloudsmith" => "fa-cloudsmith",
                  "fab fa-cloudversify" => "fa-cloudversify",
                  "fas fa-code" => "fa-code",
                  "fas fa-code-branch" => "fa-code-branch",
                  "fab fa-codepen" => "fa-codepen",
                  "fab fa-codiepie" => "fa-codiepie",
                  "fas fa-coffee" => "fa-coffee",
                  "fas fa-cog" => "fa-cog",
                  "fas fa-cogs" => "fa-cogs",
                  "fas fa-columns" => "fa-columns",
                  "fas fa-comment" => "fa-comment",
                  "far fa-comment" => "fa-comment",
                  "fas fa-comment-alt" => "fa-comment-alt",
                  "far fa-comment-alt" => "fa-comment-alt",
                  "fas fa-comments" => "fa-comments",
                  "far fa-comments" => "fa-comments",
                  "fas fa-compass" => "fa-compass",
                  "far fa-compass" => "fa-compass",
                  "fas fa-compress" => "fa-compress",
                  "fab fa-connectdevelop" => "fa-connectdevelop",
                  "fab fa-contao" => "fa-contao",
                  "fas fa-copy" => "fa-copy",
                  "far fa-copy" => "fa-copy",
                  "fas fa-copyright" => "fa-copyright",
                  "far fa-copyright" => "fa-copyright",
                  "fab fa-cpanel" => "fa-cpanel",
                  "fab fa-creative-commons" => "fa-creative-commons",
                  "fas fa-credit-card" => "fa-credit-card",
                  "far fa-credit-card" => "fa-credit-card",
                  "fas fa-crop" => "fa-crop",
                  "fas fa-crosshairs" => "fa-crosshairs",
                  "fab fa-css3" => "fa-css3",
                  "fab fa-css3-alt" => "fa-css3-alt",
                  "fas fa-cube" => "fa-cube",
                  "fas fa-cubes" => "fa-cubes",
                  "fas fa-cut" => "fa-cut",
                  "fab fa-cuttlefish" => "fa-cuttlefish",
                  "fab fa-d-and-d" => "fa-d-and-d",
                  "fab fa-dashcube" => "fa-dashcube",
                  "fas fa-database" => "fa-database",
                  "fas fa-deaf" => "fa-deaf",
                  "fab fa-delicious" => "fa-delicious",
                  "fab fa-deploydog" => "fa-deploydog",
                  "fab fa-deskpro" => "fa-deskpro",
                  "fas fa-desktop" => "fa-desktop",
                  "fab fa-deviantart" => "fa-deviantart",
                  "fab fa-digg" => "fa-digg",
                  "fab fa-digital-ocean" => "fa-digital-ocean",
                  "fab fa-discord" => "fa-discord",
                  "fab fa-discourse" => "fa-discourse",
                  "fas fa-dna" => "fa-dna",
                  "fab fa-dochub" => "fa-dochub",
                  "fab fa-docker" => "fa-docker",
                  "fas fa-dollar-sign" => "fa-dollar-sign",
                  "fas fa-dolly" => "fa-dolly",
                  "fas fa-dolly-flatbed" => "fa-dolly-flatbed",
                  "fas fa-dot-circle" => "fa-dot-circle",
                  "far fa-dot-circle" => "fa-dot-circle",
                  "fas fa-download" => "fa-download",
                  "fab fa-draft2digital" => "fa-draft2digital",
                  "fab fa-dribbble" => "fa-dribbble",
                  "fab fa-dribbble-square" => "fa-dribbble-square",
                  "fab fa-dropbox" => "fa-dropbox",
                  "fab fa-drupal" => "fa-drupal",
                  "fab fa-dyalog" => "fa-dyalog",
                  "fab fa-earlybirds" => "fa-earlybirds",
                  "fab fa-edge" => "fa-edge",
                  "fas fa-edit" => "fa-edit",
                  "far fa-edit" => "fa-edit",
                  "fas fa-eject" => "fa-eject",
                  "fab fa-elementor" => "fa-elementor",
                  "fas fa-ellipsis-h" => "fa-ellipsis-h",
                  "fas fa-ellipsis-v" => "fa-ellipsis-v",
                  "fab fa-ember" => "fa-ember",
                  "fab fa-empire" => "fa-empire",
                  "fas fa-envelope" => "fa-envelope",
                  "far fa-envelope" => "fa-envelope",
                  "fas fa-envelope-open" => "fa-envelope-open",
                  "far fa-envelope-open" => "fa-envelope-open",
                  "fas fa-envelope-square" => "fa-envelope-square",
                  "fab fa-envira" => "fa-envira",
                  "fas fa-eraser" => "fa-eraser",
                  "fab fa-erlang" => "fa-erlang",
                  "fab fa-ethereum" => "fa-ethereum",
                  "fab fa-etsy" => "fa-etsy",
                  "fas fa-euro-sign" => "fa-euro-sign",
                  "fas fa-exchange-alt" => "fa-exchange-alt",
                  "fas fa-exclamation" => "fa-exclamation",
                  "fas fa-exclamation-circle" => "fa-exclamation-circle",
                  "fas fa-exclamation-triangle" => "fa-exclamation-triangle",
                  "fas fa-expand" => "fa-expand",
                  "fas fa-expand-arrows-alt" => "fa-expand-arrows-alt",
                  "fab fa-expeditedssl" => "fa-expeditedssl",
                  "fas fa-external-link-alt" => "fa-external-link-alt",
                  "fas fa-external-link-square-alt" => "fa-external-link-square-alt",
                  "fas fa-eye" => "fa-eye",
                  "fas fa-eye-dropper" => "fa-eye-dropper",
                  "fas fa-eye-slash" => "fa-eye-slash",
                  "far fa-eye-slash" => "fa-eye-slash",
                  "fab fa-facebook" => "fa-facebook",
                  "fab fa-facebook-f" => "fa-facebook-f",
                  "fab fa-facebook-messenger" => "fa-facebook-messenger",
                  "fab fa-facebook-square" => "fa-facebook-square",
                  "fas fa-fast-backward" => "fa-fast-backward",
                  "fas fa-fast-forward" => "fa-fast-forward",
                  "fas fa-fax" => "fa-fax",
                  "fas fa-female" => "fa-female",
                  "fas fa-fighter-jet" => "fa-fighter-jet",
                  "fas fa-file" => "fa-file",
                  "far fa-file" => "fa-file",
                  "fas fa-file-alt" => "fa-file-alt",
                  "far fa-file-alt" => "fa-file-alt",
                  "fas fa-file-archive" => "fa-file-archive",
                  "far fa-file-archive" => "fa-file-archive",
                  "fas fa-file-audio" => "fa-file-audio",
                  "far fa-file-audio" => "fa-file-audio",
                  "fas fa-file-code" => "fa-file-code",
                  "far fa-file-code" => "fa-file-code",
                  "fas fa-file-excel" => "fa-file-excel",
                  "far fa-file-excel" => "fa-file-excel",
                  "fas fa-file-image" => "fa-file-image",
                  "far fa-file-image" => "fa-file-image",
                  "fas fa-file-pdf" => "fa-file-pdf",
                  "far fa-file-pdf" => "fa-file-pdf",
                  "fas fa-file-powerpoint" => "fa-file-powerpoint",
                  "far fa-file-powerpoint" => "fa-file-powerpoint",
                  "fas fa-file-video" => "fa-file-video",
                  "far fa-file-video" => "fa-file-video",
                  "fas fa-file-word" => "fa-file-word",
                  "far fa-file-word" => "fa-file-word",
                  "fas fa-film" => "fa-film",
                  "fas fa-filter" => "fa-filter",
                  "fas fa-fire" => "fa-fire",
                  "fas fa-fire-extinguisher" => "fa-fire-extinguisher",
                  "fab fa-firefox" => "fa-firefox",
                  "fas fa-first-aid" => "fa-first-aid",
                  "fab fa-first-order" => "fa-first-order",
                  "fab fa-firstdraft" => "fa-firstdraft",
                  "fas fa-flag" => "fa-flag",
                  "far fa-flag" => "fa-flag",
                  "fas fa-flag-checkered" => "fa-flag-checkered",
                  "fas fa-flask" => "fa-flask",
                  "fab fa-flickr" => "fa-flickr",
                  "fab fa-flipboard" => "fa-flipboard",
                  "fab fa-fly" => "fa-fly",
                  "fas fa-folder" => "fa-folder",
                  "far fa-folder" => "fa-folder",
                  "fas fa-folder-open" => "fa-folder-open",
                  "far fa-folder-open" => "fa-folder-open",
                  "fas fa-font" => "fa-font",
                  "fab fa-font-awesome" => "fa-font-awesome",
                  "fab fa-font-awesome-alt" => "fa-font-awesome-alt",
                  "fab fa-font-awesome-flag" => "fa-font-awesome-flag",
                  "fab fa-fonticons" => "fa-fonticons",
                  "fab fa-fonticons-fi" => "fa-fonticons-fi",
                  "fas fa-football-ball" => "fa-football-ball",
                  "fab fa-fort-awesome" => "fa-fort-awesome",
                  "fab fa-fort-awesome-alt" => "fa-fort-awesome-alt",
                  "fab fa-forumbee" => "fa-forumbee",
                  "fas fa-forward" => "fa-forward",
                  "fab fa-foursquare" => "fa-foursquare",
                  "fab fa-free-code-camp" => "fa-free-code-camp",
                  "fab fa-freebsd" => "fa-freebsd",
                  "fas fa-frown" => "fa-frown",
                  "far fa-frown" => "fa-frown",
                  "fas fa-futbol" => "fa-futbol",
                  "far fa-futbol" => "fa-futbol",
                  "fas fa-gamepad" => "fa-gamepad",
                  "fas fa-gavel" => "fa-gavel",
                  "fas fa-gem" => "fa-gem",
                  "far fa-gem" => "fa-gem",
                  "fas fa-genderless" => "fa-genderless",
                  "fab fa-get-pocket" => "fa-get-pocket",
                  "fab fa-gg" => "fa-gg",
                  "fab fa-gg-circle" => "fa-gg-circle",
                  "fas fa-gift" => "fa-gift",
                  "fab fa-git" => "fa-git",
                  "fab fa-git-square" => "fa-git-square",
                  "fab fa-github" => "fa-github",
                  "fab fa-github-alt" => "fa-github-alt",
                  "fab fa-github-square" => "fa-github-square",
                  "fab fa-gitkraken" => "fa-gitkraken",
                  "fab fa-gitlab" => "fa-gitlab",
                  "fab fa-gitter" => "fa-gitter",
                  "fas fa-glass-martini" => "fa-glass-martini",
                  "fab fa-glide" => "fa-glide",
                  "fab fa-glide-g" => "fa-glide-g",
                  "fas fa-globe" => "fa-globe",
                  "fab fa-gofore" => "fa-gofore",
                  "fas fa-golf-ball" => "fa-golf-ball",
                  "fab fa-goodreads" => "fa-goodreads",
                  "fab fa-goodreads-g" => "fa-goodreads-g",
                  "fab fa-google" => "fa-google",
                  "fab fa-google-drive" => "fa-google-drive",
                  "fab fa-google-play" => "fa-google-play",
                  "fab fa-google-plus" => "fa-google-plus",
                  "fab fa-google-plus-g" => "fa-google-plus-g",
                  "fab fa-google-plus-square" => "fa-google-plus-square",
                  "fab fa-google-wallet" => "fa-google-wallet",
                  "fas fa-graduation-cap" => "fa-graduation-cap",
                  "fab fa-gratipay" => "fa-gratipay",
                  "fab fa-grav" => "fa-grav",
                  "fab fa-gripfire" => "fa-gripfire",
                  "fab fa-grunt" => "fa-grunt",
                  "fab fa-gulp" => "fa-gulp",
                  "fas fa-h-square" => "fa-h-square",
                  "fab fa-hacker-news" => "fa-hacker-news",
                  "fab fa-hacker-news-square" => "fa-hacker-news-square",
                  "fas fa-hand-lizard" => "fa-hand-lizard",
                  "far fa-hand-lizard" => "fa-hand-lizard",
                  "fas fa-hand-paper" => "fa-hand-paper",
                  "far fa-hand-paper" => "fa-hand-paper",
                  "fas fa-hand-peace" => "fa-hand-peace",
                  "far fa-hand-peace" => "fa-hand-peace",
                  "fas fa-hand-point-down" => "fa-hand-point-down",
                  "far fa-hand-point-down" => "fa-hand-point-down",
                  "fas fa-hand-point-left" => "fa-hand-point-left",
                  "far fa-hand-point-left" => "fa-hand-point-left",
                  "fas fa-hand-point-right" => "fa-hand-point-right",
                  "far fa-hand-point-right" => "fa-hand-point-right",
                  "fas fa-hand-point-up" => "fa-hand-point-up",
                  "far fa-hand-point-up" => "fa-hand-point-up",
                  "fas fa-hand-pointer" => "fa-hand-pointer",
                  "far fa-hand-pointer" => "fa-hand-pointer",
                  "fas fa-hand-rock" => "fa-hand-rock",
                  "far fa-hand-rock" => "fa-hand-rock",
                  "fas fa-hand-scissors" => "fa-hand-scissors",
                  "far fa-hand-scissors" => "fa-hand-scissors",
                  "fas fa-hand-spock" => "fa-hand-spock",
                  "far fa-hand-spock" => "fa-hand-spock",
                  "fas fa-handshake" => "fa-handshake",
                  "far fa-handshake" => "fa-handshake",
                  "fas fa-hashtag" => "fa-hashtag",
                  "fas fa-hdd" => "fa-hdd",
                  "far fa-hdd" => "fa-hdd",
                  "fas fa-heading" => "fa-heading",
                  "fas fa-headphones" => "fa-headphones",
                  "fas fa-heart" => "fa-heart",
                  "far fa-heart" => "fa-heart",
                  "fas fa-heartbeat" => "fa-heartbeat",
                  "fab fa-hips" => "fa-hips",
                  "fab fa-hire-a-helper" => "fa-hire-a-helper",
                  "fas fa-history" => "fa-history",
                  "fas fa-hockey-puck" => "fa-hockey-puck",
                  "fas fa-home" => "fa-home",
                  "fab fa-hooli" => "fa-hooli",
                  "fas fa-hospital" => "fa-hospital",
                  "far fa-hospital" => "fa-hospital",
                  "fas fa-hospital-symbol" => "fa-hospital-symbol",
                  "fab fa-hotjar" => "fa-hotjar",
                  "fas fa-hourglass" => "fa-hourglass",
                  "far fa-hourglass" => "fa-hourglass",
                  "fas fa-hourglass-end" => "fa-hourglass-end",
                  "fas fa-hourglass-half" => "fa-hourglass-half",
                  "fas fa-hourglass-start" => "fa-hourglass-start",
                  "fab fa-houzz" => "fa-houzz",
                  "fab fa-html5" => "fa-html5",
                  "fab fa-hubspot" => "fa-hubspot",
                  "fas fa-i-cursor" => "fa-i-cursor",
                  "fas fa-id-badge" => "fa-id-badge",
                  "far fa-id-badge" => "fa-id-badge",
                  "fas fa-id-card" => "fa-id-card",
                  "far fa-id-card" => "fa-id-card",
                  "fas fa-image" => "fa-image",
                  "far fa-image" => "fa-image",
                  "fas fa-images" => "fa-images",
                  "far fa-images" => "fa-images",
                  "fab fa-imdb" => "fa-imdb",
                  "fas fa-inbox" => "fa-inbox",
                  "fas fa-indent" => "fa-indent",
                  "fas fa-industry" => "fa-industry",
                  "fas fa-info" => "fa-info",
                  "fas fa-info-circle" => "fa-info-circle",
                  "fab fa-instagram" => "fa-instagram",
                  "fab fa-internet-explorer" => "fa-internet-explorer",
                  "fab fa-ioxhost" => "fa-ioxhost",
                  "fas fa-italic" => "fa-italic",
                  "fab fa-itunes" => "fa-itunes",
                  "fab fa-itunes-note" => "fa-itunes-note",
                  "fab fa-jenkins" => "fa-jenkins",
                  "fab fa-joget" => "fa-joget",
                  "fab fa-joomla" => "fa-joomla",
                  "fab fa-js" => "fa-js",
                  "fab fa-js-square" => "fa-js-square",
                  "fab fa-jsfiddle" => "fa-jsfiddle",
                  "fas fa-key" => "fa-key",
                  "fas fa-keyboard" => "fa-keyboard",
                  "far fa-keyboard" => "fa-keyboard",
                  "fab fa-keycdn" => "fa-keycdn",
                  "fab fa-kickstarter" => "fa-kickstarter",
                  "fab fa-kickstarter-k" => "fa-kickstarter-k",
                  "fab fa-korvue" => "fa-korvue",
                  "fas fa-language" => "fa-language",
                  "fas fa-laptop" => "fa-laptop",
                  "fab fa-laravel" => "fa-laravel",
                  "fab fa-lastfm" => "fa-lastfm",
                  "fab fa-lastfm-square" => "fa-lastfm-square",
                  "fas fa-leaf" => "fa-leaf",
                  "fab fa-leanpub" => "fa-leanpub",
                  "fas fa-lemon" => "fa-lemon",
                  "far fa-lemon" => "fa-lemon",
                  "fab fa-less" => "fa-less",
                  "fas fa-level-down-alt" => "fa-level-down-alt",
                  "fas fa-level-up-alt" => "fa-level-up-alt",
                  "fas fa-life-ring" => "fa-life-ring",
                  "far fa-life-ring" => "fa-life-ring",
                  "fas fa-lightbulb" => "fa-lightbulb",
                  "far fa-lightbulb" => "fa-lightbulb",
                  "fab fa-line" => "fa-line",
                  "fas fa-link" => "fa-link",
                  "fab fa-linkedin" => "fa-linkedin",
                  "fab fa-linkedin-in" => "fa-linkedin-in",
                  "fab fa-linode" => "fa-linode",
                  "fab fa-linux" => "fa-linux",
                  "fas fa-lira-sign" => "fa-lira-sign",
                  "fas fa-list" => "fa-list",
                  "fas fa-list-alt" => "fa-list-alt",
                  "far fa-list-alt" => "fa-list-alt",
                  "fas fa-list-ol" => "fa-list-ol",
                  "fas fa-list-ul" => "fa-list-ul",
                  "fas fa-location-arrow" => "fa-location-arrow",
                  "fas fa-lock" => "fa-lock",
                  "fas fa-lock-open" => "fa-lock-open",
                  "fas fa-long-arrow-alt-down" => "fa-long-arrow-alt-down",
                  "fas fa-long-arrow-alt-left" => "fa-long-arrow-alt-left",
                  "fas fa-long-arrow-alt-right" => "fa-long-arrow-alt-right",
                  "fas fa-long-arrow-alt-up" => "fa-long-arrow-alt-up",
                  "fas fa-low-vision" => "fa-low-vision",
                  "fab fa-lyft" => "fa-lyft",
                  "fab fa-magento" => "fa-magento",
                  "fas fa-magic" => "fa-magic",
                  "fas fa-magnet" => "fa-magnet",
                  "fas fa-male" => "fa-male",
                  "fas fa-map" => "fa-map",
                  "far fa-map" => "fa-map",
                  "fas fa-map-marker" => "fa-map-marker",
                  "fas fa-map-marker-alt" => "fa-map-marker-alt",
                  "fas fa-map-pin" => "fa-map-pin",
                  "fas fa-map-signs" => "fa-map-signs",
                  "fas fa-mars" => "fa-mars",
                  "fas fa-mars-double" => "fa-mars-double",
                  "fas fa-mars-stroke" => "fa-mars-stroke",
                  "fas fa-mars-stroke-h" => "fa-mars-stroke-h",
                  "fas fa-mars-stroke-v" => "fa-mars-stroke-v",
                  "fab fa-maxcdn" => "fa-maxcdn",
                  "fab fa-medapps" => "fa-medapps",
                  "fab fa-medium" => "fa-medium",
                  "fab fa-medium-m" => "fa-medium-m",
                  "fas fa-medkit" => "fa-medkit",
                  "fab fa-medrt" => "fa-medrt",
                  "fab fa-meetup" => "fa-meetup",
                  "fas fa-meh" => "fa-meh",
                  "far fa-meh" => "fa-meh",
                  "fas fa-mercury" => "fa-mercury",
                  "fas fa-microchip" => "fa-microchip",
                  "fas fa-microphone" => "fa-microphone",
                  "fas fa-microphone-slash" => "fa-microphone-slash",
                  "fab fa-microsoft" => "fa-microsoft",
                  "fas fa-minus" => "fa-minus",
                  "fas fa-minus-circle" => "fa-minus-circle",
                  "fas fa-minus-square" => "fa-minus-square",
                  "far fa-minus-square" => "fa-minus-square",
                  "fab fa-mix" => "fa-mix",
                  "fab fa-mixcloud" => "fa-mixcloud",
                  "fab fa-mizuni" => "fa-mizuni",
                  "fas fa-mobile" => "fa-mobile",
                  "fas fa-mobile-alt" => "fa-mobile-alt",
                  "fab fa-modx" => "fa-modx",
                  "fab fa-monero" => "fa-monero",
                  "fas fa-money-bill-alt" => "fa-money-bill-alt",
                  "far fa-money-bill-alt" => "fa-money-bill-alt",
                  "fas fa-moon" => "fa-moon",
                  "far fa-moon" => "fa-moon",
                  "fas fa-motorcycle" => "fa-motorcycle",
                  "fas fa-mouse-pointer" => "fa-mouse-pointer",
                  "fas fa-music" => "fa-music",
                  "fab fa-napster" => "fa-napster",
                  "fas fa-neuter" => "fa-neuter",
                  "fas fa-newspaper" => "fa-newspaper",
                  "far fa-newspaper" => "fa-newspaper",
                  "fab fa-nintendo-switch" => "fa-nintendo-switch",
                  "fab fa-node" => "fa-node",
                  "fab fa-node-js" => "fa-node-js",
                  "fab fa-npm" => "fa-npm",
                  "fab fa-ns8" => "fa-ns8",
                  "fab fa-nutritionix" => "fa-nutritionix",
                  "fas fa-object-group" => "fa-object-group",
                  "far fa-object-group" => "fa-object-group",
                  "fas fa-object-ungroup" => "fa-object-ungroup",
                  "far fa-object-ungroup" => "fa-object-ungroup",
                  "fab fa-odnoklassniki" => "fa-odnoklassniki",
                  "fab fa-odnoklassniki-square" => "fa-odnoklassniki-square",
                  "fab fa-opencart" => "fa-opencart",
                  "fab fa-openid" => "fa-openid",
                  "fab fa-opera" => "fa-opera",
                  "fab fa-optin-monster" => "fa-optin-monster",
                  "fab fa-osi" => "fa-osi",
                  "fas fa-outdent" => "fa-outdent",
                  "fab fa-page4" => "fa-page4",
                  "fab fa-pagelines" => "fa-pagelines",
                  "fas fa-paint-brush" => "fa-paint-brush",
                  "fab fa-palfed" => "fa-palfed",
                  "fas fa-pallet" => "fa-pallet",
                  "fas fa-paper-plane" => "fa-paper-plane",
                  "far fa-paper-plane" => "fa-paper-plane",
                  "fas fa-paperclip" => "fa-paperclip",
                  "fas fa-paragraph" => "fa-paragraph",
                  "fas fa-paste" => "fa-paste",
                  "fab fa-patreon" => "fa-patreon",
                  "fas fa-pause" => "fa-pause",
                  "fas fa-pause-circle" => "fa-pause-circle",
                  "far fa-pause-circle" => "fa-pause-circle",
                  "fas fa-paw" => "fa-paw",
                  "fab fa-paypal" => "fa-paypal",
                  "fas fa-pen-square" => "fa-pen-square",
                  "fas fa-pencil-alt" => "fa-pencil-alt",
                  "fas fa-percent" => "fa-percent",
                  "fab fa-periscope" => "fa-periscope",
                  "fab fa-phabricator" => "fa-phabricator",
                  "fab fa-phoenix-framework" => "fa-phoenix-framework",
                  "fas fa-phone" => "fa-phone",
                  "fas fa-phone-square" => "fa-phone-square",
                  "fas fa-phone-volume" => "fa-phone-volume",
                  "fab fa-php" => "fa-php",
                  "fab fa-pied-piper" => "fa-pied-piper",
                  "fab fa-pied-piper-alt" => "fa-pied-piper-alt",
                  "fab fa-pied-piper-pp" => "fa-pied-piper-pp",
                  "fas fa-pills" => "fa-pills",
                  "fab fa-pinterest" => "fa-pinterest",
                  "fab fa-pinterest-p" => "fa-pinterest-p",
                  "fab fa-pinterest-square" => "fa-pinterest-square",
                  "fas fa-plane" => "fa-plane",
                  "fas fa-play" => "fa-play",
                  "fas fa-play-circle" => "fa-play-circle",
                  "far fa-play-circle" => "fa-play-circle",
                  "fab fa-playstation" => "fa-playstation",
                  "fas fa-plug" => "fa-plug",
                  "fas fa-plus" => "fa-plus",
                  "fas fa-plus-circle" => "fa-plus-circle",
                  "fas fa-plus-square" => "fa-plus-square",
                  "far fa-plus-square" => "fa-plus-square",
                  "fas fa-podcast" => "fa-podcast",
                  "fas fa-pound-sign" => "fa-pound-sign",
                  "fas fa-power-off" => "fa-power-off",
                  "fas fa-print" => "fa-print",
                  "fab fa-product-hunt" => "fa-product-hunt",
                  "fab fa-pushed" => "fa-pushed",
                  "fas fa-puzzle-piece" => "fa-puzzle-piece",
                  "fab fa-python" => "fa-python",
                  "fab fa-qq" => "fa-qq",
                  "fas fa-qrcode" => "fa-qrcode",
                  "fas fa-question" => "fa-question",
                  "fas fa-question-circle" => "fa-question-circle",
                  "far fa-question-circle" => "fa-question-circle",
                  "fas fa-quidditch" => "fa-quidditch",
                  "fab fa-quinscape" => "fa-quinscape",
                  "fab fa-quora" => "fa-quora",
                  "fas fa-quote-left" => "fa-quote-left",
                  "fas fa-quote-right" => "fa-quote-right",
                  "fas fa-random" => "fa-random",
                  "fab fa-ravelry" => "fa-ravelry",
                  "fab fa-react" => "fa-react",
                  "fab fa-rebel" => "fa-rebel",
                  "fas fa-recycle" => "fa-recycle",
                  "fab fa-red-river" => "fa-red-river",
                  "fab fa-reddit" => "fa-reddit",
                  "fab fa-reddit-alien" => "fa-reddit-alien",
                  "fab fa-reddit-square" => "fa-reddit-square",
                  "fas fa-redo" => "fa-redo",
                  "fas fa-redo-alt" => "fa-redo-alt",
                  "fas fa-registered" => "fa-registered",
                  "far fa-registered" => "fa-registered",
                  "fab fa-rendact" => "fa-rendact",
                  "fab fa-renren" => "fa-renren",
                  "fas fa-reply" => "fa-reply",
                  "fas fa-reply-all" => "fa-reply-all",
                  "fab fa-replyd" => "fa-replyd",
                  "fab fa-resolving" => "fa-resolving",
                  "fas fa-retweet" => "fa-retweet",
                  "fas fa-road" => "fa-road",
                  "fas fa-rocket" => "fa-rocket",
                  "fab fa-rocketchat" => "fa-rocketchat",
                  "fab fa-rockrms" => "fa-rockrms",
                  "fas fa-rss" => "fa-rss",
                  "fas fa-rss-square" => "fa-rss-square",
                  "fas fa-ruble-sign" => "fa-ruble-sign",
                  "fas fa-rupee-sign" => "fa-rupee-sign",
                  "fab fa-safari" => "fa-safari",
                  "fab fa-sass" => "fa-sass",
                  "fas fa-save" => "fa-save",
                  "far fa-save" => "fa-save",
                  "fab fa-schlix" => "fa-schlix",
                  "fab fa-scribd" => "fa-scribd",
                  "fas fa-search" => "fa-search",
                  "fas fa-search-minus" => "fa-search-minus",
                  "fas fa-search-plus" => "fa-search-plus",
                  "fab fa-searchengin" => "fa-searchengin",
                  "fab fa-sellcast" => "fa-sellcast",
                  "fab fa-sellsy" => "fa-sellsy",
                  "fas fa-server" => "fa-server",
                  "fab fa-servicestack" => "fa-servicestack",
                  "fas fa-share" => "fa-share",
                  "fas fa-share-alt" => "fa-share-alt",
                  "fas fa-share-alt-square" => "fa-share-alt-square",
                  "fas fa-share-square" => "fa-share-square",
                  "far fa-share-square" => "fa-share-square",
                  "fas fa-shekel-sign" => "fa-shekel-sign",
                  "fas fa-shield-alt" => "fa-shield-alt",
                  "fas fa-ship" => "fa-ship",
                  "fas fa-shipping-fast" => "fa-shipping-fast",
                  "fab fa-shirtsinbulk" => "fa-shirtsinbulk",
                  "fas fa-shopping-bag" => "fa-shopping-bag",
                  "fas fa-shopping-basket" => "fa-shopping-basket",
                  "fas fa-shopping-cart" => "fa-shopping-cart",
                  "fas fa-shower" => "fa-shower",
                  "fas fa-sign-in-alt" => "fa-sign-in-alt",
                  "fas fa-sign-language" => "fa-sign-language",
                  "fas fa-sign-out-alt" => "fa-sign-out-alt",
                  "fas fa-signal" => "fa-signal",
                  "fab fa-simplybuilt" => "fa-simplybuilt",
                  "fab fa-sistrix" => "fa-sistrix",
                  "fas fa-sitemap" => "fa-sitemap",
                  "fab fa-skyatlas" => "fa-skyatlas",
                  "fab fa-skype" => "fa-skype",
                  "fab fa-slack" => "fa-slack",
                  "fab fa-slack-hash" => "fa-slack-hash",
                  "fas fa-sliders-h" => "fa-sliders-h",
                  "fab fa-slideshare" => "fa-slideshare",
                  "fas fa-smile" => "fa-smile",
                  "far fa-smile" => "fa-smile",
                  "fab fa-snapchat" => "fa-snapchat",
                  "fab fa-snapchat-ghost" => "fa-snapchat-ghost",
                  "fab fa-snapchat-square" => "fa-snapchat-square",
                  "fas fa-snowflake" => "fa-snowflake",
                  "far fa-snowflake" => "fa-snowflake",
                  "fas fa-sort" => "fa-sort",
                  "fas fa-sort-alpha-down" => "fa-sort-alpha-down",
                  "fas fa-sort-alpha-up" => "fa-sort-alpha-up",
                  "fas fa-sort-amount-down" => "fa-sort-amount-down",
                  "fas fa-sort-amount-up" => "fa-sort-amount-up",
                  "fas fa-sort-down" => "fa-sort-down",
                  "fas fa-sort-numeric-down" => "fa-sort-numeric-down",
                  "fas fa-sort-numeric-up" => "fa-sort-numeric-up",
                  "fas fa-sort-up" => "fa-sort-up",
                  "fab fa-soundcloud" => "fa-soundcloud",
                  "fas fa-space-shuttle" => "fa-space-shuttle",
                  "fab fa-speakap" => "fa-speakap",
                  "fas fa-spinner" => "fa-spinner",
                  "fab fa-spotify" => "fa-spotify",
                  "fas fa-square" => "fa-square",
                  "far fa-square" => "fa-square",
                  "fas fa-square-full" => "fa-square-full",
                  "fab fa-stack-exchange" => "fa-stack-exchange",
                  "fab fa-stack-overflow" => "fa-stack-overflow",
                  "fas fa-star" => "fa-star",
                  "far fa-star" => "fa-star",
                  "fas fa-star-half" => "fa-star-half",
                  "far fa-star-half" => "fa-star-half",
                  "fab fa-staylinked" => "fa-staylinked",
                  "fab fa-steam" => "fa-steam",
                  "fab fa-steam-square" => "fa-steam-square",
                  "fab fa-steam-symbol" => "fa-steam-symbol",
                  "fas fa-step-backward" => "fa-step-backward",
                  "fas fa-step-forward" => "fa-step-forward",
                  "fas fa-stethoscope" => "fa-stethoscope",
                  "fab fa-sticker-mule" => "fa-sticker-mule",
                  "fas fa-sticky-note" => "fa-sticky-note",
                  "far fa-sticky-note" => "fa-sticky-note",
                  "fas fa-stop" => "fa-stop",
                  "fas fa-stop-circle" => "fa-stop-circle",
                  "far fa-stop-circle" => "fa-stop-circle",
                  "fas fa-stopwatch" => "fa-stopwatch",
                  "fab fa-strava" => "fa-strava",
                  "fas fa-street-view" => "fa-street-view",
                  "fas fa-strikethrough" => "fa-strikethrough",
                  "fab fa-stripe" => "fa-stripe",
                  "fab fa-stripe-s" => "fa-stripe-s",
                  "fab fa-studiovinari" => "fa-studiovinari",
                  "fab fa-stumbleupon" => "fa-stumbleupon",
                  "fab fa-stumbleupon-circle" => "fa-stumbleupon-circle",
                  "fas fa-subscript" => "fa-subscript",
                  "fas fa-subway" => "fa-subway",
                  "fas fa-suitcase" => "fa-suitcase",
                  "fas fa-sun" => "fa-sun",
                  "far fa-sun" => "fa-sun",
                  "fab fa-superpowers" => "fa-superpowers",
                  "fas fa-superscript" => "fa-superscript",
                  "fab fa-supple" => "fa-supple",
                  "fas fa-sync" => "fa-sync",
                  "fas fa-sync-alt" => "fa-sync-alt",
                  "fas fa-syringe" => "fa-syringe",
                  "fas fa-table" => "fa-table",
                  "fas fa-table-tennis" => "fa-table-tennis",
                  "fas fa-tablet" => "fa-tablet",
                  "fas fa-tablet-alt" => "fa-tablet-alt",
                  "fas fa-tachometer-alt" => "fa-tachometer-alt",
                  "fas fa-tag" => "fa-tag",
                  "fas fa-tags" => "fa-tags",
                  "fas fa-tasks" => "fa-tasks",
                  "fas fa-taxi" => "fa-taxi",
                  "fab fa-telegram" => "fa-telegram",
                  "fab fa-telegram-plane" => "fa-telegram-plane",
                  "fab fa-tencent-weibo" => "fa-tencent-weibo",
                  "fas fa-terminal" => "fa-terminal",
                  "fas fa-text-height" => "fa-text-height",
                  "fas fa-text-width" => "fa-text-width",
                  "fas fa-th" => "fa-th",
                  "fas fa-th-large" => "fa-th-large",
                  "fas fa-th-list" => "fa-th-list",
                  "fab fa-themeisle" => "fa-themeisle",
                  "fas fa-thermometer" => "fa-thermometer",
                  "fas fa-thermometer-empty" => "fa-thermometer-empty",
                  "fas fa-thermometer-full" => "fa-thermometer-full",
                  "fas fa-thermometer-half" => "fa-thermometer-half",
                  "fas fa-thermometer-quarter" => "fa-thermometer-quarter",
                  "fas fa-thermometer-three-quarters" => "fa-thermometer-three-quarters",
                  "fas fa-thumbs-down" => "fa-thumbs-down",
                  "far fa-thumbs-down" => "fa-thumbs-down",
                  "fas fa-thumbs-up" => "fa-thumbs-up",
                  "far fa-thumbs-up" => "fa-thumbs-up",
                  "fas fa-thumbtack" => "fa-thumbtack",
                  "fas fa-ticket-alt" => "fa-ticket-alt",
                  "fas fa-times" => "fa-times",
                  "fas fa-times-circle" => "fa-times-circle",
                  "far fa-times-circle" => "fa-times-circle",
                  "fas fa-tint" => "fa-tint",
                  "fas fa-toggle-off" => "fa-toggle-off",
                  "fas fa-toggle-on" => "fa-toggle-on",
                  "fas fa-trademark" => "fa-trademark",
                  "fas fa-train" => "fa-train",
                  "fas fa-transgender" => "fa-transgender",
                  "fas fa-transgender-alt" => "fa-transgender-alt",
                  "fas fa-trash" => "fa-trash",
                  "fas fa-trash-alt" => "fa-trash-alt",
                  "far fa-trash-alt" => "fa-trash-alt",
                  "fas fa-tree" => "fa-tree",
                  "fab fa-trello" => "fa-trello",
                  "fab fa-tripadvisor" => "fa-tripadvisor",
                  "fas fa-trophy" => "fa-trophy",
                  "fas fa-truck" => "fa-truck",
                  "fas fa-tty" => "fa-tty",
                  "fab fa-tumblr" => "fa-tumblr",
                  "fab fa-tumblr-square" => "fa-tumblr-square",
                  "fas fa-tv" => "fa-tv",
                  "fab fa-twitch" => "fa-twitch",
                  "fab fa-twitter" => "fa-twitter",
                  "fab fa-twitter-square" => "fa-twitter-square",
                  "fab fa-typo3" => "fa-typo3",
                  "fab fa-uber" => "fa-uber",
                  "fab fa-uikit" => "fa-uikit",
                  "fas fa-umbrella" => "fa-umbrella",
                  "fas fa-underline" => "fa-underline",
                  "fas fa-undo" => "fa-undo",
                  "fas fa-undo-alt" => "fa-undo-alt",
                  "fab fa-uniregistry" => "fa-uniregistry",
                  "fas fa-universal-access" => "fa-universal-access",
                  "fas fa-university" => "fa-university",
                  "fas fa-unlink" => "fa-unlink",
                  "fas fa-unlock" => "fa-unlock",
                  "fas fa-unlock-alt" => "fa-unlock-alt",
                  "fab fa-untappd" => "fa-untappd",
                  "fas fa-upload" => "fa-upload",
                  "fab fa-usb" => "fa-usb",
                  "fas fa-user" => "fa-user",
                  "far fa-user" => "fa-user",
                  "fas fa-user-circle" => "fa-user-circle",
                  "far fa-user-circle" => "fa-user-circle",
                  "fas fa-user-md" => "fa-user-md",
                  "fas fa-user-plus" => "fa-user-plus",
                  "fas fa-user-secret" => "fa-user-secret",
                  "fas fa-user-times" => "fa-user-times",
                  "fas fa-users" => "fa-users",
                  "fab fa-ussunnah" => "fa-ussunnah",
                  "fas fa-utensil-spoon" => "fa-utensil-spoon",
                  "fas fa-utensils" => "fa-utensils",
                  "fab fa-vaadin" => "fa-vaadin",
                  "fas fa-venus" => "fa-venus",
                  "fas fa-venus-double" => "fa-venus-double",
                  "fas fa-venus-mars" => "fa-venus-mars",
                  "fab fa-viacoin" => "fa-viacoin",
                  "fab fa-viadeo" => "fa-viadeo",
                  "fab fa-viadeo-square" => "fa-viadeo-square",
                  "fab fa-viber" => "fa-viber",
                  "fas fa-video" => "fa-video",
                  "fab fa-vimeo" => "fa-vimeo",
                  "fab fa-vimeo-square" => "fa-vimeo-square",
                  "fab fa-vimeo-v" => "fa-vimeo-v",
                  "fab fa-vine" => "fa-vine",
                  "fab fa-vk" => "fa-vk",
                  "fab fa-vnv" => "fa-vnv",
                  "fas fa-volleyball-ball" => "fa-volleyball-ball",
                  "fas fa-volume-down" => "fa-volume-down",
                  "fas fa-volume-off" => "fa-volume-off",
                  "fas fa-volume-up" => "fa-volume-up",
                  "fab fa-vuejs" => "fa-vuejs",
                  "fas fa-warehouse" => "fa-warehouse",
                  "fab fa-weibo" => "fa-weibo",
                  "fas fa-weight" => "fa-weight",
                  "fab fa-weixin" => "fa-weixin",
                  "fab fa-whatsapp" => "fa-whatsapp",
                  "fab fa-whatsapp-square" => "fa-whatsapp-square",
                  "fas fa-wheelchair" => "fa-wheelchair",
                  "fab fa-whmcs" => "fa-whmcs",
                  "fas fa-wifi" => "fa-wifi",
                  "fab fa-wikipedia-w" => "fa-wikipedia-w",
                  "fas fa-window-close" => "fa-window-close",
                  "far fa-window-close" => "fa-window-close",
                  "fas fa-window-maximize" => "fa-window-maximize",
                  "far fa-window-maximize" => "fa-window-maximize",
                  "fas fa-window-minimize" => "fa-window-minimize",
                  "far fa-window-minimize" => "fa-window-minimize",
                  "fas fa-window-restore" => "fa-window-restore",
                  "far fa-window-restore" => "fa-window-restore",
                  "fab fa-windows" => "fa-windows",
                  "fas fa-won-sign" => "fa-won-sign",
                  "fab fa-wordpress" => "fa-wordpress",
                  "fab fa-wordpress-simple" => "fa-wordpress-simple",
                  "fab fa-wpbeginner" => "fa-wpbeginner",
                  "fab fa-wpexplorer" => "fa-wpexplorer",
                  "fab fa-wpforms" => "fa-wpforms",
                  "fas fa-wrench" => "fa-wrench",
                  "fab fa-xbox" => "fa-xbox",
                  "fab fa-xing" => "fa-xing",
                  "fab fa-xing-square" => "fa-xing-square",
                  "fab fa-y-combinator" => "fa-y-combinator",
                  "fab fa-yahoo" => "fa-yahoo",
                  "fab fa-yandex" => "fa-yandex",
                  "fab fa-yandex-international" => "fa-yandex-international",
                  "fab fa-yelp" => "fa-yelp",
                  "fas fa-yen-sign" => "fa-yen-sign",
                  "fab fa-yoast" => "fa-yoast",
                  "fab fa-youtube" => "fa-youtube",
                  "fab fa-youtube-square" => "fa-youtube-square",
            ];
      }

}
