<?php
/**
 * @author  UiGigs
 * @since   1.0
 * @version 1.0
 */

namespace UiGigs\staco;
use UiGigs\staco\staco;
use UiGigs\staco\Helper;
class Layouts {

	public function __construct() {
		add_action( 'template_redirect', array( $this, 'layout_settings' ) );
	}
	public function layout_settings() {

		// Single Pages
        if( is_single() || is_page() ) {
            $post_type = get_post_type();
            $post_id   = get_the_id();
            switch( $post_type ) {
                case 'page':
                $prefix = 'page';
                break;	  		  
                case 'staco_team':
                $prefix = 'team';
                break;  
                default:
                $prefix = 'single_post';
                break;
            }
			
			$layout_settings = get_post_meta( $post_id, 'staco_layout_settings', true );

            staco::$layout = ( empty( $layout_settings['staco_layout'] ) || $layout_settings['staco_layout']  == 'default' ) ? staco::$options[$prefix . '_layout'] : $layout_settings['staco_layout'];
			
			staco::$header_area = ( empty( $layout_settings['staco_header_area'] ) || $layout_settings['staco_header_area'] == 'default' ) ? staco::$options['header_area'] : $layout_settings['staco_header_area'];
            
            staco::$header_style = ( empty( $layout_settings['staco_header'] ) || $layout_settings['staco_header'] == 'default' ) ? staco::$options['header_style'] : $layout_settings['staco_header'];

            staco::$tr_header = ( empty( $layout_settings['staco_tr_header'] ) || $layout_settings['staco_tr_header'] == 'default' ) ? staco::$options['tr_header'] : $layout_settings['staco_tr_header'];

            staco::$footer_area = ( empty( $layout_settings['staco_footer_area'] ) || $layout_settings['staco_footer_area'] == 'default' ) ? staco::$options['footer_area'] : $layout_settings['staco_footer_area'];
			
            staco::$footer_style = ( empty( $layout_settings['staco_footer'] ) || $layout_settings['staco_footer'] == 'default' ) ? staco::$options['footer_style'] : $layout_settings['staco_footer'];

            staco::$has_banner = ( empty( $layout_settings['staco_banner'] ) || $layout_settings['staco_banner'] == 'default' ) ? staco::$options[$prefix . '_banner'] : $layout_settings['staco_banner'];
            
            staco::$has_breadcrumb = ( empty( $layout_settings['staco_breadcrumb'] ) || $layout_settings['staco_breadcrumb'] == 'default' ) ? staco::$options[ $prefix . '_breadcrumb'] : $layout_settings['staco_breadcrumb'];
            
            staco::$bgcolor = empty( $layout_settings['staco_banner_bgcolor'] ) ? staco::$options[$prefix . '_bgcolor'] : $layout_settings['staco_banner_bgcolor'];

            staco::$opacity = empty( $layout_settings['staco_banner_bgopacity'] ) ? staco::$options[$prefix . '_bgopacity'] : $layout_settings['staco_banner_bgopacity'];
			

			if( !empty( $layout_settings['staco_banner_bgimg'] ) ) {
                $attch_url      = wp_get_attachment_image_src( $layout_settings['staco_banner_bgimg'], 'full', true );
                staco::$bgimg = $attch_url[0];
            } elseif( !empty( staco::$options[$prefix . '_bgimg'] ) ) {
                $attch_url      = wp_get_attachment_image_src( staco::$options[$prefix . '_bgimg'], 'full', true );
                staco::$bgimg = $attch_url[0];
            } else {
                staco::$bgimg = '';
            }

            $padding_top = ( empty( $layout_settings['staco_top_padding'] ) || $layout_settings['staco_top_padding'] == 'default' ) ? staco::$options[$prefix . '_padding_top'] : $layout_settings['staco_top_padding'];
            
            staco::$padding_top = (int) $padding_top;

            
            $padding_bottom = ( empty( $layout_settings['staco_bottom_padding'] ) || $layout_settings['staco_bottom_padding'] == 'default' ) ? staco::$options[$prefix . '_padding_bottom'] : $layout_settings['staco_bottom_padding'];
            
            staco::$padding_bottom = (int) $padding_bottom;
        }
        
        // Blog and Archive
        elseif( is_home() || is_archive() || is_search() || is_404() ) {
            if( is_search() ) {
                $prefix = 'search';
            } else if( is_404() ) {
                $prefix                                = 'error';
                staco::$options[$prefix . '_layout'] = 'full-width';
			} elseif( is_post_type_archive( "staco_team" ) || is_tax( "staco_team_category" ) ) {
                $prefix = 'team_archive'; 
			} else {
                $prefix = 'blog';
            }
            
            staco::$layout         = staco::$options[$prefix . '_layout'];
            staco::$tr_header      = staco::$options['tr_header'];
            staco::$header_area    = staco::$options['header_area'];
            staco::$header_style   = staco::$options['header_style'];
            staco::$footer_area    = staco::$options['footer_area'];
            staco::$footer_style   = staco::$options['footer_style'];
            staco::$has_banner     = staco::$options[$prefix . '_banner'];
            staco::$has_breadcrumb = staco::$options[$prefix . '_breadcrumb'];
            staco::$bgcolor        = staco::$options[$prefix . '_bgcolor'];
            staco::$opacity        = staco::$options[$prefix . '_bgopacity'];
            staco::$padding_top    = staco::$options[$prefix . '_padding_top'];
            staco::$padding_bottom = staco::$options[$prefix . '_padding_bottom'];
			
            if( !empty( staco::$options[$prefix . '_bgimg'] ) ) {
                $attch_url      = wp_get_attachment_image_src( staco::$options[$prefix . '_bgimg'], 'full', true );
                staco::$bgimg = $attch_url[0];
            } else {
                staco::$bgimg = '';
            }
        }
	}
}
new Layouts;
