<?php
/**
 * @author  UiGigs
 * @since   1.0
 * @version 1.1
 */

namespace UiGigs\staco;
use UiGigs\staco\staco;
use UiGigs\staco\Helper;
use \WP_Query;
use Elementor\Plugin;

class Scripts {
	public $staco  = staco_THEME_PREFIX;
	public $version = staco_THEME_VERSION;	
	public function __construct() {
		add_action( 'wp_enqueue_scripts', array( $this, 'register_scripts' ), 12 );
		add_action( 'elementor/frontend/after_enqueue_scripts', array( $this, 'e_anim_dequeue' ), 99999 );
		add_action( 'wp_enqueue_scripts', array( $this, 'enqueue_scripts' ), 15 );		
		add_action( 'admin_enqueue_scripts', array( $this, 'admin_conditional_scripts' ), 1 );
	}

	public function fonts_url() {
		$fonts_url = '';
	    $subsets = 'DM Sans';
	    $bodyFont = 'DM Sans';
	    $bodyFW = '500';
	    $menuFont = 'DM Sans';
	    $menuFontW = '400';
	    $offmenuFont = 'DM Sans';
	    $offmenuFontW = '500';
	    $hFont = 'Montserrat Alternates';
	    $hFontW = '700';
	    $h1Font = '';
	    $h2Font = '';
	    $h3Font = '';
	    $h4Font = '';
	    $h5Font = '';
	    $h6Font = '';

	    // Body Font
	    $body_font  = json_decode( staco::$options['typo_body'], true );
	    if ($body_font['font'] == 'DM Sans') {
	    	$bodyFont = 'DM Sans';
	    } else {
	    	$bodyFont = $body_font['font'];
	    }
	    $bodyFontW = $body_font['regularweight'];

	    // Menu Font
	    $menu_font  = json_decode( staco::$options['typo_menu'], true );
	    if ($menu_font['font'] == 'DM Sans') {
		    $menuFont = 'Montserrat Alternates';
		} else {
	    	$menuFont = $menu_font['font'];
		}
	    $menuFontW = $menu_font['regularweight'];

	    // Heading Font Settings
	    $h_font  = json_decode( staco::$options['typo_heading'], true );
	    if ($h_font['font'] == 'Montserrat Alternates') {
		    $hFont = 'Montserrat Alternates';
		} else {
			$hFont = $h_font['font'];
		}
	    $hFontW = $h_font['regularweight'];
	    $h1_font  = json_decode( staco::$options['typo_h1'], true );
	    $h2_font  = json_decode( staco::$options['typo_h2'], true );
	    $h3_font  = json_decode( staco::$options['typo_h3'], true );
	    $h4_font  = json_decode( staco::$options['typo_h4'], true );
	    $h5_font  = json_decode( staco::$options['typo_h5'], true );
	    $h6_font  = json_decode( staco::$options['typo_h6'], true );

	    if ( 'off' !== _x( 'on', 'Google font: on or off', 'staco' ) ) {

		    if (!empty($h1_font['font'])) {
		        if ($h1_font['font'] == 'Montserrat Alternates') {
				    $h1Font = $hFont;
				    $h1FontW = $hFontW;
				} else {
					$h1Font = $h2_font['font'];
		        	$h1FontW = $h1_font['regularweight'];
				}
		    } if (!empty($h2_font['font'])) {
		    	if ($h2_font['font'] == 'Montserrat Alternates') {
				    $h2Font = $hFont;
				    $h2FontW = $hFontW;
				} else {
					$h2Font = $h2_font['font'];
		        	$h2FontW = $h2_font['regularweight'];
				}
		    } if (!empty($h3_font['font'])) {
		        if ($h3_font['font'] == 'Montserrat Alternates') {
				    $h3Font = $hFont;
				    $h3FontW = $hFontW;
				} else {
					$h3Font = $h3_font['font'];
		        	$h3FontW = $h3_font['regularweight'];
				}
		    } if (!empty($h4_font['font'])) {
		        if ($h4_font['font'] == 'Montserrat Alternates') {
				    $h4Font = $hFont;
				    $h4FontW = $hFontW;
				} else {
					$h4Font = $h4_font['font'];
		        	$h4FontW = $h4_font['regularweight'];
				}
		    } if (!empty($h5_font['font'])) {
		        if ($h5_font['font'] == 'Montserrat Alternates') {
				    $h5Font = $hFont;
				    $h5FontW = $hFontW;
				} else {
					$h5Font = $h5_font['font'];
		        	$h5FontW = $h5_font['regularweight'];
				}
		    } if (!empty($h6_font['font'])) {
		    	 if ($h6_font['font'] == 'Montserrat Alternates') {
				    $h6Font = $hFont;
				    $h6FontW = $hFontW;
				} else {
					$h6Font = $h6_font['font'];
		        	$h6FontW = $h6_font['regularweight'];
				}
		    }

		    $check_families = array();
		    $font_families = array();

			// Body Font
			if ( 'off' !== $bodyFont )
				$font_families[] = $bodyFont.':'.$bodyFW;
				$check_families[] = $bodyFont;

			// Menu Font
			if ( 'off' !== $menuFont )
				if ( !in_array( $menuFont, $check_families ) ) {
					$font_families[] = $menuFont.':'.$menuFontW;
					$check_families[] = $menuFont;
				}

			// Offcanvas Menu Font
			if ( 'off' !== $offmenuFont )
				if ( !in_array( $offmenuFont, $check_families ) ) {
					$font_families[] = $offmenuFont.':'.$offmenuFontW;
					$check_families[] = $offmenuFont;
				}

			// Heading Font
			if ( 'off' !== $hFont )
				if (!in_array( $hFont, $check_families )) {
					$font_families[] = $hFont.':'.$hFontW;
					$check_families[] = $hFont;
				}

			// Heading 1 Font
			if (!empty($h1_font['font'])) {
				if ( 'off' !== $h1Font )
					if (!in_array( $h1Font, $check_families )) {
						$font_families[] = $h1Font.':'.$h1FontW;
						$check_families[] = $h1Font;
					}
			}
			// Heading 2 Font
			if (!empty($h2_font['font'])) {
				if ( 'off' !== $h2Font )
					if (!in_array( $h2Font, $check_families )) {
						$font_families[] = $h2Font.':'.$h2FontW;
						$check_families[] = $h2Font;
					}
			}
			// Heading 3 Font
			if (!empty($h3_font['font'])) {
				if ( 'off' !== $h3Font )
					if (!in_array( $h3Font, $check_families )) {
						$font_families[] = $h3Font.':'.$h3FontW;
						$check_families[] = $h3Font;
					}
			}
			// Heading 4 Font
			if (!empty($h4_font['font'])) {
				if ( 'off' !== $h4Font )
					if (!in_array( $h4Font, $check_families )) {
						$font_families[] = $h4Font.':'.$h4FontW;
						$check_families[] = $h4Font;
					}
			}

			// Heading 5 Font
			if (!empty($h5_font['font'])) {
				if ( 'off' !== $h5Font )
					if (!in_array( $h5Font, $check_families )) {
						$font_families[] = $h5Font.':'.$h5FontW;
						$check_families[] = $h5Font;
					}
			}
			// Heading 6 Font
			if (!empty($h6_font['font'])) {
				if ( 'off' !== $h6Font )
					if (!in_array( $h6Font, $check_families )) {
						$font_families[] = $h6Font.':'.$h6FontW;
						$check_families[] = $h6Font;
					}
			}
		    $final_fonts = array_unique( $font_families );
		    $query_args = array(
		        'family' => urlencode( implode( '|', $final_fonts ) ),
		        // 'subset' => urlencode( $subsets ),
		        'display' => urlencode( 'fallback' ),
		    );
		    $fonts_url = add_query_arg( $query_args, "//fonts.googleapis.com/css" );
		}
		
    	return esc_url_raw( $fonts_url );
	}

	function e_anim_dequeue(){
		wp_deregister_style( 'e-animations' );
		wp_dequeue_style( 'e-animations' );
	}
	public function register_scripts(){
		wp_deregister_style( 'font-awesome');
		/* = CSS
		===========================================================*/
		// Bootstrap css
		wp_register_style( 'bootstrap',     Helper::get_nomin_css( 'bootstrap.min' ), array(), $this->version );
		// asPieProgress css
		wp_register_style( 'asPieProgress', Helper::get_nomin_css( 'asPieProgress.min' ), array(), $this->version );
		// headding-title css
		wp_register_style( 'headding-css',  Helper::get_nomin_css( 'headding-title' ), array(), $this->version );
		// lightbox css
		wp_register_style( 'lightbox',      Helper::get_nomin_css( 'lightbox' ), array(), $this->version );
		// venobox css
		wp_register_style( 'venobox',       Helper::get_nomin_css( 'venobox.min' ), array(), $this->version );
		// slick css
		wp_register_style( 'swiper.min',    Helper::get_nomin_css( 'swiper' ), array(), $this->version );
		// slick css
		wp_register_style( 'slick-css',     Helper::get_nomin_css( 'slick' ), array(), $this->version );
		wp_register_style( 'slick-theme',   Helper::get_nomin_css( 'slick-theme' ), array(), $this->version );
		// Main Theme Style
		wp_register_style( 'staco-style', 	Helper::get_nomin_css( 'style' ), array(), $this->version );
		wp_register_style( 'custom',      	Helper::get_nomin_css( 'custom' ), array(), $this->version );
		wp_register_style( 'responsive',  	Helper::get_nomin_css( 'responsive' ), array(), $this->version );

		/* = JS 
		======================================================================*/
		// Bootstrap	
		wp_register_script( 'bootstrap',  Helper::get_js( 'bootstrap.min' ), array( 'jquery' ), $this->version, true );
		// iconify js
		wp_register_script( 'iconify', 	  Helper::get_nomin_js( 'iconify.min' ), array( 'jquery' ), $this->version, true );
		// swiper
		wp_register_script( 'swiper-min', Helper::get_js( 'swiper.min' ), array( 'jquery' ), $this->version, true );
		// slick
		wp_register_script( 'slick-js',    Helper::get_js( 'slick.min' ), array( 'jquery' ), $this->version, true );
		wp_register_script( 'slider-init', Helper::get_js( 'slider-init' ), array( 'jquery' ), $this->version, true );
		// countdown
		wp_register_script( 'countdown',   Helper::get_js( 'jquery.countdown.min' ), array( 'jquery' ), $this->version, true );
		// lightbox js
		wp_register_script( 'lightbox-js', Helper::get_nomin_js( 'lightbox' ), array( 'jquery' ), $this->version, true );
		// venobox js
		wp_register_script( 'venobox-js',  Helper::get_nomin_js( 'venobox.min' ), array( 'jquery' ), $this->version, true );
		// parallax js
		wp_register_script( 'parallax-js', Helper::get_nomin_js( 'parallax.min' ), array( 'jquery' ), $this->version, true );
		// parallax js
		wp_register_script( 'isotope',     Helper::get_nomin_js( 'isotope.pkgd.min' ), array( 'jquery' ), $this->version, true );
		// asPieProgress js
		wp_register_script( 'jquery-asPieProgress', Helper::get_nomin_js( 'jquery-asPieProgress' ), array( 'jquery' ), $this->version, true );
		// headding-title
		wp_register_script( 'headding-js', 	 Helper::get_js( 'headding-title' ), array( 'jquery' ), $this->version, true );
		wp_register_script( 'splitting',     Helper::get_js( 'splitting' ), array( 'jquery' ), $this->version, true );
		wp_register_script( 'splitting-out', Helper::get_js( 'splitting-out' ), array( 'jquery' ), $this->version, true );
		// sticky-sidebar
		wp_register_script( 'sticky-sidebar', Helper::get_js( 'sticky-sidebar' ), array( 'jquery' ), $this->version, true );
		// imagesloaded
		wp_register_script( 'imagesloaded', Helper::get_js( 'imagesloaded.min' ), array( 'jquery' ), $this->version, true );
		// popper
		wp_register_script( 'popper', Helper::get_js( 'popper.min' ), array( 'jquery' ), $this->version, true );
		// modernizr
		wp_register_script( 'modernizr', Helper::get_js( 'modernizr' ), array( 'jquery' ), $this->version, true );
		// Main js
		wp_register_script( 'staco-main', Helper::get_js( 'main' ), array( 'jquery' ), $this->version, true );
	}  

	public function enqueue_scripts() {
		/* - CSS - */
		wp_enqueue_style( 'staco-gfonts', $this->fonts_url(), array(), $this->version );
		wp_enqueue_style( 'bootstrap' );
		wp_enqueue_style( 'asPieProgress' );
		wp_enqueue_style( 'headding-css' );
		wp_enqueue_style( 'venobox' );
		wp_enqueue_style( 'lightbox' );
		wp_enqueue_style( 'carousel-default' );
		wp_enqueue_style( 'carousel-min' );
		wp_enqueue_style( 'swiper' );
		wp_enqueue_style( 'slick-css' );
		wp_enqueue_style( 'slick-theme' );
		wp_enqueue_style( 'animate' );
		$this->conditional_scripts();
		wp_enqueue_style( 'staco-style' );
		$this->dynamic_style();
		
		wp_enqueue_style( 'custom' );
		wp_enqueue_style( 'responsive' );

		/*JS*/
		wp_enqueue_script( 'modernizr' );
		//Slick
		wp_enqueue_script( 'slick-js' );
		wp_enqueue_script( 'slider-init' );
		wp_enqueue_script( 'swiper-min' );
		wp_enqueue_script( 'countdown' );
		wp_enqueue_script( 'isotope' );
		wp_enqueue_script( 'bootstrap' );
		wp_enqueue_script( 'lightbox-js' );
		wp_enqueue_script( 'venobox-js' );
		wp_enqueue_script( 'parallax-js' );
		wp_enqueue_script( 'iconify' );
		wp_enqueue_script( 'headding-js' );
		wp_enqueue_script( 'splitting' );
		wp_enqueue_script( 'splitting-out' );
		wp_enqueue_script( 'sticky-sidebar' );
		wp_enqueue_script( 'imagesloaded' );
		wp_enqueue_script( 'jquery-asPieProgress' );
		wp_enqueue_script( 'carousel' );
		wp_enqueue_script( 'popper' );
		$this->localized_scripts();
		wp_enqueue_script( 'staco-main' );
		$this->elementor_scripts();
	}

	public function elementor_scripts() {
		if ( !did_action( 'elementor/loaded' ) ) {
			return;
		}
		if ( Plugin::$instance->preview->is_preview_mode() ) {
			//Slick
			wp_enqueue_script( 'slick-js' );
			wp_enqueue_script( 'slider-init' );
			// Swiper
			wp_enqueue_style( 'iconify' );
			wp_enqueue_script( 'jquery-asPieProgress' );
			wp_enqueue_script( 'carousel' );	
			// CountDown
			wp_enqueue_script( 'popper' );
		}
	}


	private function conditional_scripts(){
		if ( is_singular() && comments_open() && get_option( 'thread_comments' ) ) {
			wp_enqueue_script( 'comment-reply' );
		}
		if (is_single() || is_home()) {
			wp_enqueue_script( 'theia-sticky-sidebar' );
		}
	}
	
	public function admin_conditional_scripts(){		
		wp_enqueue_style( 'staco-gfonts', $this->fonts_url(), array(), $this->version );
		wp_enqueue_script( 'jquery-ui-tabs' );		
		wp_enqueue_style( 'wp-color-picker' );	
	}

	private function localized_scripts(){
		// Localization
		$adminajax 	   = esc_url( admin_url('admin-ajax.php') );
		$localize_data = array(
			'ajaxurl'	  => $adminajax,
			'hasAdminBar' => is_admin_bar_showing() ? 1 : 0,
			'headerStyle' => staco::$header_style,
			// CounDown
			'day'	         => esc_html__('Day' , 'staco'),
			'hour'	         => esc_html__('Hour' , 'staco'),
			'minute'         => esc_html__('Minute' , 'staco'),
			'second'         => esc_html__('Second' , 'staco'),
			'close_text'     => esc_html__('close' , 'staco'),
			// Ajax
			'ajaxURL' => admin_url('admin-ajax.php'),
			'nonce' => wp_create_nonce( 'staco-nonce' ),
			'cart_update_pbm' => esc_html__('Cart Update Problem.', 'staco'),
			
		);
		wp_localize_script( $this->staco . '-main', 'stacoObj', $localize_data );
	}

	private function dynamic_style(){
		$dynamic_css  = $this->template_style();
		ob_start();
		Helper::requires( 'dynamic-style.php' );
		$dynamic_css .= ob_get_clean();
		$dynamic_css  = $this->minified_css( $dynamic_css );
		wp_register_style( $this->staco . '-dynamic', false );
		wp_enqueue_style( $this->staco . '-dynamic' );
		wp_add_inline_style( $this->staco . '-dynamic', $dynamic_css );
	}

	private function minified_css( $css ) {
		/* remove comments */
		$css = preg_replace( '!/\*[^*]*\*+([^/][^*]*\*+)*/!', '', $css );
		/* remove tabs, spaces, newlines, etc. */
		$css = str_replace( array( "\r\n", "\r", "\n", "\t", '  ', '    ', '    ' ), ' ', $css );
		return $css;
	}

	private function template_style(){
		$style = '';
		if ( is_single() ) {
			if ( !empty(staco::$bgimg ) ) {
				$opacity = staco::$opacity/100;
				$style .= '.single .breadcrumbs-banner { background-image: url(' . staco::$bgimg . ')}';
				$style .= '.single .breadcrumbs-banner:before { background-color: ' . staco::$bgcolor . '}';
				$style .= '.single .breadcrumbs-banner:before { opacity: ' . $opacity . '}';
			}
			else {
				$opacity = staco::$opacity/100;
				$style .= '.single .breadcrumbs-banner:before { background-color: ' . staco::$bgcolor . '}';
				$style .= '.breadcrumbs-banner:before { opacity: ' . $opacity . '}';
			}
		} else {
			if ( !empty( staco::$bgimg ) ) {
				$opacity = staco::$opacity/100;
				$style .= '.breadcrumbs-banner { background-image: url(' . staco::$bgimg . ')}';
				$style .= '.breadcrumbs-banner:before { background-color: ' . staco::$bgcolor . '}';
				$style .= '.breadcrumbs-banner:before { opacity: ' . $opacity . '}';
			}
			else {
				$opacity = staco::$opacity/100;
				$style .= '.breadcrumbs-banner:before { background-color: ' . staco::$bgcolor . '}';
				$style .= '.breadcrumbs-banner:before { opacity: ' . $opacity . '}';
			}
		}

		if ( staco::$padding_top) {
			$style .= '.breadcrumbs-banner { padding-top:'. staco::$padding_top . 'px;}';
		}
		if ( staco::$padding_bottom) {
			$style .= '.breadcrumbs-banner { padding-bottom:'. staco::$padding_bottom . 'px;}';
		}

		/* = Footer 1
        =======================================================*/
		if ( staco::$options['footer1_bg_img']) {
			$f1_bg = wp_get_attachment_image_src( staco::$options['footer1_bg_img'], 'full', true );
			$style .= '.footer1.footer-top { background-image: url(' . $f1_bg[0] . ')}';
		}		
		return $style;
	}	
}
new Scripts;