<?php
/**
 * @author  UiGigs
 * @since   1.0
 * @version 1.0
 */

namespace UiGigs\staco;

class TGM_Config {
	
	public $staco = staco_THEME_PREFIX;
	public $path   = staco_THEME_PLUGINS_DIR;
	public function __construct() {
		add_action( 'tgmpa_register', array( $this, 'register_required_plugins' ) );
	}
	public function register_required_plugins(){
		$plugins = array(
			// Bundled
			array(
				'name'         => esc_html__('Staco Core','staco'),
				'slug'         => 'staco-core',
				'source'       => 'staco-core-v1.0.0.zip',
				'required'     =>  true,
				'version'      => '1.0.0'
			),
			array(
				'name'         => esc_html__('Staco Framework','staco'),
				'slug'         => 'staco-framework',
				'source'       => 'staco-framework-v1.0.0.zip',
				'required'     =>  true,
				'version'      => '1.0.0'
			),
			array(
				'name'         => esc_html__('UIGIGs Elementor Header & Footer Builder','staco'),
				'slug'         => 'uigigs-header-footer-elementor',
				'source'       => 'uigigs-header-footer-elementor.zip',
				'required'     =>  true,
				'version'      => '1.0.0'
			),			
			array(
				'name'         => esc_html__('Staco Demo Importer','staco'),
				'slug'         => 'staco-demo-importer',
				'source'       => 'staco-demo-importer.zip',
				'required'     =>  true,
				'version'      => '1.0.0'
			),			
			// Repository
			array(
				'name'     => esc_html__('Elementor Page Builder','staco'),
				'slug'     => 'elementor',
				'required' => true,
			),
			array(
				'name'     => esc_html__('Breadcrumb NavXT','staco'),
				'slug'     => 'breadcrumb-navxt',
				'required' => true,
			),
			array(
				'name'     => esc_html__('Contact Form 7','staco'),
				'slug'     => 'contact-form-7',
				'required' => true,
			),
			array(
				'name'     => esc_html__('MC4WP: Mailchimp for WordPress','staco'),
				'slug'     => 'mailchimp-for-wp',
				'required' => true,
			),
		);

		$config = array(
			'id'           => $this->staco,            // Unique ID for hashing notices for multiple instances of TGMPA.
			'default_path' => $this->path,              // Default absolute path to bundled plugins.
			'menu'         => $this->staco . '-install-plugins', // Menu slug.
			'has_notices'  => true,                    // Show admin notices or not.
			'dismissable'  => true,                    // If false, a user cannot dismiss the nag message.
			'dismiss_msg'  => '',                      // If 'dismissable' is false, this message will be output at top of nag.
			'is_automatic' => false,                    // Automatically activate plugins after installation or not.
			'message'      => '',                      // Message to output right before the plugins table.
		);

		tgmpa( $plugins, $config );
	}
}
new TGM_Config;