<?php
/**
 * @author  UiGigs
 * @since   1.0
 * @version 1.0
 */

use UiGigs\staco\staco;

/*-------------------------------------
#. staco Others Color Settings
---------------------------------------*/
// Toggle Color
$toggle_bg_color = staco::$options['toggle_bg_color'];
$toggle_text_color = staco::$options['toggle_text_color'];
// Preloader
$preloader_bg_color = staco::$options['preloader_bg_color'];
$triangle_color1 = staco::$options['preloader_triangle_color1'];
$triangle_color2 = staco::$options['preloader_triangle_color2'];
// Scrollup
$scroll_bg_color = staco::$options['scroll_bg_color'];
$scroll_color = staco::$options['scroll_color'];

?>

<?php
	if ( !empty( $toggle_bg_color )) {
	// Toggle Color
	?>
	.offcanvas-menu-wrap {
		background-color: <?php echo esc_html( $toggle_bg_color ); ?>;
	}
<?php } if ( !empty( $toggle_bg_color )) { ?>
	.offcanvas-content .top-content .toggle-desc, 
	.offcanvas-content .top-content p,
	.offcanvas-header .header-text,
	.offcanvas-content .sub-title,
	.offcanvas-content .info li,
	.offcanvas-footer ul li a,
	.offcanvas-content h2 {
		color: <?php echo esc_html( $toggle_text_color ); ?>;
	}
	button.offcanvas-menu-btn.menu-status-close .menu-btn-icon span {
		background-color: <?php echo esc_html( $toggle_text_color ); ?>;
	}
<?php } ?>

<?php
	// Preloader
	if ( !empty( $preloader_bg_color )) {
	?>
	.preloader .preloader-inner-wrap .preloader-inner {
		background-color: <?php echo esc_html( $preloader_bg_color ); ?>;
	}
	<?php } if ( !empty( $triangle_color1 )) { ?>
		.main-loader span:nth-child(1),
		.main-loader span:nth-child(4) {
			background-color: <?php echo esc_html( $triangle_color1 ); ?>;
			border-color: <?php echo esc_html( $triangle_color1 ); ?>;
		}
	<?php } if ( !empty( $triangle_color2 )) { ?>
		.main-loader span:nth-child(2),
		.main-loader span:nth-child(3) {
			background-color: <?php echo esc_html( $triangle_color2 ); ?>;
			border-color: <?php echo esc_html( $triangle_color2 ); ?>;
		}
	<?php }
?>

<?php
	if ( !empty( $scroll_bg_color || $scroll_color )) {
	// Scrollup
	?>
	.scrollup {
		background-color: <?php echo esc_html( $scroll_color ); ?>;
		background-color: <?php echo esc_html( $scroll_bg_color ); ?>;
	}
<?php } ?>