<?php
/**
 * @author  UiGigs
 * @since   1.0
 * @version 1.0
 */
namespace UiGigs\staco;
use UiGigs\staco\staco;
use UiGigs\staco\Helper;
?>
<?php get_header(); ?>
<?php 
$prefix = staco_THEME_CPT_PREFIX;
$post_types = ['portfolio', 'service'];

foreach ($post_types as $post_type) {
	if ( is_post_type_archive( "{$prefix}_{$post_type}" ) || is_tax( "{$prefix}_{$post_type}_category" ) || is_tax( "{$prefix}_{$post_type}_tag" ) ) {
		get_template_part( "template-parts/archive-{$post_type}/archive", $post_type );
		return;
	}
}

$blog_layout = staco::$options['blog_layout'];
$blog_style = 1;
$blog_grid = staco::$options['blog_grid'];

?>

<!--=====================================-->
<section class="latest-blog-section">
  <div class="container">
  	<div class="row">
    	<div id="primary" class="<?php Helper::the_layout_class(); ?>">
    		<?php if ( have_posts() ) : ?>
			<?php
				if ( ( is_home() || is_archive() ) ) {
					if ( $blog_layout != 1 ) {
						echo '<div class="row staco-masonry-grid">';
						while ( have_posts() ) : the_post();
							echo '<div class="col-lg-'. esc_attr( $blog_grid ) .' col-sm-6 staco-grid-item">';
							get_template_part( 'template-parts/archive-blog/content',  $blog_style ); 
							echo '</div>';
						endwhile;
						echo '</div>';
					} else {
						echo '<div class="post-list-items">';
						while ( have_posts() ) : the_post();
							echo '<div class="post-list-item">';
							get_template_part( 'template-parts/archive-blog/content',  $blog_style ); 
							echo '</div>';
						endwhile;
						echo '</div>';
					}
					Helper::pagination();
				}
				else {
					while ( have_posts() ) : the_post();
						get_template_part( 'template-parts/content' );
					endwhile;
				}
			?>
			<?php else: ?>
				<?php get_template_part( 'template-parts/content', 'none' ); ?>
			<?php endif; ?>
			<?php wp_reset_postdata(); ?>
        </div>
        <?php Helper::staco_sidebar(); ?>
  	</div>
  </div>
</section>

<?php get_footer(); ?>
