<?php
/**
 * @author  UiGigs
 * @since   1.0
 * @version 1.0
 */

namespace UiGigs\staco;
use UiGigs\staco\staco;
$prefix = staco_THEME_PREFIX_VAR;
if ( is_404() ) {
	$stacotheme_title = staco::$options['error_page_title'];
	$stacotheme_title = $stacotheme_title . get_search_query();
}
elseif ( is_search() ) {
	$stacotheme_title = esc_html__( 'Search Results for : ', 'staco' ) . get_search_query();
}
elseif ( is_home() ) {
	if (!empty(staco::$options['blog_breadcrumb_title'])) {
		$stacotheme_title = staco::$options['blog_breadcrumb_title'];
	} elseif ( get_option( 'page_for_posts' ) ) {
		$stacotheme_title = get_the_title( get_option( 'page_for_posts' ) );
	}
	else {
		$stacotheme_title = apply_filters( "{$prefix}_blog_title", esc_html__( 'All Posts', 'staco' ) );
	}
}
elseif ( is_archive() ) {
	$cpt = staco_THEME_CPT_PREFIX;
	if ( is_post_type_archive( "{$cpt}_event" ) ) {
		$stacotheme_title = esc_html__( 'All Events', 'staco' );
	}
	elseif ( is_post_type_archive( "{$cpt}_speaker" ) ) {
		$stacotheme_title = esc_html__( 'All Speaker Member', 'staco' );
	}
	else {
		$stacotheme_title = get_the_archive_title();
	}
} elseif (is_single()) {
	$stacotheme_title  = get_the_title();
} else {
	$id                        = $post->ID;
	$fitness_custom_page_title = get_post_meta( $id, 'staco_custom_page_title', true );
	if (!empty($fitness_custom_page_title)) {
		$stacotheme_title = get_post_meta( $id, 'staco_custom_page_title', true );
	} else {
		$stacotheme_title = get_the_title();                   
	}
}

if (is_singular('post')) {
	$cols = '12';
} else {
	$cols = '6';
}

?>

 <!-- Breadcrumb section start -->
<section class="breadcrumb-section">
	<div class="bg-shape">
		<div class="shape-img img-1"><img src="<?php echo esc_url( Helper::get_img( '1.svg' ) ); ?>" alt="<?php esc_attr_e('Icon', 'staco'); ?>"></div>
		<div class="shape-img img-2"><img src="<?php echo esc_url( Helper::get_img( '1.svg' ) ); ?>"></div>
	</div>
	<div class="container">
		<div class="row align-items-center">
			<div class="col-md-<?php echo esc_attr( $cols ); ?>">
				<div class="breadcrumb-content">
					<nav aria-label="breadcrumb">
						<?php if ( staco::$has_breadcrumb == '1' || staco::$has_breadcrumb  != "off" ): ?>
							<?php get_template_part( 'template-parts/content', 'breadcrumb' );?>
						<?php endif; ?>
					</nav>
					<div class="breadcrumb-title">
						<h2><?php echo wp_kses( $stacotheme_title, 'alltext_allow' ); ?></h2>
					</div>                      
				</div>
			</div>
			<?php if (!is_single()) { ?>
			<div class="col-md-6">
				<div class="breadcrumb-img">
					<img src="<?php echo esc_url( Helper::get_img( 'breadcrumb-img.svg' ) ); ?>" alt="<?php esc_attr_e('Breadcrumb', 'staco'); ?>">
				</div>
			</div>
			<?php } ?>
		</div>
	</div>
</section>
<!-- Breadcrumb section end -->

<!--=====================================-->
<!--=         Inner Banner Start    	=-->
<!--=====================================-->