<?php
/**
 * @author  UiGigs
 * @since   1.0
 * @version 1.0
 */

namespace UiGigs\staco;
use UiGigs\staco\staco;
use UiGigs\staco\Helper;

$excerpt_length = staco::$options['excerpt_length'];
$post_id = get_the_ID();
$padmin = staco::$options['post_meta_admin'];
$pdate = staco::$options['post_meta_date'];
$pcom = staco::$options['post_meta_comnt'];
$pcats = staco::$options['post_meta_cats'];

if ( has_post_thumbnail() ){
    $thumb_img = '';
} else {
    $thumb_img = 'no-image';
}

?>

<article id="post-<?php the_ID(); ?>" <?php post_class( 'blog-layout-1 '.$thumb_img ); ?>>
    <div class="letest-blog-card">
        <?php if ( has_post_thumbnail() ){ ?>
        <div class="letest-blog-img">
            <a href="<?php the_permalink(); ?>"><?php the_post_thumbnail(); ?></a>
        </div>
        <?php } ?>
        <dvi class="letest-blog-info">
            <div class="letest-blog-info-inner">
                <?php 
                    if (!empty( $padmin || $pdate || $pcats )) {
                        echo Helper::staco_get_post_meta( $post_id, $padmin, $pdate, $pcats ); 
                    }
                ?>
                <h4 class="content-box_header__title"><a href="<?php the_permalink(); ?>"><?php the_title(); ?></a></h4>
                <p><?php echo helper::staco_excerpt( $excerpt_length ); ?></p>
                <a href="<?php the_permalink(); ?>"><?php esc_html_e( 'Read More', 'staco' ) ?><img src="<?php echo esc_url( Helper::get_img( 'arrow-right-blue.svg' ) ); ?>" alt="<?php esc_attr_e('icon', 'staco'); ?>" /></a>
            </div>
        </dvi>
    </div>
</article>

    
    
