<?php
/**
 * @author  UiGigs
 * @since   1.0
 * @version 1.0
 */

namespace UiGigs\staco;
use UiGigs\staco\staco;
use UiGigs\staco\Helper;

$post_id = get_the_ID();
$pfimg = staco::$options['post_feature_img'];
$padmin = staco::$options['post_admin'];
$pdate = staco::$options['post_date'];
$pcom = staco::$options['post_comnt'];
$pcats = staco::$options['post_cats'];


if ( staco::$options['post_tags'] && has_tag() || staco::$options['post_share'] == "1" ){
    $tags_shares = '';
} else {
    $tags_shares = 'tags-shares-none';
}

if ( staco::$options['post_tags'] && has_tag() ) {
    $scols = '6';
} else {
    $scols = '12';
}

if ( $share = staco::$options['post_share'] == 1 ) {
    $tcols = '6';
} else {
    $tcols = '12';
}

$author_id       = get_the_author_meta( 'ID' );
$author_name     = get_the_author_meta( 'display_name' );
$author_bio      = get_the_author_meta( 'description' );

?>

<article id="post-<?php the_ID(); ?>" <?php post_class( 'single-blog-wrap' ); ?>>

    <div class="blog-details-content">
        <?php if ( has_post_thumbnail() && !empty($pfimg) ){ ?> 
            <div class="blog-details-img"><?php the_post_thumbnail(); ?></div>
        <?php } ?>
        <div class="blog-details-inner">
            <div class="blog-details-info-list">
                <ul>
                    <li><span><img src="<?php echo esc_url( Helper::get_img( 'icon_profile.svg' ) ); ?>" alt="<?php esc_attr_e('icon', 'staco'); ?>"></span>By - <a href="<?php echo get_author_posts_url( get_the_author_meta( 'ID' ) ); ?>">
                    <?php the_author(); ?></a></li>
                    <li><span><img src="<?php echo esc_url( Helper::get_img( 'icon_category.svg' ) ); ?>" alt="<?php esc_attr_e('icon', 'staco'); ?>"></span><a href="#"><?php the_category( ', ' ); ?></a></li>
                    <li><span><img src="<?php echo esc_url( Helper::get_img( 'icon_calendar.svg' ) ); ?>" alt="<?php esc_attr_e('icon', 'staco'); ?>"></span><?php echo get_the_date(); ?></li>
                </ul>
            </div>
            <div class="single-blog-details">
                <?php the_content(); ?>
                <?php wp_link_pages( array(
                    'before'      => '<div class="staco-page-links"><span class="page-links-title">' . esc_html__( 'Pages:', 'staco' ) . '</span>',
                    'after'       => '</div>',
                    'link_before' => '<span>',
                    'link_after'  => '</span>',
                    ) );
                ?>
            </div>
            <div class="blog-tag-section">
                <?php if ( staco::$options['post_tags'] && has_tag() ): ?>
                    <div class="tag-list">
                        <?php echo get_the_term_list( $post->ID, 'post_tag','',' ' ); ?>
                    </div>
                <?php endif; if ( staco::$options['post_share'] == "1"  ): ?>
                <div class="tag-list">   
                    <div class="blog-share-wrap">
                        <a href="#" data-bs-toggle="modal" data-bs-target="#share_modal"><i class="icon-share"></i><?php esc_html_e( 'Share', 'staco' ); ?></a>
                    </div>
                </div>
                <?php endif; ?>
            </div>
        </div>  
    </div>

    <?php get_template_part( 'template-parts/content-single-pagination' ); ?>
        
    <?php if ( comments_open() || get_comments_number() ){ ?>
    <div class="blog-comment-form">
        <?php comments_template(); ?>  
    </div>
    <?php } ?>
</article>
