<?php
/**
 * @author  UiGigs
 * @since   1.0
 * @version 1.0
 */

  use UiGigs\staco\staco;
  use UiGigs\staco\Helper; 

  if (staco::$options['scrollup'] || staco::$options['footer_social']) {
    $copyright = 'copyright-left';
  } else {
    $copyright = 'copyright-center';
  }

?>

<?php 
  if (staco::$options['cta_switch']) {
    get_template_part( 'template-parts/footer/footer', 'cta' );
  }
 ?>

<!--=====================================-->
<!--=     Footer Section Area Start     =-->
<!--=====================================-->

<footer class="footer-section">
    <?php if ( is_active_sidebar( 'footer-widget-1-1' ) || is_active_sidebar( 'footer-widget-1-2' ) || is_active_sidebar( 'footer-widget-1-3' ) || is_active_sidebar( 'footer-widget-1-4' ) ) { ?>
    <div class="footer-top">
      <div class="container">
        <div class="row">
          <?php if ( is_active_sidebar( 'footer-widget-1-1' ) ) { ?>
            <div class="col-lg-<?php echo esc_attr(staco::$options['f1_area1_column']); ?> col-md-6">
              <?php dynamic_sidebar( 'footer-widget-1-1' ); ?>
            </div>
          <?php } if ( is_active_sidebar( 'footer-widget-1-2' ) ) { ?>
            <div class="col-lg-<?php echo esc_attr(staco::$options['f1_area2_column']); ?> col-md-6">
              <?php dynamic_sidebar( 'footer-widget-1-2' ); ?>
            </div>
          <?php } if ( is_active_sidebar( 'footer-widget-1-3' ) ) { ?>
            <div class="col-lg-<?php echo esc_attr(staco::$options['f1_area3_column']); ?> col-md-6">
              <?php dynamic_sidebar( 'footer-widget-1-3' ); ?>
            </div>
          <?php } if ( is_active_sidebar( 'footer-widget-1-4' ) ) { ?>
            <div class="col-lg-<?php echo esc_attr(staco::$options['f1_area4_column']); ?> col-md-6">
              <?php dynamic_sidebar( 'footer-widget-1-4' ); ?>
            </div>
          <?php } ?>
        </div>
      </div>
    </div>
    <?php } ?>
<?php
  if ( has_nav_menu( 'menu-3' ) ) {
      // User has assigned menu to this location;
      // output it
      ?>
      <div class="col-mds">
          <nav class="nav navbar copyright-menu-sec">                            
              <?php
                  wp_nav_menu( array(
                      'theme_location' => 'menu-3',
                      'menu_id'        => 'footer-menu',
                  ) );
              ?>                            
          </nav>
      </div>
      <?php
  }
  ?> 

   <div class="footer-bottom <?php echo esc_attr( $copyright ); ?>">
      <div class="container">
        <div class="row">

            <?php if ( has_nav_menu( 'copyright_menu' ) ) {  ?>  
            <div class="col-md-5 order-md-1 order-2">
                <div class="footer-copyright"><p><?php echo wp_kses_stripslashes( staco::$options['copyright_text'] ); ?></p></div>
            </div>
            <div class="col-md-7 order-md-2 order-1">
                <?php
                    wp_nav_menu( array(
                        'theme_location' => 'copyright_menu',
                        'menu_id'        => 'copyright_menu',
                        'menu_class'        => 'privacy-menu',
                    ) );
                ?>
            </div>
            <?php } else { ?>
                <div class="col-md-12">
                    <div class="footer-copyright text-center"><p><?php echo wp_kses_stripslashes( staco::$options['copyright_text'] ); ?></p></div>
                </div>
            <?php } ?>
        </div>
      </div>
   </div>
</footer>
