<?php
/**
 * @author  UiGigs
 * @since   1.0
 * @version 1.0
 */

namespace UiGigs\staco;
use UiGigs\staco\staco;

$header_sticky = staco::$options['header_sticky'];
if ($header_sticky) {
  $sticky = 'sticky-on';
} else {
  $sticky = 'sticky-off';
}

$hsocial = staco::$options['mobile_social'] ? '' : 'mobi-social-disable';
$hlink = staco::$options['mobile_link'] ? '' : 'mobi-link-disable';
$hconnect = staco::$options['mobile_connect'] ? '' : 'mobi-connect-disable';

$responsive = $hsocial.' '.$hlink.' '.$hconnect;
$sticky = $sticky.' '.$responsive;

$social = staco::$options['header_social'];
$link   = !empty( staco::$options['hbtn_link'] ) ? 1 : '';
$connect = staco::$options['header_connect'];
$header_right = $social || $link || $connect ? true : false;

?>

<!-- Header section start -->
<header class="header-section">
    <div class="container">
        <div class="row">
            <div class="col-md-12">
                <nav class="navbar navbar-expand-lg">
                    <div class="container header-navbar-container">
                        <?php get_template_part( 'template-parts/header/logo', 1 ); ?>   
                        <div class="mean-bar">
                            <span class="sidebarBtn">
                                <span class="bar"></span>
                                <span class="bar"></span>
                                <span class="bar"></span>
                            </span>
                        </div>
                        
                        <div class="collapse navbar-collapse header-navbar-content" id="navbarSupportedContent">
                            <?php get_template_part( 'template-parts/header/menu', 1 ); ?>
                            <?php if ( staco::$options['connect_btn_link'] || staco::$options['hbtn_link'] ) { ?>
                                <ul class="header-extra">
                                    <li><a href="<?php echo esc_html( staco::$options['connect_btn_link'] ); ?>"><?php echo esc_html( staco::$options['connect_btn_txt'] ); ?></a></li>
                                    <?php if (staco::$options['hbtn_link']) { ?>
                                    <a href="<?php echo esc_url( staco::$options['hbtn_link'] ); ?>" class="bg-white-btn">
                                        <?php echo esc_html( staco::$options['hbtn_txt'] ); ?>
                                    </a>
                                    <?php } ?>
                                </ul>
                            <?php } ?>
                        </div>

                    </div>
                </nav>
            </div>
        </div>
    </div>
</header>
<!-- Header section end -->















