<?php
/**
 * @author  UiGigs
 * @since   1.0
 * @version 1.0
 */

namespace UiGigs\Staco_Core;
use Elementor\Repeater;
use Elementor\Controls_Manager;

if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

class BusinessTools extends Custom_Widget_Base {

	public function __construct( $data = [], $args = null ) {
		$this->rt_name = esc_html__( 'Business Tools', 'staco-core' );
		$this->rt_base = 'business-tools';
		parent::__construct( $data, $args );
	}

	protected function register_controls() {

		$this->start_controls_section(
            'step_section',
            [
                'label' => esc_html__( 'Business Tools', 'rsaddon' ),
                'tab' => Controls_Manager::TAB_CONTENT,
            ]
        );

		$this->add_control(
			'big_image',
			[
				'label'   => __( 'Big Image', 'staco-core' ),
				'type'    => \Elementor\Controls_Manager::MEDIA,
				'default' => [
					'url' => \Elementor\Utils::get_placeholder_image_src(),
				],
			]
		);

        $repeater = new Repeater();
        $repeater->add_control(
			'small_image',
			[
				'label'   => __( 'Image', 'staco-core' ),
				'type'    => \Elementor\Controls_Manager::MEDIA,
				'default' => [
					'url' => \Elementor\Utils::get_placeholder_image_src(),
				],
			]
		);

        $repeater->add_control(
            'subtitle',
            [
                'label' => esc_html__( 'Sub title', 'rsaddon' ),
                'type' => Controls_Manager::TEXT,
            ]
        );

        $repeater->add_control(
            'title',
            [
                'label' => esc_html__( 'Title', 'rsaddon' ),
                'type' => Controls_Manager::TEXT,
            ]
        );
        
        $repeater->add_control(
			'desc',
			[
				'label'   => esc_html__( 'Description', 'staco-core' ),
				'type'    => Controls_Manager::WYSIWYG,
			]
		);

		$repeater->add_control(
			'ntn1',
			[
				'label'   => esc_html__( 'Button Text 1', 'staco-core' ),
				'type'    => Controls_Manager::TEXT,
			]
		);
		$repeater->add_control(
			'ntn2',
			[
				'label'   => esc_html__( 'Button Text 2', 'staco-core' ),
				'type'    => Controls_Manager::TEXT,
			]
		);

		$repeater->add_control(
			'ntn3',
			[
				'label'   => esc_html__( 'Button Text 3', 'staco-core' ),
				'type'    => Controls_Manager::TEXT,
			]
		);
        
        $this->add_control(
            'step_list',
            [
                'show_label' => false,
                'type' => Controls_Manager::REPEATER,
                'fields' => $repeater->get_controls(),
                'title_field' => '{{{ title }}}',
            ]
        ); 
        $this->end_controls_section();

    }

	protected function render() {
		$data     = $this->get_settings();
		$template = 'view';
		$this->rt_template( $template, $data );
	}

}