<?php
/**
 * @author  UiGigs
 * @since   1.0
 * @version 1.0
 */

use Elementor\Icons_Manager; ?>
<div class="hot-collections-section">
    <div class="hot-collections-content">
        <div class="row hot-collections-slider">
            <?php 
                foreach ( $data['step_list'] as $item ){  
            ?>
            <div class="col-md-12">
                <div class="hot-collections-card">
                    <div class="hot-collections-img">
                        <?php echo wp_get_attachment_image( $item['big_image']['id'], 'full' ); ?>
                    </div>
                    <div class="hot-collections-text">
                        <div class="hot-collections-profile-img">
                            <?php echo wp_get_attachment_image( $item['image_icon']['id'], 'full' ); ?>
                        </div>
                        <h6 class="name dm-sans wt-600">
                            <?php echo wp_kses_post( $item['title'] ) ?> <?php echo wp_get_attachment_image( $item['check_img']['id'], 'full' ); ?>
                        </h6>
                        <p class="price"><?php echo wp_kses_post( $item['price'] ) ?></p>
                        <p><?php echo wp_kses_post( $item['collections'] ) ?></p>
                    </div>
                </div>
            </div>
            <?php } ?>
        </div>
    </div>
</div>



<script>
    (function ($) {
    ("use strict");
        $(document).ready(function () {
            
        var hotCollectionsSlider = $(".hot-collections-slider");
            if (hotCollectionsSlider.length) {
                $('.hot-collections-slider').slick({
                    dots: false,
                    infinite: true,
                    speed: 300,
                    slidesToShow: 6,
                    slidesToScroll: 1,
                    responsive: [
                        {
                            breakpoint: 1199,
                            settings: {
                                slidesToShow: 5,
                                slidesToScroll: 1,
                            }
                            },
                        {
                            breakpoint: 992,
                            settings: {
                                slidesToShow: 4,
                                slidesToScroll: 1,
                            }
                            },
                        {
                            breakpoint: 768,
                            settings: {
                                slidesToShow: 3,
                                slidesToScroll: 2
                            }
                            },
                        {
                            breakpoint: 575,
                            settings: {
                                slidesToShow: 2,
                                slidesToScroll: 1
                            }
                            },
                        {
                            breakpoint: 400,
                            settings: {
                                slidesToShow: 1,
                                slidesToScroll: 1
                            }
                            }
                        ]
                });
            }
        });
    })(jQuery);
</script>


