<?php
/**
 * @author  UiGigs
 * @since   1.0
 * @version 1.0
 */

use Elementor\Icons_Manager; ?>

<div class="nft-categories-content">
    <div class="row nft-categorie-slider">
        <?php 
            foreach ( $data['step_list'] as $item ){  
        ?>
        <div class="col-lg-2">
            <div class="categories-card">
                <?php echo wp_get_attachment_image( $item['big_image']['id'], 'full' ); ?>
                <h5 class="wt-600"><?php echo wp_kses_post( $item['title'] ) ?></h5>
            </div>
        </div>
        <?php } ?>
    </div>
</div>

<script>
    (function ($) {
    ("use strict");
        $(document).ready(function () {
            var nftCategorieSlider = $(".nft-categorie-slider");
            if (nftCategorieSlider.length) {
                $('.nft-categorie-slider').slick({
                    dots: false,
                    infinite: true,
                    slidesToShow: 6,
                    slidesToScroll: 1,
                    arrows: false,
                    touchMove: true,
                    pauseOnHover: false,
                    pauseOnFocus: false,
                    autoplay: true, 
                    speed: 300,
                    responsive: [
                        {
                            breakpoint: 1199,
                            settings: {
                                slidesToShow: 5,
                                slidesToScroll: 1,
                            }
                            },
                        {
                            breakpoint: 992,
                            settings: {
                                slidesToShow: 4,
                                slidesToScroll: 1
                            }
                            },
                        {
                            breakpoint: 768,
                            settings: {
                                slidesToShow: 3,
                                slidesToScroll: 1
                            }
                            },
                        {
                            breakpoint: 540,
                            settings: {
                                slidesToShow: 2,
                                slidesToScroll: 1
                            }
                            },
                        ]
                });
            }
        });
    })(jQuery);
</script>


