<?php
/**
 * @author  UiGigs
 * @since   1.0
 * @version 1.0
 */

namespace UiGigs\Staco_Core;
use Elementor\Controls_Manager;
use Elementor\Group_Control_Typography;
use Elementor\Group_Control_Background;
use Elementor\Group_Control_Border;

if ( ! defined( 'ABSPATH' ) ) {
	exit;
}
class StacoMenu extends Custom_Widget_Base {
	public function __construct( $data = [], $args = null ) {
		$this->rt_name = esc_html__( 'Staco Menu', 'staco-core' );
		$this->rt_base = 'staco-menu';
		parent::__construct( $data, $args );
	}

	private function staco_get_menu()
    {
        $options = array();
        $menus = wp_get_nav_menus();
        if (!empty($menus)) {
            foreach ($menus as $menu) {
                if (isset($menu)) {
                    $options[''] = 'Select';
                    if (isset($menu->term_id) && isset($menu->name)) {
                        $options[$menu->term_id] = $menu->name;
                    }
                }
            }
        }
        return $options;
    }

	protected function register_controls() {

		$this->start_controls_section(
            'content',
            [
                'label' => __('Content', 'staco-core'),
            ]
        );

        $this->add_control(
            'menu_select',
            [
                'label' => __('Select Menu', 'staco-core'),
                'type' => Controls_Manager::SELECT,
                'options' =>  $this->staco_get_menu(),
            ]
        );
        $this->add_control(
			'menu_style',
			[
				'label' => __('Menu Style', 'staco-core'),
				'type' => Controls_Manager::SELECT,
				'default' => 'vertical_style',
				'options' => [
					'horizontal_style' => __( 'Horizontal', 'staco-core' ),
					'vertical_style' => __( 'Vertical', 'staco-core' ),
				],
				'label_block' => true,
			]
		);
        $this->add_responsive_control(
            'align',
            [
                'label' => esc_html__('Alignment', 'scaddon'),
                'type' => Controls_Manager::CHOOSE,
                'options' => [
                    'left' => [
                        'title' => esc_html__('Left', 'scaddon'),
                        'icon' => 'fa fa-align-left',
                    ],
                    'center' => [
                        'title' => esc_html__('Center', 'scaddon'),
                        'icon' => 'fa fa-align-center',
                    ],
                    'right' => [
                        'title' => esc_html__('Right', 'scaddon'),
                        'icon' => 'fa fa-align-right',
                    ],
                    'justify' => [
                        'title' => esc_html__('Justify', 'scaddon'),
                        'icon' => 'fa fa-align-justify',
                    ],
                ],
                'default' => 'left',
                'toggle' => true,
                'selectors' => [
                    '{{WRAPPER}} .widget-list' => 'text-align: {{VALUE}}'
                ],
                'separator' => 'before',
            ]
        );
     
        $this->end_controls_section();
        $this->start_controls_section(
            '_section_area_style',
            [
                'label' => esc_html__('Menu Style', 'staco-core'),
                'tab'   => Controls_Manager::TAB_STYLE,
            ]
        );
        $this->add_control(
            'menu_color',
            [
                'label' => esc_html__('Color', 'staco-core'),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .widget-list li a' => 'color: {{VALUE}}',
                ],
            ]
        );
        $this->add_control(
            'menu_color_active',
            [
                'label' => esc_html__('Active & Hover Color', 'staco-core'),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .widget-list li a:hover, {{WRAPPER}} .widget-list li.current a' => 'color: {{VALUE}}',
                ],
            ]
        );

        $this->add_control(
            'menu_color_bg',
            [
                'label' => esc_html__('Background', 'staco-core'),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .widget-list li a' => 'background: {{VALUE}}',
                ],
            ]
        );
        $this->add_control(
            'menu_color_active_bg',
            [
                'label' => esc_html__('Active & Hover Background', 'staco-core'),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .widget-list li a:hover, {{WRAPPER}} .widget-list li.current a' => 'background: {{VALUE}}',
                ],
            ]
        );
        $this->add_responsive_control(
            'menu_padding',
            [
                'label' => esc_html__('Padding', 'staco-core'),
                'type' => Controls_Manager::DIMENSIONS,
                'size_units' => ['px', 'em', '%'],
                'selectors' => [
                    '{{WRAPPER}} .widget-list li a' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );
        $this->add_responsive_control(
            'menu_margin',
            [
                'label' => esc_html__('Margin', 'staco-core'),
                'type' => Controls_Manager::DIMENSIONS,
                'size_units' => ['px', 'em', '%'],
                'selectors' => [
                    '{{WRAPPER}} .widget-list li' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );
        $this->add_group_control(
			Group_Control_Typography::get_type(),
			[
				'name'     => 'title_typography',
				'label'    => esc_html__( 'Typography', 'staco-core' ),
				'selector' => '{{WRAPPER}} .widget-list li a',
			]
		);
        $this->add_group_control(
            Group_Control_Border::get_type(),
            [
                'name' => 'menu_border',
                'selector' => '{{WRAPPER}} .widget-list li a',
            ]
        );
        $this->end_controls_section();
    }
	protected function render() {
		$data     = $this->get_settings();
		$template = 'view';
		$this->rt_template( $template, $data );
	}

}