<?php
/**
 * @author  UiGigs
 * @since   1.0
 * @version 1.0
 */

use Elementor\Icons_Manager; ?>
<div class="row live-auctions-slider">
    <?php 
        foreach ( $data['step_list'] as $item ){  
    ?>
    <div class="col-md-12">
        <div class="nft-card">
            <div class="nft-card-timer">
                <ul class="timer_1">
                    <li class="hours">15<span>h</span></li>
                    <li class="minutes">50<span>m</span></li>
                    <li class="seconds">38<span>s</span></li>
                </ul>
                <p>Left</p>
            </div>
            <div class="nft-img">
                <?php echo wp_get_attachment_image( $item['big_image']['id'], 'full' ); ?>
            </div>
            <div class="nft-text">
                <div class="nft-owner">
                    <div class="nft-owner-img">
                       <?php echo wp_get_attachment_image( $item['image_icon']['id'], 'full' ); ?>
                    </div>
                    <h6 class="wt-600 dm-sans"><?php echo wp_kses_post( $item['author'] ) ?> <?php echo wp_get_attachment_image( $item['check_img']['id'], 'full' ); ?></h6>
                </div>
                
                <h5 class="nft-title wt-700 dm-sans"><?php echo wp_kses_post( $item['title'] ) ?></h5>
                
                <p class="nft-value"><strong><?php echo wp_kses_post( $item['collections'] ) ?></strong> <span><?php echo wp_get_attachment_image( $item['arrow_icon']['id'], 'full' ); ?>0.82</span></p>
                <p class="card-bottom-text"><span>2 / 48</span> <span><span>&hearts;</span> &nbsp;124</span></p>
            </div>
        </div>
    </div>
    <?php } ?>
</div>

<div class="top-artists-content">
    <div class="top-artists-time">
        <ul>
             <?php 
                foreach ( $data['step_list'] as $item ){  
            ?>
            <li class="artistsTablinks" onclick="openTab(event, '1d')">1d</li>
            <li class="artistsTablinks" onclick="openTab(event, '7d')" id="artistsTabOpen">7d</li>
            <li class="artistsTablinks" onclick="openTab(event, '1m')">1m</li>
            <li class="artistsTablinks" onclick="openTab(event, '3m')">3m</li>
            <li class="artistsTablinks" onclick="openTab(event, '1y')">1y</li>
            <li class="artistsTablinks" onclick="openTab(event, 'all')">All</li>
             <?php } ?>
        </ul>
    </div>
    
    <div id="1d" class="artistsTabcontent">
        <ul class="top-artists-list">
            <li>
                <div class="top-artists-card">
                    <div class="no"># 1</div>
                    <div class="top-artists-img">
                        <img src="./assets/images/nft/artists1.png" alt="img" />
                    </div>
                    <div class="top-artists-text">
                        <p class="artists-name">Nia Lane <span><img src="./assets/images/nft/icon-verified.svg" alt="icon"></span></p>
                        <p class="artists-value">12.52 eth</p>
                    </div>
                </div>
            </li>

            <li>
                <div class="top-artists-card">
                    <div class="no"># 2</div>
                    <div class="top-artists-img">
                        <img src="./assets/images/nft/artists2.png" alt="img" />
                    </div>
                    <div class="top-artists-text">
                        <p class="artists-name">Lisa Harris <span><img src="./assets/images/nft/icon-verified.svg" alt="icon"></span></p>
                        <p class="artists-value">10.28 eth </p>
                    </div>
                </div>
            </li>

            <li>
                <div class="top-artists-card">
                    <div class="no"># 3</div>
                    <div class="top-artists-img">
                        <img src="./assets/images/nft/artists3.png" alt="img" />
                    </div>
                    <div class="top-artists-text">
                        <p class="artists-name">Ryan Lefevre <span><img src="./assets/images/nft/icon-verified.svg" alt="icon"></span></p>
                        <p class="artists-value">9.85 eth</p>
                    </div>
                </div>
            </li>

            <li>
                <div class="top-artists-card">
                    <div class="no"># 4</div>
                    <div class="top-artists-img">
                        <img src="./assets/images/nft/artists4.png" alt="img" />
                    </div>
                    <div class="top-artists-text">
                        <p class="artists-name">Daniel Gow <span><img src="./assets/images/nft/icon-verified.svg" alt="icon"></span></p>
                        <p class="artists-value">8.93 eth</p>
                    </div>
                </div>
            </li>

            <li>
                <div class="top-artists-card">
                    <div class="no"># 5</div>
                    <div class="top-artists-img">
                        <img src="./assets/images/nft/artists5.png" alt="img" />
                    </div>
                    <div class="top-artists-text">
                        <p class="artists-name">Katie R. Pines <span><img src="./assets/images/nft/icon-verified.svg" alt="icon"></span></p>
                        <p class="artists-value">6.42 eth</p>
                    </div>
                </div>
            </li>

            <li>
                <div class="top-artists-card">
                    <div class="no"># 6</div>
                    <div class="top-artists-img">
                        <img src="./assets/images/nft/artists6.png" alt="img" />
                    </div>
                    <div class="top-artists-text">
                        <p class="artists-name">Rolek Nion <span><img src="./assets/images/nft/icon-verified.svg" alt="icon"></span></p>
                        <p class="artists-value">5.99 eth</p>
                    </div>
                </div>
            </li>

            <li>
                <div class="top-artists-card">
                    <div class="no"># 7</div>
                    <div class="top-artists-img">
                        <img src="./assets/images/nft/artists7.png" alt="img" />
                    </div>
                    <div class="top-artists-text">
                        <p class="artists-name">Robert Murray <span><img src="./assets/images/nft/icon-verified.svg" alt="icon"></span></p>
                        <p class="artists-value">5.66 eth </p>
                    </div>
                </div>
            </li>

            <li>
                <div class="top-artists-card">
                    <div class="no"># 8</div>
                    <div class="top-artists-img">
                        <img src="./assets/images/nft/artists8.png" alt="img" />
                    </div>
                    <div class="top-artists-text">
                        <p class="artists-name">Hutcherson <span><img src="./assets/images/nft/icon-verified.svg" alt="icon"></span></p>
                        <p class="artists-value">4.70 eth </p>
                    </div>
                </div>
            </li>

            <li>
                <div class="top-artists-card">
                    <div class="no"># 9</div>
                    <div class="top-artists-img">
                        <img src="./assets/images/nft/artists9.png" alt="img" />
                    </div>
                    <div class="top-artists-text">
                        <p class="artists-name">John Rones <span><img src="./assets/images/nft/icon-verified.svg" alt="icon"></span></p>
                        <p class="artists-value">4.00 eth</p>
                    </div>
                </div>
            </li>

            <li>
                <div class="top-artists-card">
                    <div class="no"># 5</div>
                    <div class="top-artists-img">
                        <img src="./assets/images/nft/artists5.png" alt="img" />
                    </div>
                    <div class="top-artists-text">
                        <p class="artists-name">Miranda<span><img src="./assets/images/nft/icon-verified.svg" alt="icon"></span></p>
                        <p class="artists-value">3.80 eth</p>
                    </div>
                </div>
            </li>
        </ul>
    </div>

    <div id="7d" class="artistsTabcontent">
        <ul class="top-artists-list">
            <li>
                <div class="top-artists-card">
                    <div class="no"># 1</div>
                    <div class="top-artists-img">
                        <img src="./assets/images/nft/artists4.png" alt="img" />
                    </div>
                    <div class="top-artists-text">
                        <p class="artists-name">Daniel Gow <span><img src="./assets/images/nft/icon-verified.svg" alt="icon"></span></p>
                        <p class="artists-value">8.93 eth</p>
                    </div>
                </div>
            </li>

            <li>
                <div class="top-artists-card">
                    <div class="no"># 2</div>
                    <div class="top-artists-img">
                        <img src="./assets/images/nft/artists5.png" alt="img" />
                    </div>
                    <div class="top-artists-text">
                        <p class="artists-name">Katie R. Pines <span><img src="./assets/images/nft/icon-verified.svg" alt="icon"></span></p>
                        <p class="artists-value">6.42 eth</p>
                    </div>
                </div>
            </li>

            <li>
                <div class="top-artists-card">
                    <div class="no"># 3</div>
                    <div class="top-artists-img">
                        <img src="./assets/images/nft/artists6.png" alt="img" />
                    </div>
                    <div class="top-artists-text">
                        <p class="artists-name">Rolek Nion <span><img src="./assets/images/nft/icon-verified.svg" alt="icon"></span></p>
                        <p class="artists-value">5.99 eth</p>
                    </div>
                </div>
            </li>

            <li>
                <div class="top-artists-card">
                    <div class="no"># 4</div>
                    <div class="top-artists-img">
                        <img src="./assets/images/nft/artists7.png" alt="img" />
                    </div>
                    <div class="top-artists-text">
                        <p class="artists-name">Robert Murray <span><img src="./assets/images/nft/icon-verified.svg" alt="icon"></span></p>
                        <p class="artists-value">5.66 eth </p>
                    </div>
                </div>
            </li>
            
            <li>
                <div class="top-artists-card">
                    <div class="no"># 5</div>
                    <div class="top-artists-img">
                        <img src="./assets/images/nft/artists1.png" alt="img" />
                    </div>
                    <div class="top-artists-text">
                        <p class="artists-name">Nia Lane <span><img src="./assets/images/nft/icon-verified.svg" alt="icon"></span></p>
                        <p class="artists-value">12.52 eth</p>
                    </div>
                </div>
            </li>

            <li>
                <div class="top-artists-card">
                    <div class="no"># 6</div>
                    <div class="top-artists-img">
                        <img src="./assets/images/nft/artists2.png" alt="img" />
                    </div>
                    <div class="top-artists-text">
                        <p class="artists-name">Lisa Harris <span><img src="./assets/images/nft/icon-verified.svg" alt="icon"></span></p>
                        <p class="artists-value">10.28 eth </p>
                    </div>
                </div>
            </li>

            <li>
                <div class="top-artists-card">
                    <div class="no"># 7</div>
                    <div class="top-artists-img">
                        <img src="./assets/images/nft/artists3.png" alt="img" />
                    </div>
                    <div class="top-artists-text">
                        <p class="artists-name">Ryan Lefevre <span><img src="./assets/images/nft/icon-verified.svg" alt="icon"></span></p>
                        <p class="artists-value">9.85 eth</p>
                    </div>
                </div>
            </li>

            <li>
                <div class="top-artists-card">
                    <div class="no"># 8</div>
                    <div class="top-artists-img">
                        <img src="./assets/images/nft/artists8.png" alt="img" />
                    </div>
                    <div class="top-artists-text">
                        <p class="artists-name">Hutcherson <span><img src="./assets/images/nft/icon-verified.svg" alt="icon"></span></p>
                        <p class="artists-value">4.70 eth </p>
                    </div>
                </div>
            </li>

            <li>
                <div class="top-artists-card">
                    <div class="no"># 9</div>
                    <div class="top-artists-img">
                        <img src="./assets/images/nft/artists9.png" alt="img" />
                    </div>
                    <div class="top-artists-text">
                        <p class="artists-name">John Rones <span><img src="./assets/images/nft/icon-verified.svg" alt="icon"></span></p>
                        <p class="artists-value">4.00 eth</p>
                    </div>
                </div>
            </li>

            <li>
                <div class="top-artists-card">
                    <div class="no"># 5</div>
                    <div class="top-artists-img">
                        <img src="./assets/images/nft/artists5.png" alt="img" />
                    </div>
                    <div class="top-artists-text">
                        <p class="artists-name">Miranda<span><img src="./assets/images/nft/icon-verified.svg" alt="icon"></span></p>
                        <p class="artists-value">3.80 eth</p>
                    </div>
                </div>
            </li>
        </ul>
    </div>

    <div id="1m" class="artistsTabcontent">
        <ul class="top-artists-list">
            <li>
                <div class="top-artists-card">
                    <div class="no"># 1</div>
                    <div class="top-artists-img">
                        <img src="./assets/images/nft/artists7.png" alt="img" />
                    </div>
                    <div class="top-artists-text">
                        <p class="artists-name">Robert Murray <span><img src="./assets/images/nft/icon-verified.svg" alt="icon"></span></p>
                        <p class="artists-value">5.66 eth </p>
                    </div>
                </div>
            </li>

            <li>
                <div class="top-artists-card">
                    <div class="no"># 2</div>
                    <div class="top-artists-img">
                        <img src="./assets/images/nft/artists8.png" alt="img" />
                    </div>
                    <div class="top-artists-text">
                        <p class="artists-name">Hutcherson <span><img src="./assets/images/nft/icon-verified.svg" alt="icon"></span></p>
                        <p class="artists-value">4.70 eth </p>
                    </div>
                </div>
            </li>

            <li>
                <div class="top-artists-card">
                    <div class="no"># 3</div>
                    <div class="top-artists-img">
                        <img src="./assets/images/nft/artists9.png" alt="img" />
                    </div>
                    <div class="top-artists-text">
                        <p class="artists-name">John Rones <span><img src="./assets/images/nft/icon-verified.svg" alt="icon"></span></p>
                        <p class="artists-value">4.00 eth</p>
                    </div>
                </div>
            </li>

            <li>
                <div class="top-artists-card">
                    <div class="no"># 4</div>
                    <div class="top-artists-img">
                        <img src="./assets/images/nft/artists5.png" alt="img" />
                    </div>
                    <div class="top-artists-text">
                        <p class="artists-name">Miranda<span><img src="./assets/images/nft/icon-verified.svg" alt="icon"></span></p>
                        <p class="artists-value">3.80 eth</p>
                    </div>
                </div>
            </li>
            
            <li>
                <div class="top-artists-card">
                    <div class="no"># 5</div>
                    <div class="top-artists-img">
                        <img src="./assets/images/nft/artists1.png" alt="img" />
                    </div>
                    <div class="top-artists-text">
                        <p class="artists-name">Nia Lane <span><img src="./assets/images/nft/icon-verified.svg" alt="icon"></span></p>
                        <p class="artists-value">12.52 eth</p>
                    </div>
                </div>
            </li>

            <li>
                <div class="top-artists-card">
                    <div class="no"># 6</div>
                    <div class="top-artists-img">
                        <img src="./assets/images/nft/artists2.png" alt="img" />
                    </div>
                    <div class="top-artists-text">
                        <p class="artists-name">Lisa Harris <span><img src="./assets/images/nft/icon-verified.svg" alt="icon"></span></p>
                        <p class="artists-value">10.28 eth </p>
                    </div>
                </div>
            </li>

            <li>
                <div class="top-artists-card">
                    <div class="no"># 7</div>
                    <div class="top-artists-img">
                        <img src="./assets/images/nft/artists3.png" alt="img" />
                    </div>
                    <div class="top-artists-text">
                        <p class="artists-name">Ryan Lefevre <span><img src="./assets/images/nft/icon-verified.svg" alt="icon"></span></p>
                        <p class="artists-value">9.85 eth</p>
                    </div>
                </div>
            </li>

            <li>
                <div class="top-artists-card">
                    <div class="no"># 8</div>
                    <div class="top-artists-img">
                        <img src="./assets/images/nft/artists4.png" alt="img" />
                    </div>
                    <div class="top-artists-text">
                        <p class="artists-name">Daniel Gow <span><img src="./assets/images/nft/icon-verified.svg" alt="icon"></span></p>
                        <p class="artists-value">8.93 eth</p>
                    </div>
                </div>
            </li>

            <li>
                <div class="top-artists-card">
                    <div class="no"># 9</div>
                    <div class="top-artists-img">
                        <img src="./assets/images/nft/artists5.png" alt="img" />
                    </div>
                    <div class="top-artists-text">
                        <p class="artists-name">Katie R. Pines <span><img src="./assets/images/nft/icon-verified.svg" alt="icon"></span></p>
                        <p class="artists-value">6.42 eth</p>
                    </div>
                </div>
            </li>

            <li>
                <div class="top-artists-card">
                    <div class="no"># 10</div>
                    <div class="top-artists-img">
                        <img src="./assets/images/nft/artists6.png" alt="img" />
                    </div>
                    <div class="top-artists-text">
                        <p class="artists-name">Rolek Nion <span><img src="./assets/images/nft/icon-verified.svg" alt="icon"></span></p>
                        <p class="artists-value">5.99 eth</p>
                    </div>
                </div>
            </li>
        </ul>
    </div>
    
    <div id="3m" class="artistsTabcontent">
        <ul class="top-artists-list">
            <li>
                <div class="top-artists-card">
                    <div class="no"># 1</div>
                    <div class="top-artists-img">
                        <img src="./assets/images/nft/artists7.png" alt="img" />
                    </div>
                    <div class="top-artists-text">
                        <p class="artists-name">Robert Murray <span><img src="./assets/images/nft/icon-verified.svg" alt="icon"></span></p>
                        <p class="artists-value">5.66 eth </p>
                    </div>
                </div>
            </li>

            <li>
                <div class="top-artists-card">
                    <div class="no"># 2</div>
                    <div class="top-artists-img">
                        <img src="./assets/images/nft/artists8.png" alt="img" />
                    </div>
                    <div class="top-artists-text">
                        <p class="artists-name">Hutcherson <span><img src="./assets/images/nft/icon-verified.svg" alt="icon"></span></p>
                        <p class="artists-value">4.70 eth </p>
                    </div>
                </div>
            </li>

            <li>
                <div class="top-artists-card">
                    <div class="no"># 3</div>
                    <div class="top-artists-img">
                        <img src="./assets/images/nft/artists9.png" alt="img" />
                    </div>
                    <div class="top-artists-text">
                        <p class="artists-name">John Rones <span><img src="./assets/images/nft/icon-verified.svg" alt="icon"></span></p>
                        <p class="artists-value">4.00 eth</p>
                    </div>
                </div>
            </li>
            
            <li>
                <div class="top-artists-card">
                    <div class="no"># 4</div>
                    <div class="top-artists-img">
                        <img src="./assets/images/nft/artists2.png" alt="img" />
                    </div>
                    <div class="top-artists-text">
                        <p class="artists-name">Lisa Harris <span><img src="./assets/images/nft/icon-verified.svg" alt="icon"></span></p>
                        <p class="artists-value">10.28 eth </p>
                    </div>
                </div>
            </li>

            <li>
                <div class="top-artists-card">
                    <div class="no"># 5</div>
                    <div class="top-artists-img">
                        <img src="./assets/images/nft/artists3.png" alt="img" />
                    </div>
                    <div class="top-artists-text">
                        <p class="artists-name">Ryan Lefevre <span><img src="./assets/images/nft/icon-verified.svg" alt="icon"></span></p>
                        <p class="artists-value">9.85 eth</p>
                    </div>
                </div>
            </li>

            <li>
                <div class="top-artists-card">
                    <div class="no"># 6</div>
                    <div class="top-artists-img">
                        <img src="./assets/images/nft/artists4.png" alt="img" />
                    </div>
                    <div class="top-artists-text">
                        <p class="artists-name">Daniel Gow <span><img src="./assets/images/nft/icon-verified.svg" alt="icon"></span></p>
                        <p class="artists-value">8.93 eth</p>
                    </div>
                </div>
            </li>

            <li>
                <div class="top-artists-card">
                    <div class="no"># 7</div>
                    <div class="top-artists-img">
                        <img src="./assets/images/nft/artists1.png" alt="img" />
                    </div>
                    <div class="top-artists-text">
                        <p class="artists-name">Nia Lane <span><img src="./assets/images/nft/icon-verified.svg" alt="icon"></span></p>
                        <p class="artists-value">12.52 eth</p>
                    </div>
                </div>
            </li>

            <li>
                <div class="top-artists-card">
                    <div class="no"># 8</div>
                    <div class="top-artists-img">
                        <img src="./assets/images/nft/artists5.png" alt="img" />
                    </div>
                    <div class="top-artists-text">
                        <p class="artists-name">Katie R. Pines <span><img src="./assets/images/nft/icon-verified.svg" alt="icon"></span></p>
                        <p class="artists-value">6.42 eth</p>
                    </div>
                </div>
            </li>

            <li>
                <div class="top-artists-card">
                    <div class="no"># 9</div>
                    <div class="top-artists-img">
                        <img src="./assets/images/nft/artists6.png" alt="img" />
                    </div>
                    <div class="top-artists-text">
                        <p class="artists-name">Rolek Nion <span><img src="./assets/images/nft/icon-verified.svg" alt="icon"></span></p>
                        <p class="artists-value">5.99 eth</p>
                    </div>
                </div>
            </li>

            <li>
                <div class="top-artists-card">
                    <div class="no"># 10</div>
                    <div class="top-artists-img">
                        <img src="./assets/images/nft/artists5.png" alt="img" />
                    </div>
                    <div class="top-artists-text">
                        <p class="artists-name">Miranda<span><img src="./assets/images/nft/icon-verified.svg" alt="icon"></span></p>
                        <p class="artists-value">3.80 eth</p>
                    </div>
                </div>
            </li>
        </ul>
    </div>
    
    <div id="1y" class="artistsTabcontent">
        <ul class="top-artists-list">
            <li>
                <div class="top-artists-card">
                    <div class="no"># 1</div>
                    <div class="top-artists-img">
                        <img src="./assets/images/nft/artists9.png" alt="img" />
                    </div>
                    <div class="top-artists-text">
                        <p class="artists-name">John Rones <span><img src="./assets/images/nft/icon-verified.svg" alt="icon"></span></p>
                        <p class="artists-value">4.00 eth</p>
                    </div>
                </div>
            </li>
            
            <li>
                <div class="top-artists-card">
                    <div class="no"># 2</div>
                    <div class="top-artists-img">
                        <img src="./assets/images/nft/artists5.png" alt="img" />
                    </div>
                    <div class="top-artists-text">
                        <p class="artists-name">Katie R. Pines <span><img src="./assets/images/nft/icon-verified.svg" alt="icon"></span></p>
                        <p class="artists-value">6.42 eth</p>
                    </div>
                </div>
            </li>

            <li>
                <div class="top-artists-card">
                    <div class="no"># 3</div>
                    <div class="top-artists-img">
                        <img src="./assets/images/nft/artists6.png" alt="img" />
                    </div>
                    <div class="top-artists-text">
                        <p class="artists-name">Rolek Nion <span><img src="./assets/images/nft/icon-verified.svg" alt="icon"></span></p>
                        <p class="artists-value">5.99 eth</p>
                    </div>
                </div>
            </li>

            <li>
                <div class="top-artists-card">
                    <div class="no"># 4</div>
                    <div class="top-artists-img">
                        <img src="./assets/images/nft/artists5.png" alt="img" />
                    </div>
                    <div class="top-artists-text">
                        <p class="artists-name">Miranda<span><img src="./assets/images/nft/icon-verified.svg" alt="icon"></span></p>
                        <p class="artists-value">3.80 eth</p>
                    </div>
                </div>
            </li>
            
            <li>
                <div class="top-artists-card">
                    <div class="no"># 5</div>
                    <div class="top-artists-img">
                        <img src="./assets/images/nft/artists1.png" alt="img" />
                    </div>
                    <div class="top-artists-text">
                        <p class="artists-name">Nia Lane <span><img src="./assets/images/nft/icon-verified.svg" alt="icon"></span></p>
                        <p class="artists-value">12.52 eth</p>
                    </div>
                </div>
            </li>

            <li>
                <div class="top-artists-card">
                    <div class="no"># 6</div>
                    <div class="top-artists-img">
                        <img src="./assets/images/nft/artists2.png" alt="img" />
                    </div>
                    <div class="top-artists-text">
                        <p class="artists-name">Lisa Harris <span><img src="./assets/images/nft/icon-verified.svg" alt="icon"></span></p>
                        <p class="artists-value">10.28 eth </p>
                    </div>
                </div>
            </li>

            <li>
                <div class="top-artists-card">
                    <div class="no"># 7</div>
                    <div class="top-artists-img">
                        <img src="./assets/images/nft/artists3.png" alt="img" />
                    </div>
                    <div class="top-artists-text">
                        <p class="artists-name">Ryan Lefevre <span><img src="./assets/images/nft/icon-verified.svg" alt="icon"></span></p>
                        <p class="artists-value">9.85 eth</p>
                    </div>
                </div>
            </li>

            <li>
                <div class="top-artists-card">
                    <div class="no"># 8</div>
                    <div class="top-artists-img">
                        <img src="./assets/images/nft/artists4.png" alt="img" />
                    </div>
                    <div class="top-artists-text">
                        <p class="artists-name">Daniel Gow <span><img src="./assets/images/nft/icon-verified.svg" alt="icon"></span></p>
                        <p class="artists-value">8.93 eth</p>
                    </div>
                </div>
            </li>

            <li>
                <div class="top-artists-card">
                    <div class="no"># 9</div>
                    <div class="top-artists-img">
                        <img src="./assets/images/nft/artists7.png" alt="img" />
                    </div>
                    <div class="top-artists-text">
                        <p class="artists-name">Robert Murray <span><img src="./assets/images/nft/icon-verified.svg" alt="icon"></span></p>
                        <p class="artists-value">5.66 eth </p>
                    </div>
                </div>
            </li>

            <li>
                <div class="top-artists-card">
                    <div class="no"># 10</div>
                    <div class="top-artists-img">
                        <img src="./assets/images/nft/artists8.png" alt="img" />
                    </div>
                    <div class="top-artists-text">
                        <p class="artists-name">Hutcherson <span><img src="./assets/images/nft/icon-verified.svg" alt="icon"></span></p>
                        <p class="artists-value">4.70 eth </p>
                    </div>
                </div>
            </li>
        </ul>
    </div>
    
    <div id="all" class="artistsTabcontent">
        <ul class="top-artists-list">
            <li>
                <div class="top-artists-card">
                    <div class="no"># 1</div>
                    <div class="top-artists-img">
                        <img src="./assets/images/nft/artists8.png" alt="img" />
                    </div>
                    <div class="top-artists-text">
                        <p class="artists-name">Hutcherson <span><img src="./assets/images/nft/icon-verified.svg" alt="icon"></span></p>
                        <p class="artists-value">4.70 eth </p>
                    </div>
                </div>
            </li>
            
            <li>
                <div class="top-artists-card">
                    <div class="no"># 2</div>
                    <div class="top-artists-img">
                        <img src="./assets/images/nft/artists9.png" alt="img" />
                    </div>
                    <div class="top-artists-text">
                        <p class="artists-name">John Rones <span><img src="./assets/images/nft/icon-verified.svg" alt="icon"></span></p>
                        <p class="artists-value">4.00 eth</p>
                    </div>
                </div>
            </li>
            
            <li>
                <div class="top-artists-card">
                    <div class="no"># 3</div>
                    <div class="top-artists-img">
                        <img src="./assets/images/nft/artists5.png" alt="img" />
                    </div>
                    <div class="top-artists-text">
                        <p class="artists-name">Katie R. Pines <span><img src="./assets/images/nft/icon-verified.svg" alt="icon"></span></p>
                        <p class="artists-value">6.42 eth</p>
                    </div>
                </div>
            </li>

            <li>
                <div class="top-artists-card">
                    <div class="no"># 4</div>
                    <div class="top-artists-img">
                        <img src="./assets/images/nft/artists6.png" alt="img" />
                    </div>
                    <div class="top-artists-text">
                        <p class="artists-name">Rolek Nion <span><img src="./assets/images/nft/icon-verified.svg" alt="icon"></span></p>
                        <p class="artists-value">5.99 eth</p>
                    </div>
                </div>
            </li>

            <li>
                <div class="top-artists-card">
                    <div class="no"># 5</div>
                    <div class="top-artists-img">
                        <img src="./assets/images/nft/artists5.png" alt="img" />
                    </div>
                    <div class="top-artists-text">
                        <p class="artists-name">Miranda<span><img src="./assets/images/nft/icon-verified.svg" alt="icon"></span></p>
                        <p class="artists-value">3.80 eth</p>
                    </div>
                </div>
            </li>
            
            <li>
                <div class="top-artists-card">
                    <div class="no"># 6</div>
                    <div class="top-artists-img">
                        <img src="./assets/images/nft/artists1.png" alt="img" />
                    </div>
                    <div class="top-artists-text">
                        <p class="artists-name">Nia Lane <span><img src="./assets/images/nft/icon-verified.svg" alt="icon"></span></p>
                        <p class="artists-value">12.52 eth</p>
                    </div>
                </div>
            </li>

            <li>
                <div class="top-artists-card">
                    <div class="no"># 7</div>
                    <div class="top-artists-img">
                        <img src="./assets/images/nft/artists2.png" alt="img" />
                    </div>
                    <div class="top-artists-text">
                        <p class="artists-name">Lisa Harris <span><img src="./assets/images/nft/icon-verified.svg" alt="icon"></span></p>
                        <p class="artists-value">10.28 eth </p>
                    </div>
                </div>
            </li>

            <li>
                <div class="top-artists-card">
                    <div class="no"># 8</div>
                    <div class="top-artists-img">
                        <img src="./assets/images/nft/artists3.png" alt="img" />
                    </div>
                    <div class="top-artists-text">
                        <p class="artists-name">Ryan Lefevre <span><img src="./assets/images/nft/icon-verified.svg" alt="icon"></span></p>
                        <p class="artists-value">9.85 eth</p>
                    </div>
                </div>
            </li>

            <li>
                <div class="top-artists-card">
                    <div class="no"># 9</div>
                    <div class="top-artists-img">
                        <img src="./assets/images/nft/artists4.png" alt="img" />
                    </div>
                    <div class="top-artists-text">
                        <p class="artists-name">Daniel Gow <span><img src="./assets/images/nft/icon-verified.svg" alt="icon"></span></p>
                        <p class="artists-value">8.93 eth</p>
                    </div>
                </div>
            </li>

            <li>
                <div class="top-artists-card">
                    <div class="no"># 10</div>
                    <div class="top-artists-img">
                        <img src="./assets/images/nft/artists7.png" alt="img" />
                    </div>
                    <div class="top-artists-text">
                        <p class="artists-name">Robert Murray <span><img src="./assets/images/nft/icon-verified.svg" alt="icon"></span></p>
                        <p class="artists-value">5.66 eth </p>
                    </div>
                </div>
            </li>
        </ul>
    </div>
</div>


<script>
    (function ($) {
    ("use strict");
        $(document).ready(function () {
            function openTab(evt, TabName) {
                var i, tabcontent, tablinks;
                tabcontent = document.getElementsByClassName("artistsTabcontent");
                for (i = 0; i < tabcontent.length; i++) {
                    tabcontent[i].style.display = "none";
                }
                tablinks = document.getElementsByClassName("artistsTablinks");
                for (i = 0; i < tablinks.length; i++) {
                    tablinks[i].className = tablinks[i].className.replace(" active", "");
                }
                document.getElementById(TabName).style.display = "block";
                evt.currentTarget.className += " active";
            }
            // Get the element with id="defaultOpen" and click on it
            document.getElementById("artistsTabOpen").click();
        });
    })(jQuery);
</script>


