<?php
/**
 * @author  UiGigs
 * @since   1.0
 * @version 1.0
 */

namespace UiGigs\Staco_Core;

use Elementor\Controls_Manager;
use Elementor\Group_Control_Background;
use Elementor\Group_Control_Typography;

if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

class AnimImg extends Custom_Widget_Base {

	public function __construct( $data = [], $args = null ) {
		$this->rt_name = esc_html__( 'Logo Showcase', 'staco-core' );
		$this->rt_base = 'staco-anim-img';
		parent::__construct( $data, $args );
	}
	protected function register_controls() {
		/* = Banner 2 Options
		============================================*/
		

		$this->start_controls_section(
			'anim_img_section',
			[
				'label' => esc_html__( 'Logo Showcase', 'staco-core' ),
				'tab'   => Controls_Manager::TAB_CONTENT,
			]
		);
		$this->add_control(
			'layout',
			[
				'label' => __('Layout Type', 'staco-core'),
				'type' => Controls_Manager::SELECT,
				'default' => 'style1',
				'options' => [
					'style1' => __( 'Style 1', 'staco-core' ),
					'style2' => __( 'Style 2', 'staco-core' ),
					'style3' => __( 'Style 3', 'staco-core' ),
					'style4' => __( 'Style 4', 'staco-core' ),
					'style5' => __( 'Style 5', 'staco-core' ),
					'style6' => __( 'Style 6', 'staco-core' ),
					'style7' => __( 'Style 7', 'staco-core' ),
				],
				'label_block' => true,
			]
		);

		$this->add_control(
			'shape_image',
			[
				'label'   => __( 'Image 3', 'staco-core' ),
				'type'    => \Elementor\Controls_Manager::MEDIA,
				'default' => [
					'url' => \Elementor\Utils::get_placeholder_image_src(),
				],
				'condition'      => ['layout' => ['style4']],
			]
		);

		$this->add_control(
			'animation_postion',
			[
				'label' => __('Animation Postion', 'staco-core'),
				'type' => Controls_Manager::SELECT,
				'default' => 'style1',
				'options' => [
					'style1' => __( 'Top to Bottom', 'staco-core' ),
					'style2' => __( 'Bottom to Top', 'staco-core' ),
				],
				'condition'      => ['layout' => 'style2'],
				'label_block' => true,
			]
		);
		$this->add_control(
			'speed_style',
			[
				'label' => __('Animation Speed', 'staco-core'),
				'type' => Controls_Manager::SELECT,
				'default' => 'multi-chain-list1',
				'options' => [
					'multi-chain-list1' => __( 'Slow', 'staco-core' ),
					'multi-chain-list2' => __( 'Fast 1', 'staco-core' ),
					'multi-chain-list4' => __( 'Fast 2', 'staco-core' ),
				],
				'label_block' => true,
			]
		);
		$repeater = new \Elementor\Repeater();
		$repeater->add_control(
			'anim_img', [
				'label'       => __( 'Image', 'staco-core' ),
				'type'        => \Elementor\Controls_Manager::MEDIA,
				'label_block' => true,
			]
		);
		$repeater->add_control(
            'title',
            [
                'label' => esc_html__( 'Title', 'staco-core' ),
                'type' => Controls_Manager::TEXT,
            ]
        );
		$repeater->add_control(
            'logo_link',
            [
                'label' => esc_html__( 'Logo Link', 'staco-core' ),
                'type' => Controls_Manager::TEXT,
            ]
        );

		$repeater->add_control(
			'bg_color_p',
			[
				'type'      => Controls_Manager::COLOR,
				'label'     => __( 'Bankground', 'staco-core' ),
				'separator' => '',
			]
		);
		

		 $this->add_control(
            'anim_img_list',
            [
                'show_label' => false,
                'type' => Controls_Manager::REPEATER,
                'fields' => $repeater->get_controls(),
                'title_field' => '{{{ title }}}',
            ]
        ); 

		
		$this->add_control(
			'btn_text',
			[
				'label'   => esc_html__( 'Button Text', 'staco-core' ),
				'type'    => Controls_Manager::TEXT,
				'condition'      => ['layout' => 'style4'],
			]
		);
		$this->add_control(
			'btn_link',
			[
				'label'   => esc_html__( 'Button Link', 'staco-core' ),
				'type'    => Controls_Manager::TEXT,
				'condition'      => ['layout' => 'style4'],
			]
		);

		$this->add_control(
			'btn_icon',
			[
				'label'   => __( 'Button Icon', 'staco-core' ),
				'type'    => \Elementor\Controls_Manager::MEDIA,
				'default' => [
					'url' => \Elementor\Utils::get_placeholder_image_src(),
				],
				'condition'      => ['layout' => ['style4']],
			]
		);
		
		
		$this->end_controls_section();

		$this->start_controls_section(
			'title_section',
			[
				'label' => esc_html__( 'Title Style', 'staco-core' ),
				'tab'   => Controls_Manager::TAB_STYLE,
			]
		);

		$this->add_control(
            'title_color',
            [
                'label' => esc_html__( 'Title Color', 'rsaddon' ),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .slider-item .brand-title' => 'color: {{VALUE}};',
                ],
            ]
        );

		$this->add_responsive_control(
            'title_margin',
            [
                'label' => esc_html__( 'Margin', 'rsaddon' ),
                'type' => Controls_Manager::DIMENSIONS,
                'size_units' => [ 'px', 'em', '%' ],
                'selectors' => [
                    '{{WRAPPER}} .slider-item .brand-title' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );


		$this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'name' => 'title_typography',
                'label' => esc_html__( 'Typography', 'rsaddon' ),
                'selector' => '{{WRAPPER}} .slider-item .brand-title',
            ]
        );
		$this->end_controls_section();

		$this->start_controls_section(
			'item_style',
			[
				'label' => esc_html__( 'Style', 'staco-core' ),
				'tab'   => Controls_Manager::TAB_STYLE,
			]
		);

		$this->add_control(
			'reverse_layout',
			[
				'label' => __('Animation Reverse ', 'staco-core'),
				'type' => Controls_Manager::SELECT,
				'default' => 'normal_style',
				'options' => [
					'normal_style' => __( 'Normal Style', 'staco-core' ),
					'reverse_style' => __( 'Reverse Style', 'staco-core' ),
				],
				'label_block' => true,
			]
		);

		$this->add_control(
			'width_auto',
			[
				'label' => __('Select Width ', 'staco-core'),
				'type' => Controls_Manager::SELECT,
				'default' => 'normal_width',
				'options' => [
					'normal_width' => __( 'Normal Width', 'staco-core' ),
					'reverse_width' => __( 'Width Auto', 'staco-core' ),
				],
				'label_block' => true,
			]
		);

		$this->add_responsive_control(
			'item_width',
			[
				'label' => esc_html__('Width', 'staco-core'),
				'type' => Controls_Manager::SLIDER,
				'size_units' => ['px'],
				'range' => [
					'px' => [
						'min' => 10,
						'max' => 300,
					],
				],
				'selectors' => [
					'{{WRAPPER}} .brands-slider .slider-item' => 'min-width: {{SIZE}}{{UNIT}} !important;',
				],
			]
		);
		$this->add_responsive_control(
			'item_max-width',
			[
				'label' => esc_html__('Max Width', 'staco-core'),
				'type' => Controls_Manager::SLIDER,
				'size_units' => ['px'],
				'range' => [
					'px' => [
						'min' => 10,
						'max' => 300,
					],
				],
				'selectors' => [
					'{{WRAPPER}} .brands-slider .slider-item' => 'max-width: {{SIZE}}{{UNIT}} !important;',
				],
			]
		);
		$this->add_responsive_control(
			'item_height',
			[
				'label' => esc_html__('Height', 'staco-core'),
				'type' => Controls_Manager::SLIDER,
				'size_units' => ['px'],
				'range' => [
					'px' => [
						'min' => 10,
						'max' => 300,
					],
				],
				'selectors' => [
					'{{WRAPPER}} .brands-slider .slider-item' => 'height: {{SIZE}}{{UNIT}} !important;',
				],
			]
		);
		$this->add_responsive_control(
			'item_lineheight',
			[
				'label' => esc_html__('Line Height', 'staco-core'),
				'type' => Controls_Manager::SLIDER,
				'size_units' => ['px'],
				'range' => [
					'px' => [
						'min' => 10,
						'max' => 300,
					],
				],
				'selectors' => [
					'{{WRAPPER}} .brands-slider .slider-item' => 'line-height: {{SIZE}}{{UNIT}} !important;',
				],
			]
		);

		$this->add_control(
			'sec_bg',
			[
				'label' => __('Select Background ', 'staco-core'),
				'type' => Controls_Manager::SELECT,
				'default' => 'normal',
				'options' => [
					'normal' => __( 'Normal Background', 'staco-core' ),
					'gradient' => __( 'Gradient Background', 'staco-core' ),
				],
				'label_block' => true,
			]
		);

		$this->add_control(
			'box_bg_color',
			[
				'type'      => Controls_Manager::COLOR,
				'label'     => __( 'Bankground', 'staco-core' ),
				'separator' => '',
				'selectors' => [
					'{{WRAPPER}} .brands-slider .slider-item' => 'background: {{VALUE}};',
				],
				'condition'      => ['sec_bg' => 'normal'],
			]
		);
		$this->add_group_control(
			Group_Control_Background::get_type(),
			[
				'name' => 'item_bg_gradient_color',
				'label' => esc_html__('Shape Background', 'staco-core'),
				'types' => ['classic', 'gradient'],
				'selector' => '{{WRAPPER}} .brands-slider .slider-item',
				'condition'      => ['sec_bg' => 'gradient'],
			]
		);
		$this->add_control(
			'border_radius',
			[
				'label' => esc_html__('Border Radius', 'staco-core'),
				'type' => Controls_Manager::DIMENSIONS,
				'size_units' => ['px', '%'],
				'selectors' => [
					'{{WRAPPER}} .brands-slider .slider-item' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				],
			]
		);
		$this->add_group_control(
			Group_Control_Background::get_type(),
			[
				'name' => 'item_bg_color',
				'label' => esc_html__('Shape Background', 'staco-core'),
				'types' => ['classic', 'gradient'],
				'selector' => '{{WRAPPER}} .brands-slider::before, {{WRAPPER}} .brands-slider::after'
			]
		);
		$this->add_responsive_control(
			'item_margin',
			[
				'label'              => __( 'Margin', 'staco-core' ),
				'type'               => Controls_Manager::DIMENSIONS,
				'size_units'         => [ 'px' ],
				'default'            => [
					'top'      => '',
					'right'    => '',
					'bottom'   => '',
					'left'     => '',
					'isLinked' => false,
				],
				'selectors'          => [
					'{{WRAPPER}} .brands-slider .slider-item' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}}',
				],
			]
		);

		$this->add_responsive_control(
			'item_padding',
			[
				'label'              => __( 'Padding', 'staco-core' ),
				'type'               => Controls_Manager::DIMENSIONS,
				'size_units'         => [ 'px' ],
				'default'            => [
					'top'      => '',
					'right'    => '',
					'bottom'   => '',
					'left'     => '',
					'isLinked' => false,
				],
				'selectors'          => [
					'{{WRAPPER}} .brands-slider .slider-item' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}}',
				],
			]
		);

		$this->add_responsive_control(
			'item_gap',
			[
				'label' => esc_html__('Gap', 'staco-core'),
				'type' => Controls_Manager::SLIDER,
				'size_units' => ['px'],
				'range' => [
					'px' => [
						'min' => 10,
						'max' => 300,
					],
				],
				'selectors' => [
					'{{WRAPPER}} .brands-slider-container' => 'gap: {{SIZE}}{{UNIT}} !important;',
				],
			]
		);

		$this->add_responsive_control(
			'align',
			[
				'label' => esc_html__('Alignment', 'staco-core'),
				'type' => Controls_Manager::CHOOSE,
				'options' => [
					'flex-start' => [
						'title' => esc_html__('Left', 'staco-core'),
						'icon' => 'fa fa-align-left',
					],
					'center' => [
						'title' => esc_html__('Center', 'staco-core'),
						'icon' => 'fa fa-align-center',
					],
					'flex-end' => [
						'title' => esc_html__('Right', 'staco-core'),
						'icon' => 'fa fa-align-right',
					],
					'justify' => [
						'title' => esc_html__('Justify', 'staco-core'),
						'icon' => 'fa fa-align-justify',
					],
				],
				'toggle' => true,
				'selectors' => [
					'{{WRAPPER}} .brands-slider .slider-item' => 'justify-content: {{VALUE}}',
				],
				'separator' => 'before',
			]
		);
    }
	protected function render() {
		$data = $this->get_settings();
		$template = 'view';
		if ( 'style2' == $data['layout'] ) {
			$template = 'view-2';
		}
		if ( 'style3' == $data['layout'] ) {
			$template = 'view-3';
		}
		if ( 'style4' == $data['layout'] ) {
			$template = 'view-4';
		}
		if ( 'style5' == $data['layout'] ) {
			$template = 'view-5';
		}
		if ( 'style6' == $data['layout'] ) {
			$template = 'view-6';
		}
		if ( 'style7' == $data['layout'] ) {
			$template = 'view-7';
		}
		$this->rt_template( $template, $data );
	}

}