<?php
/**
 * @author  UiGigs
 * @since   1.0
 * @version 1.0
 */

namespace UiGigs\Staco_Core;
use Elementor\Controls_Manager;
use Elementor\Group_Control_Background;
use Elementor\Group_Control_Typography;

if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

class animatedHeading extends Custom_Widget_Base {

	public function __construct( $data = [], $args = null ) {
		$this->rt_name = esc_html__( 'Animated Heading', 'staco-core' );
		$this->rt_base = 'staco-animated-heading';
		parent::__construct( $data, $args );
	}
	protected function register_controls() {
		$this->start_controls_section(
			'global_content_section',
			[
				'label' => esc_html__( 'Global', 'staco-core' ),
				'tab' => Controls_Manager::TAB_CONTENT,
			]
		);

		$this->add_control(
			'layout',
			[
				'label' => __('Style', 'staco-core'),
				'type' => Controls_Manager::SELECT,
				'default' => 'style1',
				'options' => [
					'style1' => __( 'Style 1', 'staco-core' ),
					'style2' => __( 'Style 2', 'staco-core' ),
				],
				'label_block' => true,
			]
		);

		$this->add_control(
			'inline_style',
			[
				'label' => __('Inline', 'staco-core'),
				'type' => Controls_Manager::SELECT,
				'default' => 'inline_no',
				'options' => [
					'inline_yes' => __( 'Yes', 'staco-core' ),
					'inline_no' => __( 'No', 'staco-core' ),
				],
				'label_block' => true,
			]
		);

		$this->add_responsive_control(
            'align',
            [
                'label' => esc_html__( 'Alignment', 'staco-core' ),
                'type' => Controls_Manager::CHOOSE,
                'options' => [
                    'left' => [
						'title' => esc_html__( 'Left', 'staco-core' ),
						'icon'  => 'eicon-text-align-left',
                    ],
                    'center' => [
						'title' => esc_html__( 'Center', 'staco-core' ),
						'icon'  => 'eicon-text-align-center',
                    ],
                    'right' => [
						'title' => esc_html__( 'Right', 'staco-core' ),
						'icon'  => 'eicon-text-align-right',
                    ],
                    'justify' => [
						'title' => esc_html__( 'Justify', 'staco-core' ),
						'icon'  => 'eicon-text-align-justify',
                    ],
                ],
                'toggle' => true,
                'selectors' => [
                    '{{WRAPPER}} .staco-animated-heading' => 'text-align: {{VALUE}}'
                ]
            ]
        );
		$this->end_controls_section();


		$this->start_controls_section(
			'content_section',
			[
				'label' => esc_html__( 'Normal Title', 'staco-core' ),
				'tab' => Controls_Manager::TAB_CONTENT,
			]
		);


		$this->add_control(
			'title',
			[
				'label' => esc_html__( 'Normal Text', 'staco-core' ),
				'type' => Controls_Manager::TEXT,
				'default' => esc_html__( 'Animated Heading', 'staco-core' ),				
				'separator' => 'before',
			]
		);

		$this->add_control(
			'title_tag',
			[
				'label'   => esc_html__( 'Select Heading Tag', 'staco-core' ),
				'type'    => Controls_Manager::SELECT,
				'default' => 'h2',
				'options' => [						
					'h1' => esc_html__( 'H1', 'staco-core'),
					'h2' => esc_html__( 'H2', 'staco-core'),
					'h3' => esc_html__( 'H3', 'staco-core' ),
					'h4' => esc_html__( 'H4', 'staco-core' ),
					'h5' => esc_html__( 'H5', 'staco-core' ),
					'h6' => esc_html__( 'H6', 'staco-core' ),				
					
				],
			]
		);
		$this->end_controls_section();

		$this->start_controls_section(
			'animated_section',
			[
				'label' => esc_html__( 'Animated Title', 'staco-core' ),
				'tab' => Controls_Manager::TAB_CONTENT,	
				'condition' => [
					'layout' => [ 'style1' ],
				],						
			]
		);
		$this->add_control(
			'animated_text',
			[
				'type' => Controls_Manager::WYSIWYG,
				'rows' => 10,				
				'placeholder' => esc_html__( 'Animated Text here', 'staco-core' ),
			]
		);
		$this->end_controls_section();

		$this->start_controls_section(
			'animated_section2',
			[
				'label' => esc_html__( 'Animated Title', 'staco-core' ),
				'tab' => Controls_Manager::TAB_CONTENT,	
				'condition' => [
					'layout' => [ 'style2' ],
				],						
			]
		);
		$repeater = new \Elementor\Repeater();
		$repeater->add_control(
			'title_animate', [
				'label' => __( 'Title', 'evacon-core' ),
				'type' => \Elementor\Controls_Manager::TEXT,
				'label_block' => true,
			]
		);

		$this->add_control(
			'title_list',
			[
				'label'       => __( 'Title List ', 'staco-core' ),
				'type'        => \Elementor\Controls_Manager::REPEATER,
				'fields'      => $repeater->get_controls(),
				'default'     => [
					[
						'title_animate'    => 'Design.',
					],
					[
						'title_animate'    => 'Product.',
					],
					[
						'title_animate'    => 'Brands.',
					],
				],
				'title_field' => '{{{ title_animate }}}',
			]
		);
		$this->end_controls_section();


		$this->start_controls_section(
			'content_section_after',
			[
				'label' => esc_html__( 'After Animate Title', 'staco-core' ),
				'tab' => Controls_Manager::TAB_CONTENT,
			]
		);


		$this->add_control(
			'title_after',
			[
				'label' => esc_html__( 'Text', 'staco-core' ),
				'type' => Controls_Manager::TEXT,							
				'separator' => 'before',
			]
		);
	
		$this->end_controls_section();


		$this->start_controls_section(
			'des_section',
			[
				'label' => esc_html__( 'Description Text', 'staco-core' ),
				'tab' => Controls_Manager::TAB_CONTENT,
			]
		);

		$this->add_control(
			'content',
			[
				'type' => Controls_Manager::WYSIWYG,
				'rows' => 10,				
				'placeholder' => esc_html__( 'Type your description here', 'staco-core' ),
			]
		);
		
		$this->end_controls_section();


		$this->start_controls_section(
			'section_heading_style',
			[
				'label' => esc_html__( 'Normal', 'staco-core' ),
				'tab' => Controls_Manager::TAB_STYLE,
			]
		);

		$this->add_control(
            'title_color',
            [
                'label' => esc_html__( 'Title Color', 'staco-core' ),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .title-inner .title' => 'color: {{VALUE}};',
                ],                
            ]
        );

		$this->add_control(
            'title_bg',
            [
                'label' => esc_html__( 'Title Background', 'staco-core' ),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .title-inner .title' => 'background: {{VALUE}};',
                ],                
            ]
        );

		$this->add_control(
			'title_radius',
			[
				'label'     => __( 'Border Radius', 'staco-core' ),
				'type'      => Controls_Manager::SLIDER,
				'default'   => [
					'size' => 0,
				],
				'range'     => [
					'px' => [
						'min' => 0,
						'max' => 200,
					],
				],
				'selectors' => [
					'{{WRAPPER}} .title-inner .title' => 'border-radius: {{SIZE}}{{UNIT}}',
				],
			]
		);

		$this->add_group_control(
			Group_Control_Typography::get_type(),
			[
				'name' => 'title_typography',
				'label' => esc_html__( 'Title Typography', 'staco-core' ),
				'selector' => '{{WRAPPER}} .title-inner .title, {{WRAPPER}} .v7hero-section-text .banner-text h2',
			]
		);

		$this->add_responsive_control(
		    'normal_padding',
		    [
		        'label' => esc_html__( 'Padding', 'staco-core' ),
		        'type' => Controls_Manager::DIMENSIONS,
		        'size_units' => [ 'px', 'em', '%' ],
		        'selectors' => [
		            '{{WRAPPER}} .title-inner .title' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
		        ],
		    ]
		);
               
		$this->end_controls_section();


		$this->start_controls_section(
			'animate_heading_style',
			[
				'label' => esc_html__( 'Animated', 'staco-core' ),
				'tab' => Controls_Manager::TAB_STYLE,
			]
		);

		$this->add_control(
			'animate_style',
			[
				'label'   => esc_html__( 'Animated Style', 'staco-core' ),
				'type'    => Controls_Manager::SELECT,
				'default' => 'clip',
				'options' => [
					'rotate-1'    => esc_html__( 'Rotate', 'staco-core'),
					'loading-bar' => esc_html__( 'Loading-bar', 'staco-core'),
					'slide' 	  => esc_html__( 'Slide', 'staco-core'),
					'slide' 	  => esc_html__( 'Slide', 'staco-core'),
					'clip' 	  	  => esc_html__( 'Clip', 'staco-core'),
					'zoom' 	  	  => esc_html__( 'Zoom', 'staco-core'),
					'push' 	  	  => esc_html__( 'Push', 'staco-core'),
				],
			]
		);

		$this->add_control(
            'animate_title_color',
            [
                'label' => esc_html__( 'Title Color', 'staco-core' ),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .staco-animated-heading .title-inner .title .cd-headline p' => 'color: {{VALUE}}; -webkit-text-fill-color:unset;',
                    '{{WRAPPER}} .cd-headline.loading-bar .cd-words-wrapper::after' => 'background: {{VALUE}};',
					'{{WRAPPER}} .v7hero-section-text .banner-text h2' => 'background: {{VALUE}};',
                ],            
            ]
        );

		$this->add_group_control(
			Group_Control_Background::get_type(),
			[
				'name' => 'item_bg_color',
				'label' => esc_html__('Title Animation Color', 'scaddon'),
				'types' => ['classic', 'gradient'],
				'selector' => '{{WRAPPER}} .staco-animated-heading .title-inner .title .cd-headline p, {{WRAPPER}} .v7hero-section-text .banner-text h2.slick-current',
			]
		);

		$this->add_group_control(
			Group_Control_Typography::get_type(),
			[
				'name' => 'animate_title_typography',
				'label' => esc_html__( 'Title Typography', 'staco-core' ),
				'selector' => '{{WRAPPER}} .v7hero-section-text .banner-text h2, {{WRAPPER}} .staco-animated-heading .title-inner .title .cd-headline p',
			]
		);
		
		$this->add_control(
            'animate_last_title_color',
            [
                'label' => esc_html__( 'Title Last Word Color', 'staco-core' ),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .staco-animated-heading .title-inner .title .cd-headline .last ' => 'color: {{VALUE}};',
                ],                
            ]
        );

		$this->add_responsive_control(
		    'amination_margin',
		    [
		        'label' => esc_html__( 'Margin', 'staco-core' ),
		        'type' => Controls_Manager::DIMENSIONS,
		        'size_units' => [ 'px', 'em', '%' ],
		        'selectors' => [
		            '{{WRAPPER}} .v7hero-section-text .banner-text h2, {{WRAPPER}} .staco-animated-heading .title span' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
		        ],
		    ]
		);
            
		$this->end_controls_section();


		$this->start_controls_section(
			'section_heading_style_after',
			[
				'label' => esc_html__( 'After Title', 'staco-core' ),
				'tab' => Controls_Manager::TAB_STYLE,
			]
		);

		$this->add_control(
            'title_after_style',
            [
                'label' => esc_html__( 'Title Color', 'staco-core' ),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .staco-animated-heading .title-inner .title' => 'color: {{VALUE}};',
                ],                
            ]
        );

		$this->add_group_control(
			Group_Control_Typography::get_type(),
			[
				'name' => 'title_typography_after',
				'label' => esc_html__( 'Title Typography', 'staco-core' ),
				'selector' => '{{WRAPPER}} .staco-animated-heading .title-inner .title',
			]
		); 
		$this->end_controls_section();


		$this->start_controls_section(
			'section_heading_style_des',
			[
				'label' => esc_html__( 'Description Text', 'staco-core' ),
				'tab' => Controls_Manager::TAB_STYLE,
			]
		);
		$this->add_control(
            'des_after_style',
            [
                'label' => esc_html__( 'Description Color', 'staco-core' ),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .staco-animated-heading .description p' => 'color: {{VALUE}};',
                ],                
            ]
        );
		$this->add_group_control(
			Group_Control_Typography::get_type(),
			[
				'name' => 'des_typography_after',
				'label' => esc_html__( 'Title Typography', 'staco-core' ),
				'selector' => '{{WRAPPER}} .staco-animated-heading .description p',
			]
		); 
		$this->add_responsive_control(
		    'des_typography_margin',
		    [
		        'label' => esc_html__( 'Margin', 'staco-core' ),
		        'type' => Controls_Manager::DIMENSIONS,
		        'size_units' => [ 'px', 'em', '%' ],
		        'selectors' => [
		            '{{WRAPPER}} .staco-animated-heading .description p' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
		        ],
		    ]
		);
		$this->end_controls_section();
    }
	protected function render() {
		$data     = $this->get_settings();
		$template = 'view';
		if ( 'style2' == $data['layout'] ) {
			$template = 'view-2';
		}
		$this->rt_template( $template, $data );
	}

}