<?php
/**
 * @author  UiGigs
 * @since   1.0
 * @version 1.0
 */

namespace UiGigs\Staco_Core;

use Elementor\Controls_Manager;
use Elementor\Group_Control_Typography;

if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

class Banner1 extends Custom_Widget_Base {

	public function __construct( $data = [], $args = null ) {
		$this->rt_name = esc_html__( 'Banner 1', 'staco-core' );
		$this->rt_base = 'staco-banner1';
		parent::__construct( $data, $args );
	}

	protected function register_controls() {

		/* = Banner 1 Options
		============================================*/
		$this->start_controls_section(
			'banner1_section',
			[
				'label' => esc_html__( 'Banner 1', 'staco-core' ),
				'tab'   => Controls_Manager::TAB_CONTENT,
			]
		);
		$this->add_control(
			'title',
			[
				'label'       => esc_html__( 'Title', 'staco-core' ),
				'type'        => Controls_Manager::TEXTAREA,
				'label_block' => true,
				'default'     => 'Crazy Meta NFT Collections',
			]
		);
		$this->add_control(
			'mint_count',
			[
				'label'       => esc_html__( 'Mint Count', 'staco-core' ),
				'type'        => Controls_Manager::TEXT,
				'label_block' => true,
				'default'     => '5555',
			]
		);
		$this->add_control(
			'mint_count_text',
			[
				'label'       => esc_html__( 'Mint Count Text', 'staco-core' ),
				'type'        => Controls_Manager::TEXT,
				'label_block' => true,
				'default'     => '/ 5555 Minted',
			]
		);
		//Button 1
		$this->add_control(
			'btn1_txt',
			[
				'label'   => esc_html__( 'Button 1 Text', 'staco-core' ),
				'type'    => Controls_Manager::TEXT,
				'default' => 'Mint Now',
			]
		);
		$this->add_control(
			'btn1_link',
			[
				'label'   => esc_html__( 'Button 1 Link', 'staco-core' ),
				'type'    => Controls_Manager::TEXT,
				'default' => '#',
			]
		);
		//Button 2
		$this->add_control(
			'btn2_txt',
			[
				'label'   => esc_html__( 'Button 2 Text', 'staco-core' ),
				'type'    => Controls_Manager::TEXT,
				'default' => 'Wishlist Now',
			]
		);
		$this->add_control(
			'btn2_link',
			[
				'label'   => esc_html__( 'Button 2 Link', 'staco-core' ),
				'type'    => Controls_Manager::TEXT,
				'default' => '#',
			]
		);
		$this->end_controls_section();
		//List Repeater
		$this->start_controls_section(
			'banner_list_section',
			[
				'label' => __( 'Banner List', 'staco-core' ),
			]
		);
		$repeater = new \Elementor\Repeater();
		$repeater->add_control(
			'list_text', [
				'label'       => __( 'Title', 'staco-core' ),
				'type'        => \Elementor\Controls_Manager::TEXTAREA,
				'default'     => 'List Text Goes Here',
				'label_block' => true,
			]
		);
		$this->add_control(
			'banner_list',
			[
				'label'       => __( 'List Items', 'staco-core' ),
				'type'        => \Elementor\Controls_Manager::REPEATER,
				'fields'      => $repeater->get_controls(),
				'default'     => [
					[
						'list_text'    => 'Max 2 NFTs per wallet . Price 0.09 ETH + gas',
					],
					[
						'list_text'    => 'MINT IS LIVE <span>UNTIL 25 APR 04:00H</span>',
					],
					[
						'list_text'    => 'Presale : SOLDOUT',
					],
				],
				'title_field' => '{{{ list_text }}}',
			]
		);
		$this->end_controls_section();

		/* = Title Settings
		==============================================================*/
		$this->start_controls_section(
			'title_settings',
			[
				'label' => esc_html__( 'Title Settings', 'staco-core' ),
				'tab'   => Controls_Manager::TAB_STYLE,
			]
		);
		$this->add_control(
			'title_color',
			[
				'type'      => Controls_Manager::COLOR,
				'label'     => esc_html__( 'Color', 'staco-core' ),
				'selectors' => [
					'{{WRAPPER}} .banner_section_v1 h2' => 'color: {{VALUE}}',
				],
			]
		);
		$this->add_group_control(
			Group_Control_Typography::get_type(),
			[
				'name'     => 'title_typo',
				'label'    => esc_html__( 'Typography', 'staco-core' ),
				'selector' => '{{WRAPPER}} .banner_section_v1 h2',
			]
		);
		$this->end_controls_section();

		/* = Mint Settings
		==============================================================*/
		$this->start_controls_section(
			'mint_settings',
			[
				'label' => esc_html__( 'Mint Count Settings', 'staco-core' ),
				'tab'   => Controls_Manager::TAB_STYLE,
			]
		);
		$this->add_control(
			'mint_color',
			[
				'type'      => Controls_Manager::COLOR,
				'label'     => esc_html__( 'Color', 'staco-core' ),
				'selectors' => [
					'{{WRAPPER}} .banner_section_v1 h3' => 'color: {{VALUE}}',
				],
			]
		);
		$this->add_group_control(
			Group_Control_Typography::get_type(),
			[
				'name'     => 'mint_typo',
				'label'    => esc_html__( 'Typography', 'staco-core' ),
				'selector' => '{{WRAPPER}} .banner_section_v1 h3',
			]
		);
		$this->end_controls_section();

		/* = Button Settings
		==============================================================*/
		$this->start_controls_section(
			'button_settings',
			[
				'label' => esc_html__( 'Button Settings', 'staco-core' ),
				'tab'   => Controls_Manager::TAB_STYLE,
			]
		);
		$this->add_control(
			'btn1_color',
			[
				'type'      => Controls_Manager::COLOR,
				'label'     => esc_html__( 'Button 1 Color', 'homlisti-core' ),
				'selectors' => [
					'{{WRAPPER}} .site_btn' => 'color: {{VALUE}}',
				],
			]
		);
		$this->add_control(
			'btn2_color',
			[
				'type'      => Controls_Manager::COLOR,
				'label'     => esc_html__( 'Button 2 Color', 'homlisti-core' ),
				'selectors' => [
					'{{WRAPPER}} .site_btn.btn-style-3' => 'color: {{VALUE}}',
				],
			]
		);
		$this->end_controls_section();

		/* = List Settings
		==============================================================*/
		$this->start_controls_section(
			'list_settings',
			[
				'label' => esc_html__( 'List Settings', 'staco-core' ),
				'tab'   => Controls_Manager::TAB_STYLE,
			]
		);
		$this->add_control(
			'list_color',
			[
				'type'      => Controls_Manager::COLOR,
				'label'     => esc_html__( 'Color', 'staco-core' ),
				'selectors' => [
					'{{WRAPPER}} .banner_section_v1 ul li' => 'color: {{VALUE}}',
				],
			]
		);
		$this->add_control(
			'list_color2',
			[
				'type'      => Controls_Manager::COLOR,
				'label'     => esc_html__( 'Color 2', 'staco-core' ),
				'selectors' => [
					'{{WRAPPER}} .banner_section_v1 ul li span' => 'color: {{VALUE}}',
				],
			]
		);
		$this->add_group_control(
			Group_Control_Typography::get_type(),
			[
				'name'     => 'list_typo',
				'label'    => esc_html__( 'Typography', 'staco-core' ),
				'selector' => '{{WRAPPER}} .banner_section_v1 ul li',
			]
		);
		$this->end_controls_section();
    }

	protected function render() {
		$data     = $this->get_settings();
		$template = 'view';
		$this->rt_template( $template, $data );
	}

}