<?php
/**
 * @author  UiGigs
 * @since   1.0
 * @version 1.0
 * top_sub_title
 * title
 * subtitle
 * bg_title
 * top_title_icon
 *
 */
namespace UiGigs\Staco_Core;
use UiGigs\staco\Helper; 
?>
<div class="banner_section_v1">
    <?php if ( $data['title'] ){ ?>
        <h2><?php echo wp_kses_post( $data['title'] ); ?></h2>
    <?php } if ( $data['mint_count'] || $data['mint_count_text'] ){ ?>
        <h3>
            <span class="count"><?php echo wp_kses_post( $data['mint_count'] ); ?></span>
            <?php echo wp_kses_post( $data['mint_count_text'] ); ?>
        </h3>
    <?php } ?>
    <div class="staco_v1_baner_buttons">
        <div class="join_comunity_btns list-btn">
            <?php if ($data['btn1_link']) { ?>
            <a href="<?php echo esc_url( $data['btn1_link'] ); ?>" target="_blank" class="site_btn colorPrimaryBg">
                <?php echo esc_html( $data['btn1_txt'] ); ?>
                <span class="hover_overlay"></span>
            </a>
            <?php } if ( $data['btn2_link'] ) { ?>
            <a href="<?php echo esc_url( $data['btn2_link'] ); ?>" class="site_btn  btn-style-3">
                <?php echo esc_html( $data['btn2_txt'] ); ?>
                <span class="hover_overlay"></span>
            </a>
            <?php } ?>
        </div>
    </div>
    <?php if ($data['banner_list']) : ?>
    <ul>
        <?php foreach ($data['banner_list'] as $list): ?>
            <li><?php echo wp_kses_post($list['list_text']) ?></li>
        <?php endforeach; ?>
    </ul>
    <?php endif; ?>
</div>