<?php
/**
 * @author  UiGigs
 * @since   1.0
 * @version 1.0
 */

namespace UiGigs\Staco_Core;

use Elementor\Utils;
use Elementor\Controls_Manager;
use Elementor\Group_Control_Typography;
use Elementor\Group_Control_Background;

if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

class Banner2 extends Custom_Widget_Base {

	public function __construct( $data = [], $args = null ) {
		$this->rt_name = esc_html__( 'Banner 2', 'staco-core' );
		$this->rt_base = 'staco-banner2';
		parent::__construct( $data, $args );
	}

	private function rt_load_scripts(){
		wp_enqueue_script( 'jquery-countdown' );			
	}

	protected function register_controls() {

		/* = Banner 2 Options
		============================================*/
		$this->start_controls_section(
			'banner2_section',
			[
				'label' => esc_html__( 'Banner 2', 'staco-core' ),
				'tab'   => Controls_Manager::TAB_CONTENT,
			]
		);
		$this->add_control(
			'icon',
			[
				'label'       => esc_html__( 'Icon', 'staco-core' ),
				'type'        => Controls_Manager::TEXT,
				'label_block' => true,
				'default'     => '',
			]
		);
		$this->add_control(
			'title',
			[
				'label'       => esc_html__( 'Title', 'staco-core' ),
				'type'        => Controls_Manager::TEXT,
				'label_block' => true,
				'default'     => 'PUBLIC SALE',
			]
		);
		$this->add_control(
			'title_color_txt',
			[
				'label'       => esc_html__( 'Title Color Text', 'staco-core' ),
				'type'        => Controls_Manager::TEXT,
				'label_block' => true,
				'default'     => 'Live !',
			]
		);
		$this->add_control(
			'mint_count',
			[
				'label'       => esc_html__( 'Mint Count', 'staco-core' ),
				'type'        => Controls_Manager::TEXT,
				'label_block' => true,
				'default'     => '9999',
			]
		);
		$this->add_control(
			'mint_count_text',
			[
				'label'       => esc_html__( 'Mint Count Text', 'staco-core' ),
				'type'        => Controls_Manager::TEXT,
				'label_block' => true,
				'default'     => '/ 9999 Minted',
			]
		);
		$this->add_control(
			'countdown_text',
			[
				'label'       => esc_html__( 'Countdown Text', 'staco-core' ),
				'type'        => Controls_Manager::TEXT,
				'label_block' => true,
				'default'     => 'TIME LEFT',
			]
		);
		$this->add_control(
			'countdown_time',
			[
				'label' => esc_html__( 'Countdown Time', 'staco-core' ),
				'type' => Controls_Manager::DATE_TIME,
			]
		);
		//Button 1
		$this->add_control(
			'btn1_txt',
			[
				'label'   => esc_html__( 'Button 1 Text', 'staco-core' ),
				'type'    => Controls_Manager::TEXT,
				'default' => 'Mint Now',
			]
		);
		$this->add_control(
			'btn1_link',
			[
				'label'   => esc_html__( 'Button 1 Link', 'staco-core' ),
				'type'    => Controls_Manager::TEXT,
				'default' => '#',
			]
		);
		$this->end_controls_section();

		$this->start_controls_section(
			'banner_img_list_section',
			[
				'label' => __( 'Animation Image List', 'staco-core' ),
			]
		);
		$repeater = new \Elementor\Repeater();
		$repeater->add_control(
			'anim_img', [
				'label'       => __( 'Image', 'staco-core' ),
				'type'        => \Elementor\Controls_Manager::MEDIA,
				'label_block' => true,
			]
		);
		$this->add_control(
			'anim_img_list',
			[
				'label'       => __( 'List Items', 'staco-core' ),
				'type'        => \Elementor\Controls_Manager::REPEATER,
				'fields'      => $repeater->get_controls(),
			]
		);
		$this->end_controls_section();

		/* = Title Settings
		==============================================================*/
		$this->start_controls_section(
			'title_settings',
			[
				'label' => esc_html__( 'Title Settings', 'staco-core' ),
				'tab'   => Controls_Manager::TAB_STYLE,
			]
		);
		$this->add_control(
			'title_color',
			[
				'type'      => Controls_Manager::COLOR,
				'label'     => esc_html__( 'Color', 'staco-core' ),
				'selectors' => [
					'{{WRAPPER}} .banner_section_v2 h2' => 'color: {{VALUE}}',
				],
			]
		);
		$this->add_control(
			'title_color_color',
			[
				'type'      => Controls_Manager::COLOR,
				'label'     => esc_html__( 'Color Text Color', 'staco-core' ),
				'selectors' => [
					'{{WRAPPER}} .banner_section_v2 h2 span' => 'color: {{VALUE}}',
				],
			]
		);
		$this->add_group_control(
			Group_Control_Typography::get_type(),
			[
				'name'     => 'title_typo',
				'label'    => esc_html__( 'Typography', 'staco-core' ),
				'selector' => '{{WRAPPER}} .banner_section_v2 h2',
			]
		);
		$this->end_controls_section();

		/* = Mint Settings
		==============================================================*/
		$this->start_controls_section(
			'mint_settings',
			[
				'label' => esc_html__( 'Mint Count Settings', 'staco-core' ),
				'tab'   => Controls_Manager::TAB_STYLE,
			]
		);
		$this->add_control(
			'mint_color',
			[
				'type'      => Controls_Manager::COLOR,
				'label'     => esc_html__( 'Color', 'staco-core' ),
				'selectors' => [
					'{{WRAPPER}} .banner_section_v2 h3' => 'color: {{VALUE}}',
				],
			]
		);
		$this->add_group_control(
			Group_Control_Typography::get_type(),
			[
				'name'     => 'mint_typo',
				'label'    => esc_html__( 'Typography', 'staco-core' ),
				'selector' => '{{WRAPPER}} .banner_section_v2 h3',
			]
		);
		$this->end_controls_section();
		/* = Count Settings
		==============================================================*/
		$this->start_controls_section(
			'count_settings',
			[
				'label' => esc_html__( 'Count Settings', 'staco-core' ),
				'tab'   => Controls_Manager::TAB_STYLE,
			]
		);
		$this->add_control(
			'count_color',
			[
				'type'      => Controls_Manager::COLOR,
				'label'     => esc_html__( 'Color', 'staco-core' ),
				'selectors' => [
					'{{WRAPPER}} .countdown-section h3' => 'color: {{VALUE}}',
					'{{WRAPPER}} .banner_section_v2_contdown h4' => 'color: {{VALUE}}',
				],
			]
		);
		$this->add_group_control(
			Group_Control_Typography::get_type(),
			[
				'name'     => 'count_typo',
				'label'    => esc_html__( 'Typography', 'staco-core' ),
				'selector' => '{{WRAPPER}} .banner_section_v2_contdown h4, {{WRAPPER}} .countdown-section h3',
			]
		);
		$this->end_controls_section();

		/* = Button Settings
		==============================================================*/
		$this->start_controls_section(
			'button_settings',
			[
				'label' => esc_html__( 'Button Settings', 'staco-core' ),
				'tab'   => Controls_Manager::TAB_STYLE,
			]
		);
		$this->add_control(
			'btn_color',
			[
				'type'      => Controls_Manager::COLOR,
				'label'     => esc_html__( 'Button Color', 'homlisti-core' ),
				'selectors' => [
					'{{WRAPPER}} .site_btn' => 'color: {{VALUE}}',
				],
			]
		);
		$this->add_group_control(
			Group_Control_Background::get_type(),
			[
				'name' => 'btn_background',
				'label' => esc_html__( 'Background', 'staco-core' ),
				'selector' => '{{WRAPPER}} .site_btn.colorPrimaryBg',
			]
		);
		$this->end_controls_section();
    }

	protected function render() {
		$data     = $this->get_settings();
		$this->rt_load_scripts();
		$template = 'view';
		$this->rt_template( $template, $data );
	}

}