<?php
/**
 * @author  UiGigs
 * @since   1.0
 * @version 1.0
 * top_sub_title
 * title
 * subtitle
 * bg_title
 * top_title_icon
 *
 */
namespace UiGigs\Staco_Core;
use UiGigs\staco\Helper; 
extract( $data );
$date = '';
if(!empty($data['countdown_time'])){
    $countdown_time  = strtotime( $data['countdown_time'] );
    $date  = date('Y/m/d H:i:s', $countdown_time);
}

$attr = '';
if ( !empty( $data['btnurl']['url'] ) ) {
    $attr  = 'href="' . $data['btnurl']['url'] . '"';
    $attr .= !empty( $data['btnurl']['is_external'] ) ? ' target="_blank"' : '';
    $attr .= !empty( $data['btnurl']['nofollow'] ) ? ' rel="nofollow"' : '';
}

?>
<div class="banner_section_v3">
    <?php if ( $data['subtitle'] || $data['subtitle_part2'] ){ ?>
        <h4>
            <?php echo wp_kses_post( $data['subtitle'] ); ?>
            <span><?php echo wp_kses_post( $data['subtitle_part2'] ); ?></span>
        </h4>
    <?php } if ( $data['title'] ){ ?>
        <h2>
            <?php echo wp_kses_post( $data['title'] ); ?>
        </h2>
    <?php } ?>

    <div class="banner_section_v3_contdown">
        <h5><?php echo wp_kses_post( $data['countdown_text'] ); ?></h5>
        <div class="countdown-wrapper">
            <div data-countdown="<?php echo esc_attr( $date ); ?>" class="staco-countdown"></div>
        </div>
    </div>

    <div class="banner-count-inner d-flex align-items-center">
        <div class="banner-btn-area">
            <span class="input-number-decrement">–</span>
            <input class="input-number" type="text" value="1">
            <span class="input-number-increment">+</span>
        </div>
        <div class="staco_v3_banner_buttons">
            <div class="join_comunity_btns">
                <a <?php echo wp_kses_post( $attr ); ?> target="_blank" class="site_btn colorPrimaryBg">
                    <?php echo esc_html( $data['btntext'] ); ?>
                    <span class="hover_overlay"></span>
                </a>
            </div>
        </div>
    </div>
    
    <?php if ($data['banner_list']) : ?>
    <ul>
        <?php foreach ($data['banner_list'] as $list): ?>
            <li><?php echo wp_kses_post($list['list_text']) ?></li>
        <?php endforeach; ?>
    </ul>
    <?php endif; ?>
</div>