<?php
/**
 * @author  UiGigs
 * @since   1.0
 * @version 1.0
 * title_part1
 * title_part2
 * anim1_img
 * anim2_img
 * banner_list
 *
 */
namespace UiGigs\Staco_Core;
use UiGigs\staco\Helper; 

?>
<div class="banner_section_v1 banner_section_v4">
    <canvas id="canvas" class="v4firefly_bg"></canvas>
    <?php if ( $data['title_part1'] || $data['title_part2'] ){ ?>
        <h2><?php echo wp_kses_post( $data['title_part1'] ); ?> 
            <span>
                <?php echo wp_get_attachment_image( $data['anim1_img']['id'], 'full', '', ["class" => 'cat_foot_print'] ); ?>
                <?php echo wp_get_attachment_image( $data['anim2_img']['id'], 'full', '', ["class" => 'cat_walk_round_shape rotated-style'] ); ?>
            </span> 
            <br>
            <?php echo wp_kses_post( $data['title_part2'] ); ?>
        </h2>

    <?php } ?>
    <?php if ($data['banner_list']) : ?>
    <ul>
        <?php foreach ($data['banner_list'] as $list): ?>
            <li><?php echo wp_kses_post($list['list_text']) ?></li>
        <?php endforeach; ?>
    </ul>
    <?php endif; ?>
    <div class="staco_v4_banner_buttons">
        <div class="join_comunity_btns list-btn">
            <?php if ($data['btn1_link']) { ?>
            <a href="<?php echo esc_url( $data['btn1_link'] ); ?>" target="_blank"  class="site_btn colorPrimaryBg">
                <?php echo esc_html( $data['btn1_txt'] ); ?>
                <span class="hover_overlay"></span>
            </a>
            <?php } if ( $data['btn2_link'] ) { ?>
            <a href="<?php echo esc_url( $data['btn2_link'] ); ?>" class="site_btn btn-style-3">
                <?php echo esc_html( $data['btn2_txt'] ); ?>
                <span class="hover_overlay"></span>
            </a>
            <?php } ?>
        </div>
    </div>
</div>