<?php
/**
 * @author  UiGigs
 * @since   1.0
 * @version 1.0
 */

namespace UiGigs\Staco_Core;

use Elementor\Controls_Manager;
use Elementor\Group_Control_Typography;
use Elementor\Group_Control_Border;
use Elementor\Group_Control_Background;

if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

class Button extends Custom_Widget_Base {

	public function __construct( $data = [], $args = null ) {
		$this->rt_name = __( 'Button', 'staco-core' );
		$this->rt_base = 'staco-btn';
		parent::__construct( $data, $args );
	}

	protected function register_controls() {
		$this->start_controls_section(
			'sec_general',
			[
				'label' => esc_html__( 'General', 'staco-core' ),
				'tab'   => Controls_Manager::TAB_CONTENT,
			]
		);

		$this->add_control(
			'layout',
			[
				'label' => __('Style', 'staco-core'),
				'type' => Controls_Manager::SELECT,
				'default' => 'style1',
				'options' => [
					'style1' => __( 'Style 1', 'staco-core' ),
					'style2' => __( 'Style 2', 'staco-core' ),
					'style3' => __( 'Style 3', 'staco-core' ),
					'style4' => __( 'Style 4', 'staco-core' ),
				],
				'label_block' => true,
			]
		);

		$this->add_control(
			'btntext',
			[
				'type'    => Controls_Manager::TEXT,
				'label'   => esc_html__( 'Button Text', 'staco-core' ),
				'default' => 'LOREM IPSUM',
			]
		);

		$this->add_control(
			'btnurl',
			[
				'type'        => Controls_Manager::URL,
				'label'       => esc_html__( 'Button URL', 'staco-core' ),
				'placeholder' => 'https://your-link.com',
			]
		);

		$this->add_control(
			'icon_select',
			[
				'label' => __('Choose Icon Type', 'staco-core'),
				'type' => Controls_Manager::SELECT,
				'default' => 'style1',
				'options' => [
					'style1' => __( 'SVG Icon', 'staco-core' ),
					'style2' => __( 'Image Icon', 'staco-core' ),
				],
				'label_block' => true,
				
			]
		);
		
		$this->add_control(
			'btn_icon',
			[
				'label'            => __( 'Choose Svg Icon', 'staco-core' ),
				'type'             => Controls_Manager::ICONS,
				'default'          => [
					'value'   => 'fas fa-home',
					'library' => 'fa-solid',
				],
				'condition' => [
					'icon_select' => ['style1']
				],
			]
		);
		$this->add_control(
			'icon_img1',
			[
				'label'   => __( 'Choose Image Icon', 'staco-core' ),
				'type'    => \Elementor\Controls_Manager::MEDIA,
				'default' => [
					'url' => \Elementor\Utils::get_placeholder_image_src(),
				],
				'condition' => [
					'icon_select' => ['style2']
				],
			]
		);

		$this->add_responsive_control(
			'align',
			[
				'label' => esc_html__('Alignment', 'scaddon'),
				'type' => Controls_Manager::CHOOSE,
				'options' => [
					'left' => [
						'title' => esc_html__('Left', 'scaddon'),
						'icon' => 'fa fa-align-left',
					],
					'center' => [
						'title' => esc_html__('Center', 'scaddon'),
						'icon' => 'fa fa-align-center',
					],
					'right' => [
						'title' => esc_html__('Right', 'scaddon'),
						'icon' => 'fa fa-align-right',
					],
					'justify' => [
						'title' => esc_html__('Justify', 'scaddon'),
						'icon' => 'fa fa-align-justify',
					],
				],
				'toggle' => true,
				'selectors' => [
					'{{WRAPPER}} .defi-banner-btn, {{WRAPPER}} .hero-content-button, {{WRAPPER}} .bg-blue-btn, {{WRAPPER}} .ug-button-area' => 'text-align: {{VALUE}}'
				],
				'separator' => 'before',
			]
		);

		$this->add_control(
			'button_width',
			[
				'label'   => esc_html__( 'Button Width', 'staco-core' ),
				'type'    => Controls_Manager::SELECT,
				'default' => 'normal_width',
				'options' => [
					'normal_width'    => esc_html__( 'Normal', 'staco-core'),
					'full_width' => esc_html__( 'Full Width', 'staco-core'),
				],
			]
		);

		$this->end_controls_section();

		/* = Style
		====================================*/
		$this->start_controls_section(
			'section_box',
			[
				'label' => __( 'Style', 'post-grid-elementor-addon' ),
				'tab'   => Controls_Manager::TAB_STYLE,
			]
		);

		$this->add_control(
			'box_border_radius',
			[
				'label'     => __( 'Border Radius', 'staco-core' ),
				'type'      => Controls_Manager::SLIDER,
				'default'   => [
					'size' => 0,
				],
				'range'     => [
					'px' => [
						'min' => 0,
						'max' => 200,
					],
				],
				'selectors' => [
					'{{WRAPPER}} .defi-explore-article-btn, {{WRAPPER}} .defi-banner-btn, {{WRAPPER}} .bg-blue-btn' => 'border-radius: {{SIZE}}{{UNIT}}',
				],
			]
		);

		$this->add_group_control(
			Group_Control_Typography::get_type(),
			[
				'name'     => 'btn_typo',
				'label'    => esc_html__( 'Typography', 'staco-core' ),
				'selector' => '{{WRAPPER}} .defi-explore-article-btn, {{WRAPPER}} .defi-banner-btn, {{WRAPPER}} .bg-blue-btn',
			]
		);

		$this->add_control(
			'btn_bg_type',
			[
				'label' => __('Style', 'staco-core'),
				'type' => Controls_Manager::SELECT,
				'default' => 'style1',
				'options' => [
					'style1' => __( 'Normal Color', 'staco-core' ),
					'style2' => __( 'Gradient Color', 'staco-core' ),
				],
				'label_block' => true,
			]
		);

		$this->start_controls_tabs( 'cat_box_style' );

		// Normal tab.
		$this->start_controls_tab(
			'box_style_normal',
			[
				'label' => __( 'Normal', 'staco-core' ),
			]
		);

		

		// Normal background color.
		$this->add_control(
			'box_style_normal_bg_color',
			[
				'type'      => Controls_Manager::COLOR,
				'label'     => __( 'Background Color', 'staco-core' ),
				'separator' => '',
				'selectors' => [
					'{{WRAPPER}} .defi-explore-article-btn, {{WRAPPER}} .defi-banner-btn, {{WRAPPER}} .bg-blue-btn' => 'background-color: {{VALUE}};',
				],
				'condition' => [
					'btn_bg_type' => ['style1', 'style4', 'style3']
				],
			]
		);

		$this->add_group_control(
			Group_Control_Background::get_type(),
			[
				'name' => 'btn_gradient',
				'label' => esc_html__( 'Background', 'staco-core' ),
				'types' => [ 'classic', 'gradient', 'video' ],
				'selector' => '{{WRAPPER}} .bg-blue-btn',
				'condition' => [
					'btn_bg_type' => 'style2'
				],
			]
		);

		// Normal Text color.
		$this->add_control(
			'box_style_normal_text_color',
			[
				'type'      => Controls_Manager::COLOR,
				'label'     => __( 'Text Color', 'staco-core' ),
				'separator' => '',
				'selectors' => [
					'{{WRAPPER}} .defi-explore-article-btn, {{WRAPPER}} .defi-banner-btn, {{WRAPPER}} .bg-blue-btn span, {{WRAPPER}} .bg-blue-btn' => 'color: {{VALUE}};',
				],
			]
		);

		$this->add_group_control(
            Group_Control_Border::get_type(),
            [
                'name' => 'btn_border',
                'selector' => '{{WRAPPER}} .defi-explore-article-btn, {{WRAPPER}} .defi-banner-btn, {{WRAPPER}} .bg-blue-btn',
            ]
        );

		$this->end_controls_tab();

		// Hover tab.
		$this->start_controls_tab(
			'box_style_hover',
			[
				'label' => __( 'Hover', 'staco-core' ),
			]
		);

		// Hover background color.
		$this->add_control(
			'box_style_hover_bg_color',
			[
				'type'      => Controls_Manager::COLOR,
				'label'     => __( 'Background Color', 'staco-core' ),
				'separator' => '',
				'selectors' => [
					'{{WRAPPER}} .defi-explore-article-btn:hover, {{WRAPPER}} .defi-banner-btn, {{WRAPPER}} .bg-blue-btn:hover, {{WRAPPER}} .bg-blue-btn::before' => 'background-color: {{VALUE}};',
				],
				'condition' => [
					'btn_bg_type' => ['style1', 'style4', 'style3']
				],
			]
		);

		$this->add_group_control(
			Group_Control_Background::get_type(),
			[
				'name' => 'btn_gradient_hover',
				'label' => esc_html__( 'Background', 'staco-core' ),
				'types' => [ 'classic', 'gradient', 'video' ],
				'selector' => '{{WRAPPER}} .bg-blue-btn:hover',
				'condition' => [
					'btn_bg_type' => 'style2'
				],
			]
		);

		// Normal Text color.
		$this->add_control(
			'box_style_hover_text_color',
			[
				'type'      => Controls_Manager::COLOR,
				'label'     => __( 'Text Color', 'staco-core' ),
				'separator' => '',
				'selectors' => [
					'{{WRAPPER}} .defi-explore-article-btn, {{WRAPPER}} .defi-banner-btn, {{WRAPPER}} .bg-blue-btn:hover span, {{WRAPPER}} .bg-blue-btn:hover' => 'color: {{VALUE}};',
				],
			]
		);

		$this->add_control(
			'box_style_hover_bg_color_verly',
			[
				'type'      => Controls_Manager::COLOR,
				'label'     => __( 'Overlay', 'staco-core' ),
				'separator' => '',
				'selectors' => [
					'{{WRAPPER}} .defi-explore-article-btn, {{WRAPPER}} .bg-blue-btn' => 'background-color: {{VALUE}};',
				],
			]
		);
		
		$this->end_controls_tab();
		$this->end_controls_tabs();
		$this->end_controls_section();
		$this->start_controls_section(
			'sec_spacing',
			[
				'label' => esc_html__( 'Spacing', 'staco-core' ),
				'tab'   => Controls_Manager::TAB_STYLE,
			]
		);

		$this->add_responsive_control(
			'btn_padding',
			[
				'label'      => __( 'Padding', 'staco-core' ),
				'type'       => Controls_Manager::DIMENSIONS,
				'size_units' => [ 'px', '%' ],
				'selectors'  => [
					'{{WRAPPER}} .defi-explore-article-btn, {{WRAPPER}} .defi-banner-btn, {{WRAPPER}} .bg-blue-btn' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}}',
				],
			]
		);

		$this->add_responsive_control(
			'btn_margin',
			[
				'label'      => __( 'Margin', 'staco-core' ),
				'type'       => Controls_Manager::DIMENSIONS,
				'size_units' => [ 'px', '%' ],
				'selectors'  => [
					'{{WRAPPER}} .defi-explore-article-btn, {{WRAPPER}} .defi-banner-btn, {{WRAPPER}} .bg-blue-btn' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}}',
				],
			]
		);
		$this->end_controls_section();

		$this->start_controls_section(
			'icon_style',
			[
				'label' => esc_html__( 'Icon', 'staco-core' ),
				'tab'   => Controls_Manager::TAB_STYLE,
			]
		);

		$this->add_responsive_control(
			'icon_leftright_postion',
			[
				'label' => esc_html__('Content Position left/Right', 'scaddons'),
				'type' => Controls_Manager::SLIDER,
				'size_units' => ['px'],
				'range' => [
					'px' => [
						'min' => -500,
						'max' => 500,
					],
				],
				'selectors' => [
					'{{WRAPPER}} .bg-blue-btn img, {{WRAPPER}} .defi-explore-article-btn i, {{WRAPPER}} .bg-blue-btn i, {{WRAPPER}} .bg-blue-btn svg' => 'left: {{SIZE}}px;',
				],
			]
		);
		$this->add_responsive_control(
			'icon_topbottom_postion',
			[
				'label' => esc_html__('Content Position top/bottom', 'scaddons'),
				'type' => Controls_Manager::SLIDER,
				'size_units' => ['px'],
				'range' => [
					'px' => [
						'min' => -500,
						'max' => 500,
					],
				],
				'selectors' => [
					'{{WRAPPER}} .bg-blue-btn img, {{WRAPPER}} .defi-explore-article-btn i, {{WRAPPER}} .bg-blue-btn i, {{WRAPPER}} .bg-blue-btn svg' => 'top: {{SIZE}}px;',
				],
			]
		);
		
		$this->add_responsive_control(
			'icon_leftright_postion_hover',
			[
				'label' => esc_html__('Content Hover Position left/Right', 'scaddons'),
				'type' => Controls_Manager::SLIDER,
				'size_units' => ['px'],
				'range' => [
					'px' => [
						'min' => -500,
						'max' => 500,
					],
				],
				'selectors' => [
					'{{WRAPPER}} .bg-blue-btn img, {{WRAPPER}} .defi-explore-article-btn:hover i, {{WRAPPER}} .bg-blue-btn:hover i, {{WRAPPER}} .bg-blue-btn:hover i, {{WRAPPER}} .bg-blue-btn:hover svg' => 'left: {{SIZE}}px;',
				],
			]
		);
		$this->add_responsive_control(
			'icon_size',
			[
				'label' => esc_html__('Width', 'scaddon'),
				'type' => Controls_Manager::SLIDER,
				'size_units' => ['px'],
				'range' => [
					'px' => [
						'min' => 10,
						'max' => 300,
					],
				],
				'selectors' => [
					'{{WRAPPER}} .defi-explore-article-btn svg, {{WRAPPER}} .bg-blue-btn svg' => 'width: {{SIZE}}{{UNIT}} !important;',
				],
			]
		);
		$this->add_responsive_control(
			'icon_height',
			[
				'label' => esc_html__('Height', 'scaddon'),
				'type' => Controls_Manager::SLIDER,
				'size_units' => ['px'],
				'range' => [
					'px' => [
						'min' => 10,
						'max' => 300,
					],
				],
				'selectors' => [
					'{{WRAPPER}} .defi-explore-article-btn svg, {{WRAPPER}} .bg-blue-btn svg' => 'height: {{SIZE}}{{UNIT}} !important;',
				],
			]
		);
		$this->add_responsive_control(
			'btn_icon_padding',
			[
				'label'      => __( 'Padding', 'staco-core' ),
				'type'       => Controls_Manager::DIMENSIONS,
				'size_units' => [ 'px', '%' ],
				'selectors'  => [
					'{{WRAPPER}} .defi-explore-article-btn svg, {{WRAPPER}} .bg-blue-btn svg' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}}',
				],
			]
		);
		$this->add_control(
			'box_border_svg_radius',
			[
				'label'     => __( 'Border Radius', 'staco-core' ),
				'type'      => Controls_Manager::SLIDER,
				'default'   => [
					'size' => 0,
				],
				'range'     => [
					'px' => [
						'min' => 0,
						'max' => 200,
					],
				],
				'selectors' => [
					'{{WRAPPER}} .defi-explore-article-btn svg, {{WRAPPER}} .bg-blue-btn svg' => 'border-radius: {{SIZE}}{{UNIT}}',
				],
			]
		);
		$this->start_controls_tabs( 'btn_box_style' );
		// Normal tab.
		$this->start_controls_tab(
			'box_btn_normal',
			[
				'label' => __( 'Normal', 'staco-core' ),
			]
		);

		$this->add_control(
			'button_normal_color',
			[
				'type'      => Controls_Manager::COLOR,
				'label'     => __( 'Icon Color', 'staco-core' ),
				'separator' => '',
				'selectors' => [
					'{{WRAPPER}} .defi-explore-article-btn i, {{WRAPPER}} .bg-blue-btn i, {{WRAPPER}} .bg-blue-btn svg path' => 'fill: {{VALUE}};',
					'{{WRAPPER}} .defi-banner-btn-shape .shape3, {{WRAPPER}} .defi-banner-btn-shape .shape1, {{WRAPPER}} .defi-banner-btn-shape .shape2' => 'background: {{VALUE}};',
				],
			]
		);
		$this->add_control(
			'button_background',
			[
				'type'      => Controls_Manager::COLOR,
				'label'     => __( 'Icon Background Color', 'staco-core' ),
				'separator' => '',
				'selectors' => [
					'{{WRAPPER}} .defi-explore-article-btn svg, {{WRAPPER}} .bg-blue-btn svg' => 'background: {{VALUE}};',
				],
			]
		);
		$this->add_control(
			'Icon_opacity',
			[
				'label' => esc_html__( 'Opacity', 'elementor' ),
				'type' => Controls_Manager::SLIDER,
				'range' => [
					'px' => [
						'max' => 1,
						'min' => 0.10,
						'step' => 0.01,
					],
				],
				'selectors' => [
					'{{WRAPPER}} img' => 'filter: brightness({{SIZE}});',
				],
			]
		);
		$this->end_controls_tab();

		// Hover tab.
		$this->start_controls_tab(
			'box_btn_hover',
			[
				'label' => __( 'Hover', 'staco-core' ),
			]
		);

		// Hover background color.
		$this->add_control(
			'button_normal_hover_color',
			[
				'type'      => Controls_Manager::COLOR,
				'label'     => __( 'Icon Color', 'staco-core' ),
				'separator' => '',
				'selectors' => [
					'{{WRAPPER}} .bg-blue-btn:hover i, {{WRAPPER}} .bg-blue-btn:hover svg' => 'background: {{VALUE}};',
					'{{WRAPPER}} .defi-banner-btn-shape:hover .shape3, {{WRAPPER}} .defi-banner-btn-shape:hover .shape1, {{WRAPPER}} .defi-banner-btn-shape:hover .shape2' => 'background: {{VALUE}};',
				],
			]
		);
		$this->add_control(
			'button_hover_background',
			[
				'type'      => Controls_Manager::COLOR,
				'label'     => __( 'Icon Background Color', 'staco-core' ),
				'separator' => '',
				'selectors' => [
					'{{WRAPPER}} img' => 'brightness({{SIZE}});',
					'{{WRAPPER}} .defi-explore-article-btn:hover i, {{WRAPPER}} .bg-blue-btn:hover i, {{WRAPPER}} .bg-blue-btn:hover svg' => 'background: {{VALUE}};',
				],
			]
		);
		$this->add_control(
			'opacity_hover',
				[
					'label' => esc_html__( 'Icon Color Light/Dark', 'elementor' ),
					'type' => Controls_Manager::SLIDER,
					'range' => [
						'px' => [
							'max' => 1,
							'min' => 0.10,
							'step' => 0.01,
						],
					],
					'selectors' => [
						'{{WRAPPER}} .bg-blue-btn:hover img' => 'filter: brightness({{SIZE}});',
						'{{WRAPPER}} .defi-explore-article-btn svg path, {{WRAPPER}} .bg-blue-btn:hover svg path' => '-webkit-fill: brightness({{SIZE}}) invert({{SIZE}});;',
						'{{WRAPPER}} .bg-blue-btn:hover svg path' => 'fill: brightness({{SIZE}}) invert({{SIZE}});;',
					],
				]
			);
		$this->end_controls_tab();
		$this->end_controls_tabs();
		$this->end_controls_section();
	}
	protected function render() {
		$data     = $this->get_settings();
		$template = 'view';
		if ( 'style2' == $data['layout'] ) {
			$template = 'view-2';
		}
		if ( 'style3' == $data['layout'] ) {
			$template = 'view-3';
		}
		if ( 'style4' == $data['layout'] ) {
			$template = 'view-4';
		}
		$this->rt_template( $template, $data );
	}
}