<?php
/**
 * @author  UiGigs
 * @since   1.0
 * @version 1.0
 */

namespace UiGigs\Staco_Core;
use UiGigs\staco\Helper;
use Elementor\Icons_Manager;
$attr = '';
if ( !empty( $data['btnurl']['url'] ) ) {
	$attr  = 'href="' . $data['btnurl']['url'] . '"';
	$attr .= !empty( $data['btnurl']['is_external'] ) ? ' target="_blank"' : '';
	$attr .= !empty( $data['btnurl']['nofollow'] ) ? ' rel="nofollow"' : '';
}

?>

<a href="<?php echo wp_kses_post( $attr ); ?>" class="defi-explore-article-btn btn-hov-effect">
	<?php echo esc_html( $data['btntext'] ); ?> <i><?php Icons_Manager::render_icon( $data['btn_icon'], [ 'aria-hidden' => 'true' ] ); ?></i>
	<span class="round-shape"></span>
</a>
<script>
    (function ($) {
    ("use strict");
        $(document).ready(function () {
            var btnEffect = $(".btn-hov-effect");
            if (btnEffect.length) {
                let button = document.querySelectorAll(".btn-hov-effect");
                button.forEach((item) => {
                    let roundItem = item.querySelector(".round-shape");

                    item.addEventListener("mouseenter", () => {
                        item.classList.add("animate");

                        let buttonX = event.offsetX;
                        let buttonY = event.offsetY;

                        if (buttonY < 105) {
                            roundItem.style.top = 0 + "px";
                        } else if (buttonY > 30) {
                            roundItem.style.top = 210 + "px";
                        }

                        roundItem.style.left = buttonX + "px";
                        roundItem.style.width = "1px";
                        roundItem.style.height = "1px";
                    });
                    item.addEventListener("mouseleave", () => {
                        item.classList.remove("animate");

                        let buttonX = event.offsetX;
                        let buttonY = event.offsetY;

                        if (buttonY < 105) {
                            roundItem.style.top = 0 + "px";
                        } else if (buttonY > 30) {
                            roundItem.style.top = 210 + "px";
                        }
                        roundItem.style.left = buttonX + "px";
                    });
                });
            }
        })
    })(jQuery);
</script>
