<?php
/**
 * @author  UiGigs
 * @since   1.0
 * @version 1.0
 */

namespace UiGigs\Staco_Core;
use UiGigs\staco\Helper;
use Elementor\Icons_Manager;
$attr = '';
if ( !empty( $data['btnurl']['url'] ) ) {
	$attr  = 'href="' . $data['btnurl']['url'] . '"';
	$attr .= !empty( $data['btnurl']['is_external'] ) ? ' target="_blank"' : '';
	$attr .= !empty( $data['btnurl']['nofollow'] ) ? ' rel="nofollow"' : '';
}

?>
<div class="ug-button-area <?php echo esc_attr( $data['button_width'] ); ?>">
	<a <?php echo wp_kses_post( $attr ); ?> class="bg-blue-btn"><?php echo esc_html( $data['btntext'] ); ?> 
	
	<?php if ( 'style1' == $data['icon_select'] ) { ?>
	<?php Icons_Manager::render_icon( $data['btn_icon'], [ 'aria-hidden' => 'true' ] ); ?>
	<?php } ?>

	<?php if ( 'style2' == $data['icon_select'] ) { ?>
		<img src="<?php echo esc_url($data['icon_img1']['url']); ?>" alt="image" />
	<?php } ?>

</a>
</div>
