<?php
/**
 * @author  UiGigs
 * @since   1.0
 * @version 1.0
 */

namespace UiGigs\Staco_Core;
use Elementor\Controls_Manager;
use Elementor\Group_Control_Typography;

if ( ! defined( 'ABSPATH' ) ) exit;

class Countdown extends Custom_Widget_Base {
	public function __construct( $data = [], $args = null ){
		$this->rt_name = __( 'Count Down Timer', 'staco-core' );
		$this->rt_base = 'staco-countdown';
		parent::__construct( $data, $args );
	}
	protected function register_controls() {
		$this->start_controls_section(
			'sec_general',
			[
				'label' => __( 'Count Down', 'staco-core' ),
			]
		);
		$this->add_control(
			'sec_day',
			[
				'label'       => esc_html__( 'Days', 'staco-core' ),
				'type'        => Controls_Manager::TEXT,
				'default'     => "01",
				'label_block' => true,
			]
		);
		$this->add_control(
			'sec_month',
			[
				'label' => __('Layout Type', 'staco-core'),
				'type' => Controls_Manager::SELECT,
				'options' => [
					'Jan' => __( 'January', 'staco-core' ),
					'Feb' => __( 'February', 'staco-core' ),
					'Mar' => __( 'March', 'staco-core' ),
					'Apa' => __( 'April', 'staco-core' ),
					'May' => __( 'May', 'staco-core' ),
					'jun' => __( 'June', 'staco-core' ),
					'Jul' => __( 'July', 'staco-core' ),
					'Aug' => __( 'August', 'staco-core' ),
					'Sept' => __( 'September', 'staco-core' ),
					'Oct' => __( 'October', 'staco-core' ),
					'Nov' => __( 'November', 'staco-core' ),
					'Dec' => __( 'December', 'staco-core' ),
				],
				'label_block' => true,
			]
		);
		$this->add_control(
			'sec_year',
			[
				'label'       => esc_html__( 'Year', 'staco-core' ),
				'type'        => Controls_Manager::TEXT,
				'default'     => "2025",
				'label_block' => true,
			]
		);
		$this->end_controls_section();
		/* = Main Title Settings
		==============================================================*/
		$this->start_controls_section(
			'title_settings',
			[
				'label' => esc_html__( 'Style Settings', 'staco-core' ),
				'tab'   => Controls_Manager::TAB_STYLE,
			]
		);

		$this->add_control(
			'title_color',
			[
				'type'      => Controls_Manager::COLOR,
				'label'     => esc_html__( 'Color', 'staco-core' ),
				'selectors' => [
					'{{WRAPPER}} .header-top-timer ul li' => 'color: {{VALUE}}',
				],
			]
		);

		$this->add_group_control(
			Group_Control_Typography::get_type(),
			[
				'name'     => 'title_typo',
				'label'    => esc_html__( 'Typography', 'staco-core' ),
				'selector' => '{{WRAPPER}} .header-top-timer ul li',
			]
		);

	
		$this->end_controls_section();
	}
	protected function render() {
		$data = $this->get_settings();
		$template = 'view-1';
		$this->rt_template( $template, $data );
	}
}