<?php
/**
 * @author  UiGigs
 * @since   1.0
 * @version 1.0
 * top_sub_title
 * title
 * subtitle
 * bg_title
 * top_title_icon
 *
 */

use UiGigs\staco\Helper; ?>


<!-- We offering Section Start -->
<div class="we-offering-section">
    <div class="row">
        <div class="col-md-6">
            <div class="we-offering-text">

                <?php if ( $data['top_title'] || $data['top_subtitle'] ){ ?>    
                <div class="section-title section-title-left v8 title2 md-mb-20">
                    <?php if ( $data['top_subtitle'] ){ ?>    
                        <span class="sub-title green-lite"><?php echo wp_kses_post( $data['top_subtitle'] ); ?></span>
                    <?php } ?>    
                    <?php if ( $data['top_title'] ){ ?>  
                        <h2 class="title"><?php echo wp_kses_post( $data['top_title'] ); ?></h2>
                    <?php } ?>   
                </div>
                <?php } ?>

                <div class="we-offering-slider-nav">
                    <?php foreach ( $data['slide_list'] as $items => $item ) {                
                        $tab_menu     = !empty($item['tab_menu']) ? $item['tab_menu'] : '';      
                    ?> 
                    <div class="slick-btn"><?php echo wp_kses_post ($tab_menu);?></div>
                    <?php } ?>
                </div>
            </div>
        </div>
        <div class="col-md-6">
            <div class="we-offering-slider-content">
                <div class="we-offering-slide-bg-img">
                    <img src="<?php echo esc_url($data['big_image']['url']); ?>" alt="image" />
                </div>
                <div class="we-offering-slider">

                <?php foreach ( $data['slide_list'] as $items => $item ) {                                                
                    $custom_icon     = !empty($item['custom_icon']) ? $item['custom_icon'] : '';    
                    $title           = !empty($item['title']) ? $item['title'] : '';      
                    $list_title1     = !empty($item['list_title1']) ? $item['list_title1'] : '';      
                    $list_title2     = !empty($item['list_title2']) ? $item['list_title2'] : '';      
                    $list_title3     = !empty($item['list_title3']) ? $item['list_title3'] : '';           
                    $description     = !empty($item['description']) ? $item['description'] : '';      
                ?> 
                    <div class="we-offerSing-slide-item">
                        <div class="we-offering-slide-img">
                            <?php echo wp_get_attachment_image( $item['custom_icon']['id'], 'full' ); ?>
                        </div>
                        <div class="we-offering-slide-item-text">
                            <h4><?php echo wp_kses_post ($title);?></h4>
                            <?php echo wp_kses_post ($description);?>
                            <?php if(!empty($list_title1 || $list_title2 || $list_title3)){ ?>
                            <div class="we-offering-slide-btns xl-mt-25">
                                <?php if(!empty($list_title1)){ ?>
                                <button>
                                    <span class="iconify" data-icon="bi:check-lg"></span> <?php echo wp_kses_post ($list_title1);?>
                                </button>
                                <?php } ?>

                                <?php if(!empty($list_title2)){ ?>
                                <button>
                                    <span class="iconify" data-icon="bi:check-lg"></span> <?php echo wp_kses_post ($list_title2);?>
                                </button>
                                <?php } ?>

                                <?php if(!empty($list_title3)){ ?>
                                <button>
                                    <span class="iconify" data-icon="bi:check-lg"></span> <?php echo wp_kses_post ($list_title3);?>
                                </button>
                                <?php } ?>
                            </div>
                            <?php } ?>

                        </div>
                    </div>
                <?php } ?>
                </div>
            </div>
        </div>
    </div>
</div>
<!-- We offering Section End -->


<script>
    (function ($) {
    ("use strict");
        $(document).ready(function () {
            var offeringSlider = $(".we-offering-slider");
            if (offeringSlider.length) {
                $(".we-offering-slider").slick({
                    slidesToShow: 1,
                    slidesToScroll: 1,
                    arrows: false,
                    fade: true,
                    autoplay: true,
                    autoplaySpeed: 3000,
                    infinite: true,
                    asNavFor: ".we-offering-slider-nav",
                    pauseOnHover: false,
                    pauseOnFocus: false,
                });
            }

            var offeringSlider = $(".we-offering-slider-nav");
            if (offeringSlider.length) {
                $(".we-offering-slider-nav").slick({
                    slidesToShow: 5,
                    slidesToScroll: false,
                    dots: false,
                    arrows: false,
                    centerMode: true,
                    focusOnSelect: true,
                    autoplay: true,
                    infinite: true,
                    asNavFor: ".we-offering-slider",
                });
            }
        });
    })(jQuery);
</script>

