<?php
/**
 * @author  UiGigs
 * @since   1.0
 * @version 1.0
 */

// namespace UiGigs\Staco_Core;

use Elementor\Controls_Manager;

if ( ! defined( 'ABSPATH' ) ) {
	exit;
} // Exit if accessed directly

class staco_Extende_Element_Widget {

	public function __construct() {
		// Counter Extended
		add_action( 'elementor/element/counter/section_counter/after_section_start', [ $this, 'custom_counter_control' ], 10, 2 );
	}

	function custom_counter_control( $counter, $args ) {
		$counter->add_responsive_control(
			'alignment',
			[
				'label'     => __( 'Alignment', 'homlisti-core' ),
				'type'      => Controls_Manager::CHOOSE,
				'options'   => [
					'flex-start;text-align:left;' => [
						'title' => __( 'Left', 'homlisti-core' ),
						'icon'  => 'eicon-text-align-left',
					],
					'center;text-align:center;'   => [
						'title' => __( 'Center', 'homlisti-core' ),
						'icon'  => 'eicon-text-align-center',
					],
					'flex-end;text-align:right;'  => [
						'title' => __( 'Right', 'homlisti-core' ),
						'icon'  => 'eicon-text-align-right',
					],
				],
				'selectors' => [
					'{{WRAPPER}} .elementor-counter .elementor-counter-number-prefix, {{WRAPPER}} .elementor-counter .elementor-counter-number-suffix' => 'flex-grow: inherit;',
					'{{WRAPPER}} .elementor-counter .elementor-counter-number-wrapper' => 'justify-content: {{VALUE}};',
					'{{WRAPPER}} .elementor-counter .elementor-counter-title' => 'justify-content: {{VALUE}};',
				],
			]
		);
	}
}

new staco_Extende_Element_Widget();