<?php
/**
 * @author  UiGigs
 * @since   1.0
 * @version 1.0
 */

namespace UiGigs\Staco_Core;

use Elementor\Controls_Manager;

if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

class FaqTab extends Custom_Widget_Base {

	public function __construct( $data = [], $args = null ) {
		$this->rt_name = esc_html__( 'Faq Tab', 'staco-core' );
		$this->rt_base = 'staco-faq-tab';
		parent::__construct( $data, $args );
	}

	private function staco_elementor_template($type=''){ 
        $type = $type ? $type :'elementor_library';
        global $post;
        $args = array('numberposts' => -1,'post_type' => $type, );
        $posts = get_posts($args);  
        $categories = array(
        ''  => __( 'Select', 'tj-caracraft-core' ),
        );
        foreach ($posts as $pn_cat) {
            $categories[$pn_cat->ID] = get_the_title($pn_cat->ID);
        }
        return $categories;   
	}

	protected function register_controls() {
		$this->start_controls_section(
			'section_faq',
			[
				'label' => __( 'Faq Items', 'staco-core' ),
			]
		);

		$repeater = new \Elementor\Repeater();

		$repeater->add_control(
			'title', [
				'label'       => __( 'Title', 'staco-core' ),
				'type'        => \Elementor\Controls_Manager::TEXTAREA,
				'label_block' => true,
				'rows'        => 2,
			]
		);

		$repeater->add_control(
			'faq_list', [
				'label'       => __( 'Select faq', 'staco-core' ),
				'type'        => \Elementor\Controls_Manager::SELECT2,
				'options' => $this->staco_elementor_template( 'elementor_library' ),
				'label_block' => true,
				'rows'        => 4,
			]
		);

		$this->add_control(
			'faq_tabs',
			[
				'label'       => esc_html__( 'Faq Tab', 'staco-core' ),
				'type'        => \Elementor\Controls_Manager::REPEATER,
				'fields'      => $repeater->get_controls(),
				'default'     => [
					[
						'title'    => esc_html__( 'Title 1', 'staco-core'),
					],
					[
						'title'    => esc_html__( 'Title 2', 'staco-core'),
					],
				],
				'title_field' => '{{{ title }}}'
			]
		);
		$this->end_controls_section();

		// Title Settings
		//============================================

		$this->start_controls_section(
			'section_menu_style',
			[
				'label'     => __( 'Menu Settings', 'staco-core' ),
				'tab'       => Controls_Manager::TAB_STYLE
			]
		);
		

		$this->start_controls_tabs( 'cat_box_style' );

		// Normal tab.
		$this->start_controls_tab(
			'box_style_normal',
			[
				'label' => __( 'Normal', 'staco-core' ),
			]
		);

		$this->add_control(
			'menu_color',
			[
				'label'     => __( 'Color', 'staco-core' ),
				'type'      => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .faq-section-4-tab .nav-link' => 'color: {{VALUE}};',
				],
			]
		);
		$this->add_group_control(
			\Elementor\Group_Control_Typography::get_type(),
			[
				'name'     => 'menu_typography',
				'label'    => __( 'Typography', 'staco-core' ),
				'selector' => '{{WRAPPER}} .faq-section-4-tab .nav-link',
			]
		);
		$this->add_control(
			'menu_border_color',
			[
				'label'     => __( 'Border Color', 'staco-core' ),
				'type'      => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .faq-section-4-tab .nav-link' => 'border-color: {{VALUE}};',
				],
			]
		);

		$this->end_controls_tab();

		// Hover tab.
		$this->start_controls_tab(
			'box_style_hover',
			[
				'label' => __( 'Active Menu', 'staco-core' ),
			]
		);

		$this->add_control(
			'active_menu_color',
			[
				'label'     => __( 'Color', 'staco-core' ),
				'type'      => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .faq-section-4-tab .nav-link.active' => 'color: {{VALUE}};',
				],
			]
		);
		$this->add_group_control(
			\Elementor\Group_Control_Typography::get_type(),
			[
				'name'     => 'active_menu_typography',
				'label'    => __( 'Typography', 'staco-core' ),
				'selector' => '{{WRAPPER}} .faq-section-4-tab .nav-link.active',
			]
		);
		$this->add_control(
			'active_menu_border_color',
			[
				'label'     => __( 'Border Color', 'staco-core' ),
				'type'      => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .faq-section-4-tab .nav-link.active' => 'border-color: {{VALUE}};',
				],
			]
		);
		
		$this->end_controls_tab();
		$this->end_controls_tabs();




		$this->add_responsive_control(
			'menu_align',
			[
				'label' => esc_html__('Alignment', 'scaddon'),
				'type' => Controls_Manager::CHOOSE,
				'options' => [
					'flex-start' => [
						'title' => esc_html__('Left', 'scaddon'),
						'icon' => 'fa fa-align-left',
					],
					'center' => [
						'title' => esc_html__('Center', 'scaddon'),
						'icon' => 'fa fa-align-center',
					],
					'flex-end' => [
						'title' => esc_html__('Right', 'scaddon'),
						'icon' => 'fa fa-align-right',
					],
					'justify' => [
						'title' => esc_html__('Justify', 'scaddon'),
						'icon' => 'fa fa-align-justify',
					],
				],
				'toggle' => true,
				'selectors' => [
					'{{WRAPPER}} .faq-section-4-tab .nav.nav-tabs' => 'justify-content: {{VALUE}}'
				],
				'separator' => 'before',
			]
		);
		$this->end_controls_section();

		// Title Settings
		//============================================

		$this->start_controls_section(
			'section_style_title',
			[
				'label'     => __( 'Title Settings', 'staco-core' ),
				'tab'       => Controls_Manager::TAB_STYLE
			]
		);
		$this->add_control(
			'title_color',
			[
				'label'     => __( 'Title Color', 'staco-core' ),
				'type'      => Controls_Manager::COLOR,
				'default'   => '#ffffff',
				'selectors' => [
					'{{WRAPPER}} .v1_roadmap_contents_text h3' => 'color: {{VALUE}};',
				],
			]
		);
		$this->add_group_control(
			\Elementor\Group_Control_Typography::get_type(),
			[
				'name'     => 'title_typography',
				'label'    => __( 'Typography', 'staco-core' ),
				'selector' => '{{WRAPPER}} .v1_roadmap_contents_text h3',
			]
		);
		$this->end_controls_section();


		// Subtitle Settings
		//============================================
		$this->start_controls_section(
			'section_style_subtitle',
			[
				'label'     => __( 'Sub Title Settings', 'staco-core' ),
				'tab'       => Controls_Manager::TAB_STYLE
			]
		);
		$this->add_control(
			'subtitle_color',
			[
				'label'     => __( 'Sub Title Color', 'staco-core' ),
				'type'      => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .v1_roadmap_contents_text h5' => 'color: {{VALUE}};',
				],
			]
		);
		$this->add_group_control(
			\Elementor\Group_Control_Typography::get_type(),
			[
				'name'     => 'subtitle_typography',
				'label'    => __( 'Typography', 'staco-core' ),
				'selector' => '{{WRAPPER}} .v1_roadmap_contents_text h5',
			]
		);
		$this->end_controls_section();

		// Description Settings
		//============================================
		$this->start_controls_section(
			'section_style_desc',
			[
				'label'     => __( 'Description Settings', 'staco-core' ),
				'tab'       => Controls_Manager::TAB_STYLE
			]
		);
		$this->add_control(
			'desc_color',
			[
				'label'     => __( 'Description Color', 'staco-core' ),
				'type'      => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .v1_roadmap_contents_text p' => 'color: {{VALUE}};',
				],
			]
		);
		$this->add_group_control(
			\Elementor\Group_Control_Typography::get_type(),
			[
				'name'     => 'desc_typography',
				'label'    => __( 'Typography', 'staco-core' ),
				'selector' => '{{WRAPPER}} .v1_roadmap_contents_text p',
			]
		);
		$this->end_controls_section();
	}

	public function faq(){
		wp_enqueue_script('faq');	
	}

	protected function render() {
		$data = $this->get_settings();
		$this->faq();
		$template = 'view';
		$this->rt_template( $template, $data );
	}

}