<?php
/**
 * @author  UiGigs
 * @since   1.0
 * @version 1.0
 */
use Elementor\Plugin;

?>

<div class="faq-section-4-tab">
    <nav>
        <div class="nav nav-tabs" id="nav-tab" role="tablist">
        <?php
            $i=0;
            foreach ( $data['faq_tabs'] as $item ){
            $i++;
            $title = $item['title'];
            $t = $title;
            $uid = strtolower(str_replace(array(':', '\\', '/', '*', '?', '.', ';', ' '), '', $t));
            $activeClass = $i==1 ? ' active':'';
            ?>

            <button
                class="nav-link<?php echo esc_attr($activeClass); ?>"
                id="nav-<?php echo $uid; ?>-tab"
                data-bs-toggle="tab"
                data-bs-target="#nav-<?php echo $uid; ?>"
                type="button"
                role="tab"
                aria-controls="nav-<?php echo $uid; ?>"
                aria-selected="true"
            >
                <?php echo $title ?>
            </button>
            <?php } ?>
        </div>
    </nav>
    <div class="tab-content" id="nav-tabContent">
        <?php 
            $i=0;
            foreach ( $data['faq_tabs'] as $item ){
            $i++;
            $t = $item['title'];
            $uid = strtolower(str_replace(array(':', '\\', '/', '*', '?', '.', ';', ' '), '', $t));
            $tab_body = Plugin::instance()->frontend->get_builder_content_for_display($item['faq_list']);
            $activeClass = $i==1 ? ' active show':'';
        ?>
            <div
                class="tab-pane fade<?php echo esc_attr($activeClass); ?>"
                id="nav-<?php echo $uid; ?>"
                role="tabpanel"
                aria-labelledby="nav-<?php echo $uid; ?>-tab"
                tabindex="0"
            >
            <?php echo $tab_body; ?>
            </div>
        <?php } ?>
    </div>
</div>
