<?php
/**
 * @author  UiGigs
 * @since   1.0
 * @version 1.0
 */

namespace UiGigs\Staco_Core;

use Elementor\Controls_Manager;
use Elementor\Group_Control_Typography;

if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

class Header extends Custom_Widget_Base {

	public function __construct( $data = [], $args = null ) {
		$this->rt_name = esc_html__( 'Header', 'staco-core' );
		$this->rt_base = 'staco-header';
		parent::__construct( $data, $args );
	}

	protected function register_controls() {

		/* = Banner 1 Options
		============================================*/
		$this->start_controls_section(
			'header_section',
			[
				'label' => esc_html__( 'Header', 'staco-core' ),
				'tab'   => Controls_Manager::TAB_CONTENT,
			]
		);
		$this->add_control(
			'show_socials',
			[
				'label'        => esc_html__( 'Show Social Icons', 'staco-core' ),
				'type'         => \Elementor\Controls_Manager::SWITCHER,
				'label_on'     => esc_html__( 'Show', 'staco-core' ),
				'label_off'    => esc_html__( 'Hide', 'staco-core' ),
				'return_value' => 'yes',
				'default'      => false,
			]
		);
		$this->add_control(
			'show_joint',
			[
				'label'        => esc_html__( 'Show Joint Button', 'staco-core' ),
				'type'         => \Elementor\Controls_Manager::SWITCHER,
				'label_on'     => esc_html__( 'Show', 'staco-core' ),
				'label_off'    => esc_html__( 'Hide', 'staco-core' ),
				'return_value' => 'yes',
				'default'      => false,
			]
		);
		$this->add_control(
			'show_connect',
			[
				'label'        => esc_html__( 'Show Connect Button', 'staco-core' ),
				'type'         => \Elementor\Controls_Manager::SWITCHER,
				'label_on'     => esc_html__( 'Show', 'staco-core' ),
				'label_off'    => esc_html__( 'Hide', 'staco-core' ),
				'return_value' => 'yes',
				'default'      => false,
			]
		);
		$this->add_control(
			'disable_menu',
			[
				'label'        => esc_html__( 'Disable Menu', 'staco-core' ),
				'type'         => \Elementor\Controls_Manager::SWITCHER,
				'label_on'     => esc_html__( 'Show', 'staco-core' ),
				'label_off'    => esc_html__( 'Hide', 'staco-core' ),
				'return_value' => 'yes',
				'default'      => true,
			]
		);
		$this->add_responsive_control(
			'align',
			[
				'label' => esc_html__( 'Alignment', 'staco-core' ),
				'type' => Controls_Manager::CHOOSE,
				'options' => [
					'space-between' => [
						'title' => esc_html__( 'Left', 'staco-core' ),
						'icon' => 'eicon-text-align-left',
					],
					'end' => [
						'title' => esc_html__( 'Right', 'staco-core' ),
						'icon' => 'eicon-text-align-right',
					],
				],
				'default' => 'center',
				'selectors' => [
					'{{WRAPPER}} .staco_menu_right_sect' => 'justify-content: {{VALUE}};',
				],
			]
		);
		
		$this->end_controls_section();
    }

	protected function render() {
		$data     = $this->get_settings();
		$template = 'view';
		$this->rt_template( $template, $data );
	}

}