<?php
/**
 * @author  UiGigs
 * @since   1.0
 * @version 1.0
 */

namespace UiGigs\Staco_Core;

use Elementor\Controls_Manager;
use Elementor\Group_Control_Background;

if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

class ImageBox extends Custom_Widget_Base {

	public function __construct( $data = [], $args = null ) {
		$this->rt_name = esc_html__( 'Image Box', 'staco-core' );
		$this->rt_base = 'staco-image-box';
		parent::__construct( $data, $args );
	}
	protected function register_controls() {
		/*
		 * General Options
		 * ************************************
		 */

		$this->start_controls_section(
			'image_box_section',
			[
				'label' => esc_html__( 'Image Box', 'staco-core' ),
				'tab'   => Controls_Manager::TAB_CONTENT,
			]
		);

		$this->add_control(
			'layout',
			[
				'label' => __('Layout Type', 'staco-core'),
				'type' => Controls_Manager::SELECT,
				'default' => 'style1',
				'options' => [
					'style1' => __( 'Banner 1 Image Box', 'staco-core' ),
					'style2' => __( 'Banner 3 Image Box', 'staco-core' ),
					'style3' => __( 'Banner 4 Image Box', 'staco-core' ),
					'style4' => __( 'About Image Box', 'staco-core' ),
					'style5' => __( 'Animation Image', 'staco-core' ),
					'style6' => __( 'Scroll Effect', 'staco-core' ),
				],
				'label_block' => true,
			]
		);
		$this->add_control(
			'image_style',
			[
				'label' => __('Scroll Style', 'staco-core'),
				'type' => Controls_Manager::SELECT,
				'default' => 'scrollstyle1',
				'options' => [
					'scrollstyle1' => __( 'Scroll Style 1', 'staco-core' ),
					'scrollstyle2' => __( 'Scroll Style 2', 'staco-core' ),
					'scrollstyle3' => __( 'Scroll Style 3', 'staco-core' ),
					'scrollstyle4' => __( 'Scroll Style 4', 'staco-core' ),
					'scrollstyle5' => __( 'Scroll Style 5', 'staco-core' ),
					'scrollstyle6' => __( 'Scroll Style 6', 'staco-core' ),
					'scrollstyle7' => __( 'Scroll Style 7', 'staco-core' ),
				],
				'label_block' => true,
				'condition'      => ['layout' => ['style6']],
			]
		);
		$this->add_control(
			'image1',
			[
				'label'   => __( 'Image 1', 'staco-core' ),
				'type'    => \Elementor\Controls_Manager::MEDIA,
				'default' => [
					'url' => \Elementor\Utils::get_placeholder_image_src(),
				],
			]
		);
		$this->add_control(
			'image_link',
			[
				'label'       => esc_html__( 'Link', 'staco-core' ),
				'type'        => Controls_Manager::TEXT,
				'condition'      => ['image_style' => ['scrollstyle1']],
			]
		);
		$this->add_control(
			'image2',
			[
				'label'   => __( 'Image 2', 'staco-core' ),
				'type'    => \Elementor\Controls_Manager::MEDIA,
				'default' => [
					'url' => \Elementor\Utils::get_placeholder_image_src(),
				],
				'condition'      => ['layout' => ['style1', 'style2', 'style3', 'style4']],
			]
		);
		$this->add_control(
			'image3',
			[
				'label'   => __( 'Image 3', 'staco-core' ),
				'type'    => \Elementor\Controls_Manager::MEDIA,
				'default' => [
					'url' => \Elementor\Utils::get_placeholder_image_src(),
				],
				'condition'      => ['layout' => ['style2', 'style3']],
			]
		);
		$this->add_control(
			'image4',
			[
				'label'   => __( 'Image 4', 'staco-core' ),
				'type'    => \Elementor\Controls_Manager::MEDIA,
				'default' => [
					'url' => \Elementor\Utils::get_placeholder_image_src(),
				],
				'condition'      => ['layout' => ['style2', 'style3']],
			]
		);
		$this->add_control(
			'image5',
			[
				'label'   => __( 'Image 5', 'staco-core' ),
				'type'    => \Elementor\Controls_Manager::MEDIA,
				'default' => [
					'url' => \Elementor\Utils::get_placeholder_image_src(),
				],
				'condition'      => ['layout' => 'style2'],
			]
		);
		$this->add_control(
			'image6',
			[
				'label'   => __( 'Image 6', 'staco-core' ),
				'type'    => \Elementor\Controls_Manager::MEDIA,
				'default' => [
					'url' => \Elementor\Utils::get_placeholder_image_src(),
				],
				'condition'      => ['layout' => 'style2'],
			]
		);
		$this->add_control(
            'image_animation',
            [
                'label' => esc_html__('Animation', 'staco'),
                'type' => Controls_Manager::SWITCHER,
                'label_on' => esc_html__('Show', 'staco'),
                'label_off' => esc_html__('Hide', 'staco'),
                'return_value' => 'yes',
                'default' => 'no',
				'condition'      => ['layout' => 'style5'],
            ]
        );
        $this->add_control(
            'images_translate',
            [
                'label'   => esc_html__('Translate Position', 'staco'),
                'type'    => Controls_Manager::SELECT,
                'default' => 'veritcal',
                'options' => [
                    'veritcal' => esc_html__('Veritcal', 'staco'),
                    'horizontal' => esc_html__('Horizontal', 'staco'),
                    'horizontal2' => esc_html__('Horizontal2', 'staco'),
					'spin_style' => esc_html__( 'Spin', 'staco'),
					'scale_style' => esc_html__( 'Scale', 'staco'),
                    'rotate' => esc_html__('Rotate', 'staco'),
                    'zoom_in_out' => esc_html__('Zoom In/Out', 'rsaddon'),
                ],
                'condition' => [
                    'image_animation' => 'yes',
                ],
            ]
        );
		$this->add_control(
            'revas_images',
            [
                'label'   => esc_html__('Translate Revas', 'staco'),
                'type'    => Controls_Manager::SELECT,
                'default' => 'no',
                'options' => [
                    'no' => esc_html__('No', 'staco'),
                    'yes' => esc_html__('Yes', 'staco'),
                ],
                'condition' => [
					'image_animation' => 'yes',
                    'images_translate' => 'veritcal',
                ],
            ]
        );
		$this->end_controls_section();

		//Animated Image Repeater
		$this->start_controls_section(
			'banner4_img_list_section',
			[
				'label' => __( 'Animation Image List', 'staco-core' ),
				'condition'      => ['layout' => 'style3'],
			]
		);
		$repeater = new \Elementor\Repeater();
		$repeater->add_control(
			'anim_img', [
				'label'       => __( 'Image', 'staco-core' ),
				'type'        => \Elementor\Controls_Manager::MEDIA,
				'label_block' => true,
			]
		);
		$this->add_control(
			'anim_img_list',
			[
				'label'       => __( 'List Items', 'staco-core' ),
				'type'        => \Elementor\Controls_Manager::REPEATER,
				'fields'      => $repeater->get_controls(),
				'condition'      => ['layout' => 'style3'],
			]
		);
		$this->end_controls_section();

		/* = Box Settings
		==============================================================*/
		$this->start_controls_section(
			'box_image_settings',
			[
				'label' => esc_html__( 'Box Settings', 'staco-core' ),
				'tab'   => Controls_Manager::TAB_STYLE,
			]
		);
		$this->add_responsive_control(
			'box_image_padding',
			[
				'label'              => __( 'Padding', 'staco-core' ),
				'type'               => Controls_Manager::DIMENSIONS,
				'size_units'         => [ 'px' ],
				'default'            => [
					'top'      => '',
					'right'    => '',
					'bottom'   => '',
					'left'     => '',
					'isLinked' => false,
				],
				'selectors'          => [
					'{{WRAPPER}} .staco-image img' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}}',
				],
			]
		);
		$this->add_group_control(
			Group_Control_Background::get_type(),
			[
				'name' => 'box_background',
				'label' => esc_html__( 'Background', 'staco-core' ),
				'selector' => '{{WRAPPER}} .staco-image .image-area, {{WRAPPER}} .hero-section-index5, {{WRAPPER}} .get-demo-btn',
			]
		);
		
		
		$this->add_responsive_control(
            'img_width',
            [
                'label' => esc_html__('Image Width', 'staco'),
                'type' => Controls_Manager::SLIDER,
                'size_units' => ['px', '%'],
                'range' => [
                    'px' => [
                        'min' => 1,
                        'max' => 2000,
                    ],
                    '%' => [
                        'min' => 1,
                        'max' => 100,
                    ],
                ],
                'selectors' => [
                    '{{WRAPPER}} .staco-image img' => 'max-width: {{SIZE}}{{UNIT}};',
                ],
				'condition'      => ['layout' => 'style5'],
            ]
        );
		$this->add_control(
			'img_border_radius',
			[
				'label' => esc_html__('Image border-radius', 'scaddon'),
				'type' => Controls_Manager::DIMENSIONS,
				'size_units' => ['px', '%'],
				'selectors' => [
					' {{WRAPPER}} .staco-image img' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				],
			]
		);
		$this->add_responsive_control(
            'img_area_width',
            [
                'label' => esc_html__('Image Area width Width', 'staco'),
                'type' => Controls_Manager::SLIDER,
                'size_units' => ['px', '%'],
                'range' => [
                    'px' => [
                        'min' => 1,
                        'max' => 2000,
                    ],
                    '%' => [
                        'min' => 1,
                        'max' => 100,
                    ],
                ],
                'selectors' => [
                    '{{WRAPPER}} .staco-image .image-area' => 'width: {{SIZE}}{{UNIT}};',
                ],
				'condition'      => ['layout' => 'style5'],
            ]
        );
		$this->add_responsive_control(
            'img_area_height',
            [
                'label' => esc_html__('Image Area Height', 'staco'),
                'type' => Controls_Manager::SLIDER,
                'size_units' => ['px', '%'],
                'range' => [
                    'px' => [
                        'min' => 1,
                        'max' => 2000,
                    ],
                    '%' => [
                        'min' => 1,
                        'max' => 100,
                    ],
                ],
                'selectors' => [
                    '{{WRAPPER}} .staco-image .image-area' => 'height: {{SIZE}}{{UNIT}};',
                ],
				'condition'      => ['layout' => 'style5'],
            ]
        );
		$this->add_responsive_control(
            'img_area_lineheight',
            [
                'label' => esc_html__('Image Area Line Height', 'staco'),
                'type' => Controls_Manager::SLIDER,
                'size_units' => ['px', '%'],
                'range' => [
                    'px' => [
                        'min' => 1,
                        'max' => 2000,
                    ],
                    '%' => [
                        'min' => 1,
                        'max' => 100,
                    ],
                ],
                'selectors' => [
                    '{{WRAPPER}} .staco-image .image-area' => 'line-height: {{SIZE}}{{UNIT}};',
                ],
				'condition'      => ['layout' => 'style5'],
            ]
        );
		$this->add_control(
			'img_area_border_radius',
			[
				'label' => esc_html__('Image Area border-radius', 'scaddon'),
				'type' => Controls_Manager::DIMENSIONS,
				'size_units' => ['px', '%'],
				'selectors' => [
					'{{WRAPPER}} .staco-image .image-area' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				],
			]
		);
		$this->add_responsive_control(
            'align',
            [
                'label' => esc_html__('Alignment', 'staco'),
                'type' => Controls_Manager::CHOOSE,
                'options' => [
                    'left' => [
                        'title' => esc_html__('Left', 'staco'),
                        'icon' => 'fa fa-align-left',
                    ],
                    'center' => [
                        'title' => esc_html__('Center', 'staco'),
                        'icon' => 'fa fa-align-center',
                    ],
                    'right' => [
                        'title' => esc_html__('Right', 'staco'),
                        'icon' => 'fa fa-align-right',
                    ],
                    'justify' => [
                        'title' => esc_html__('Justify', 'staco'),
                        'icon' => 'fa fa-align-justify',
                    ],
                ],
                'default' => 'left',
                'toggle' => true,
                'selectors' => [
                    '{{WRAPPER}} .card-img, {{WRAPPER}} .chatbot-why-choose-img, {{WRAPPER}} .staco-image' => 'text-align: {{VALUE}}'
                ],
				'condition'      => ['layout' => ['style5', 'style6']],
                'separator' => 'before',
            ]
        );
		$this->end_controls_section();
    }

    private function image3_load_scripts(){
		wp_enqueue_script( 'banner4-slider' );	
	}

	protected function render() {
		$data     = $this->get_settings();
		if ('style3' == $data['layout']) {
			$this->image3_load_scripts();
		}
		$template = 'view-1';
		if ( 'style2' == $data['layout'] ) {
			$template = 'view-2';
		} elseif ( 'style3' == $data['layout'] ) {
			$template = 'view-3';
		} elseif ( 'style4' == $data['layout'] ) {
			$template = 'view-4';
		} elseif ( 'style5' == $data['layout'] ) {
			$template = 'view-5';
		} elseif ( 'style6' == $data['layout'] ) {
			$template = 'view-6';
		}
		$this->rt_template( $template, $data );
	}

}