<?php
/**
 * @author  UiGigs
 * @since   1.0
 * @version 1.0
 */

namespace UiGigs\Staco_Core;

use Elementor\Plugin;
use UiGigs\staco\Helper;
if ( ! defined( 'ABSPATH' ) ) {
	exit;
} // Exit if accessed directly

require_once Staco_Core_BASE_DIR . '/elementor/controls/traits-icons.php';
// Elementor default widget control
require_once __DIR__ . '/el-extend.php';

class Custom_Widget_Init {

	public function __construct() {
		add_action( 'elementor/widgets/widgets_registered', [ $this, 'init' ] );
		add_action( 'elementor/elements/categories_registered', [ $this, 'widget_category' ] );
		add_action( 'elementor/icons_manager/additional_tabs', [ $this, 'staco_icomoon_tab' ] );
		add_action( 'elementor/editor/after_enqueue_styles', [ $this, 'editor_style' ] );
	}

	public function editor_style() {
		$img = plugins_url( 'icon.png', __FILE__ );
		wp_enqueue_style( 'ico-moon-fonts' );
		wp_add_inline_style( 'elementor-editor', '.elementor-element .icon .rdtheme-el-custom{content: url(' . $img . ');width: 28px;}' );
		wp_add_inline_style( 'elementor-editor', '.elementor-panel .select2-container {min-width: 100px !important; min-height: 30px !important;}' );
		wp_add_inline_style( 'elementor-editor', '.elementor-panel .elementor-control-type-heading .elementor-control-title {color: #93013d !important}' );
	}

	public function init() {
		require_once __DIR__ . '/base.php';

		// dirname => classname /@dev
		$widgets = [
			'scrollSlider'        => 'scrollSlider',
			'StacoMenu'           => 'StacoMenu',
			'priceTable'          => 'priceTable',
			'counter'             => 'StacoCounter',
			'scrollLogo'          => 'scrollLogo',
			'scrollStep'          => 'scrollStep',
			'BusinessTools'       => 'BusinessTools',
			'comparePrice'        => 'comparePrice',
			'comparePrice2'        => 'comparePrice2',
			'title'               => 'Title',
			'banner1'             => 'Banner1',
			'banner2'             => 'Banner2',
			'banner3'             => 'Banner3',
			'banner4'             => 'Banner4',
			'imageBox'            => 'ImageBox',
			'stacoPortfolio'      => 'stacoPortfolio',
			'servicesGrid'        => 'servicesGrid',
			'tabEditor'           => 'tabEditor',
			'discoverTabSlider'   => 'discoverTabSlider',
			'tabSlider'           => 'tabSlider',
			'tabSlider2'          => 'tabSlider2',
			'nftSlider'           => 'nftSlider',
			'HotCollections'      => 'HotCollections',
			'LiveAuctions'        => 'LiveAuctions',
			'NFTCategories'       => 'NFTCategories',
			'DiscoverNFTs'        => 'DiscoverNFTs',
			'pieProgress'         => 'pieProgress',
			'stacoTestimonial'    => 'stacoTestimonial',
			'stacoVideo'          => 'stacoVideo',
			'animatedHeading'     => 'animatedHeading',
			'team'                => 'Team',
			'faq'                 => 'Faq',
			'faq-tab'             => 'FaqTab',
			'button'              => 'Button',
			'socials'             => 'SocialMedia',
			'animImg'             => 'AnimImg',
			'mintSteps'           => 'mintSteps',
			'nftGallery'          => 'NftGallery',
			'rotateIcon'          => 'rotateIcon',
			'roadmap'    	      => 'Roadmap',
			'news-ticker'         => 'News_Ticker',
			'roadmap-box'         => 'Roadmap_Box',
			'post'                => 'Post',
			'postList'                => 'postList',
			'countdown'           => 'Countdown',
			'hoverTabs'           => 'hoverTabs',
			'tabTestimonils'      => 'tabTestimonils',
			'scrollImageSlider'   => 'scrollImageSlider',
			'stacoSlider'         => 'stacoSlider',
			'servicesSlider'      => 'servicesSlider',
			'safePlatform'        => 'safePlatform',
			'servicesList'        => 'servicesList',
			'qrCode'              => 'qrCode',
			'tokenFeatures'       => 'tokenFeatures',
			'tokenScrollSlider'   => 'tokenScrollSlider',
			'scrollText'   => 'scrollText',
			'documentsList'   => 'documentsList',
			'globeImg'   => 'globeImg',
			'shareBox'   => 'shareBox',
			'stickySection' => 'stickySection',
		];

		foreach ( $widgets as $dirname => $class ) {
			$template_name = '/elementor-custom/' . $dirname . '/class.php';
			if ( file_exists( STYLESHEETPATH . $template_name ) ) {
				$file = STYLESHEETPATH . $template_name;
			} elseif ( file_exists( TEMPLATEPATH . $template_name ) ) {
				$file = TEMPLATEPATH . $template_name;
			} else {
				$file = __DIR__ . '/' . $dirname . '/class.php';
			}

			require_once $file;

			$classname = __NAMESPACE__ . '\\' . $class;
			Plugin::instance()->widgets_manager->register_widget_type( new $classname );
		}
	}

	/**
	 * Adding custom icon to icon control in Elementor
	 */
	public function staco_icomoon_tab( $tabs = [] ) {
		if( ! class_exists('UiGigs\staco\Helper') )
			return;
		// Append new icons
		$icomoon_icons = ElementorIconTrait::icomoon_icons();

		$tabs['staco-icomoon-icons'] = [
			'name'          => 'staco-icomoon-icons',
			'label'         => esc_html__( 'Ico Moon Icons', 'staco-core' ),
			'labelIcon'     => 'fab fa-elementor',
			'prefix'        => '',
			'displayPrefix' => '',
			'url'           => Helper::get_nomin_css( 'ico-moon-fonts' ),
			'icons'         => $icomoon_icons,
			'ver'           => '1.0',
		];

		return $tabs;
	}

	public function widget_category( $elements_manager ) {
		$id                = Staco_Core_THEME_PREFIX . '-widgets';
		$categories[ $id ] = [
			'title' => __( 'staco Elements', 'plugin-name' ),
			'icon'  => 'fa fa-plug',
		];
		$old_categories    = $elements_manager->get_categories();
		$categories        = array_merge( $categories, $old_categories );
		$set_categories    = function ( $categories ) {
			$this->categories = $categories;
		};
		$set_categories->call( $elements_manager, $categories );
	}

}

new Custom_Widget_Init();