<?php
/**
 * @author  UiGigs
 * @since   1.0
 * @version 1.0
 */

namespace UiGigs\Staco_Core;

use Elementor\Icons_Manager;
use Elementor\Controls_Manager;
use Elementor\Widget_Base;
use Elementor\Group_Control_Box_Shadow;
use Elementor\Group_Control_Typography;
use Elementor\Core\Schemes\Typography;
use Elementor\Group_Control_Border;
use Elementor\Group_Control_Background;

if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

class pieProgress extends Custom_Widget_Base {
	public function __construct( $data = [], $args = null ) {
		$this->rt_name = esc_html__( 'Pie Progress', 'staco-core' );
		$this->rt_base = 'staco-pieProgress';
		parent::__construct( $data, $args );
	}
	protected function register_controls() {
		$this->start_controls_section(
			'section_title',
			[
				'label' => esc_html__('Number & Text', 'staco-core'),
				'tab' => Controls_Manager::TAB_CONTENT,
			]
		);
		$this->add_control(
			'layout',
			[
				'label' => __('Style', 'staco-core'),
				'type' => Controls_Manager::SELECT,
				'default' => 'style1',
				'options' => [
					'style1' => __( 'Style 1', 'staco-core' ),
					'style2' => __( 'Style 2', 'staco-core' ),
				],
				'label_block' => true,
			]
		);
		$this->add_control(
			'title',
			[
				'label'       => esc_html__('Number', 'staco-core'),
				'type'        => Controls_Manager::TEXT,
				'label_block' => true,
				'default'     => '92%',
				'placeholder' => esc_html__('92%', 'staco-core'),
				'separator'   => 'before',
			]
		);

		$this->add_control(
			'text',
			[
				'label_block' => true,
				'label' => esc_html__('Text', 'staco-core'),
				'type' => Controls_Manager::TEXT,
				'default'     => 'Success rate',
				'placeholder' => esc_html__('Success rate', 'staco-core'),
			]
		);
		$this->end_controls_section();

		$this->start_controls_section(
			'_section_title_style',
			[
				'label' => esc_html__('Number & Text', 'staco-core'),
				'tab'   => Controls_Manager::TAB_STYLE,
			]
		);
		$this->add_control(
			'title_heading',
			[
				'type' => Controls_Manager::HEADING,
				'label' => esc_html__('Number', 'staco-core'),
				'separator' => 'before'
			]
		);

		$this->add_responsive_control(
			'title_spacing',
			[
				'label' => esc_html__('Number Spacing', 'staco-core'),
				'type' => Controls_Manager::SLIDER,
				'size_units' => ['px'],
				'selectors' => [

					'{{WRAPPER}} .pie_progress__label h4' => 'margin-bottom: {{SIZE}}{{UNIT}};',

				],
			]
		);

		$this->add_control(
			'title_color',
			[
				'label' => esc_html__('Number Color', 'staco-core'),
				'type' => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .pie_progress__label h4' => 'color: {{VALUE}}',
				],
			]
		);

		$this->add_control(
			'description_heading',
			[
				'type' => Controls_Manager::HEADING,
				'label' => esc_html__('Text', 'staco-core'),
				'separator' => 'before'
			]
		);

		$this->add_responsive_control(
			'description_spacing',
			[
				'label' => esc_html__('Text Spacing', 'staco-core'),
				'type' => Controls_Manager::SLIDER,
				'size_units' => ['px'],
				'selectors' => [
					'{{WRAPPER}} .pie_progress__label p' => 'margin-bottom: {{SIZE}}{{UNIT}};',
				],
			]
		);

		$this->add_control(
			'barcolor',
			[
				'label' => esc_html__('Circle Bar-color', 'staco-core'),
				'type' => Controls_Manager::TEXT,
			]
		);
		$this->add_control(
			'trackcolor',
			[
				'label' => esc_html__('Circle Track-color', 'staco-core'),
				'type' => Controls_Manager::TEXT,
			]
		);

		$this->end_controls_section();
    }

	protected function render() {
		$data     = $this->get_settings();
		$template = 'view';
		if ( 'style1' == $data['layout'] ) {
			$template = 'view';
		} elseif ( 'style2' == $data['layout'] ) {
			$template = 'view-2';
		} 
		$this->rt_template( $template, $data );
	}

}