<?php
/**
 * @author  UiGigs
 * @since   1.0
 * @version 1.2
 */

namespace UiGigs\Staco_Core;

use Elementor\Controls_Manager;
use Elementor\Group_Control_Typography;

if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

class Post extends Custom_Widget_Base {

	public function __construct( $data = [], $args = null ) {
		$this->rt_name      = esc_html__( 'Post', 'staco-core' );
		$this->rt_base      = 'rt-post';
		$this->rt_translate = [
			'cols' => [
				'1'  => __( '1 Columns', 'staco-core' ),
				'2'  => __( '2 Columns', 'staco-core' ),
				'3'  => __( '3 Columns', 'staco-core' ),
				'4' => __( '4 Columns', 'staco-core' ),
				'5' => __( '5 Columns', 'staco-core' ),
				'6' => __( '6 Columns', 'staco-core' ),
				'7' => __( '7 Columns', 'staco-core' ),
				'8' => __( '8 Columns', 'staco-core' ),
			],
		];
		parent::__construct( $data, $args );
	}

	protected function register_controls() {
		// widget title
		$this->start_controls_section(
			'rt_post_grid',
			[
				'label' => esc_html__( 'Post Grid', 'staco-core' ),
				'tab'   => Controls_Manager::TAB_CONTENT,
			]
		);

		$this->add_control(
			'layout',
			[
				'label' => __('Layout Type', 'staco-core'),
				'type' => Controls_Manager::SELECT,
				'default' => 'style1',
				'options' => [
					'style1' => __( 'Style 1', 'staco-core' ),
					'style2' => __( 'Style 2', 'staco-core' ),
				],
				'label_block' => true,
			]
		);

		$this->add_control(
			'gird_column',
			[
				'label'   => esc_html__( 'Grid Column', 'staco-core' ),
				'type'    => Controls_Manager::SELECT,
				'default' => '3',
				'options' => $this->rt_translate['cols'],

			]
		);

		$this->add_control(
			'post_limit',
			[
				'label'       => __( 'Post Limit', 'staco-core' ),
				'type'        => Controls_Manager::TEXT,
				'placeholder' => __( 'Enter Post Limit', 'staco-core' ),
				'description' => __( 'Enter number of post to show.', 'staco-core' ),
				'default'     => '3',
			]
		);
		$this->add_control(
			'content_limit',
			[
				'label'     => __( 'Excerpt Limit', 'staco-core' ),
				'type'      => Controls_Manager::TEXT,
				'default'   => '15',
			]
		);
		$this->add_control(
			'blog_image',
			[
				'label' => esc_html__('Choose Background Image', 'scaddon'),
				'type' => Controls_Manager::MEDIA,
				'separator' => 'before',
				'condition'      => ['layout' => ['style1']],
			]
		);
		$this->add_control(
			'details_icon',
			[
				'label'   => __( 'Details Icon', 'staco-core' ),
				'type'    => \Elementor\Controls_Manager::MEDIA,
				'default' => [
					'url' => \Elementor\Utils::get_placeholder_image_src(),
				],
				'condition'      => ['layout' => ['style2']],
			]
		);
		$this->add_control(
			'query_type',
			[
				'label'       => __( 'Post Source', 'staco-core' ),
				'type'    => Controls_Manager::SELECT2,
				'label'   => esc_html__( 'Get Posts by category or title', 'evacon-core' ),
				'options' => array(
					'cats' => esc_html__( 'Posts by Categories', 'evacon-core' ),
					'titles' => esc_html__( 'Posts by Titles', 'evacon-core' ),
				),
				'label_block' => true,
			]
		);

		$this->add_control(
			'postbycats',
			[
				'label'       => __( 'Choose Categories', 'staco-core' ),
				'type'        => Controls_Manager::SELECT2,
				'multiple'    => true,
				'options'     => $this->staco_category_list(),
				'label_block' => true,
				'condition'   => [
					'query_type' => 'cats',
				],
				'description' => __( 'Select post category\'s.', 'staco-core' ),
			]
		);

		$this->add_control(
			'postbytitle',
			[
				'label'       => __( 'Posts By Title', 'staco-core' ),
				'type'    => Controls_Manager::SELECT2,
				'options' => $this->staco_blog_posts_title(),
				'default' => '',
				'multiple' => true,
				'label_block' => true,
				'description' => __( 'Select post tag\'s.', 'staco-core' ),
				'condition'   => array( 'query_type' => array( 'titles' ) ),
			]
		);

		$this->add_control(
			'offset',
			[
				'label'       => __( 'Post offset', 'staco-core' ),
				'type'        => Controls_Manager::TEXT,
				'placeholder' => __( 'Enter Post offset', 'staco-core' ),
				'description' => __( 'Number of post to displace or pass over. The offset parameter is ignored when post limit => -1 (show all posts) is used.', 'staco-core' ),
			]
		);

		$this->add_control(
			'orderby',
			[
				'label'   => __( 'Order by', 'staco-core' ),
				'type'    => Controls_Manager::SELECT,
				'options' => [
					'date'           => __( 'Date', 'staco-core' ),
					'ID'             => __( 'Order by post ID', 'staco-core' ),
					'author'         => __( 'Author', 'staco-core' ),
					'title'          => __( 'Title', 'staco-core' ),
					'modified'       => __( 'Last modified date', 'staco-core' ),
					'parent'         => __( 'Post parent ID', 'staco-core' ),
					'comment_count'  => __( 'Number of comments', 'staco-core' ),
					'menu_order'     => __( 'Menu order', 'staco-core' ),
					'meta_value'     => __( 'Meta value', 'staco-core' ),
					'meta_value_num' => __( 'Meta value number', 'staco-core' ),
					'rand'           => __( 'Random order', 'staco-core' ),
				],
			]
		);

		$this->add_control(
			'order',
			[
				'label'   => __( 'Sort order', 'staco-core' ),
				'type'    => Controls_Manager::SELECT,
				'options' => [
					'ASC'  => __( 'ASC', 'staco-core' ),
					'DESC' => __( 'DESC', 'staco-core' ),
				],
			]
		);
		$this->add_control(
			'post_admin',
			[
				'label'        => __( 'Author Visibility', 'staco-core' ),
				'type'         => Controls_Manager::SWITCHER,
				'label_on'     => __( 'Show', 'staco-core' ),
				'label_off'    => __( 'Hide', 'staco-core' ),
				'return_value' => 'yes',
				'default'      => 'yes',
			]
		);
		$this->add_control(
			'post_cat',
			[
				'label'        => __( 'Category Visibility', 'staco-core' ),
				'type'         => Controls_Manager::SWITCHER,
				'label_on'     => __( 'Show', 'staco-core' ),
				'label_off'    => __( 'Hide', 'staco-core' ),
				'return_value' => 'yes',
				'default'      => 'yes',
			]
		);

		$this->add_control(
			'post_date',
			[
				'label'        => __( 'Date Visibility', 'staco-core' ),
				'type'         => Controls_Manager::SWITCHER,
				'label_on'     => __( 'Show', 'staco-core' ),
				'label_off'    => __( 'Hide', 'staco-core' ),
				'return_value' => 'yes',
				'default'      => 'yes',
			]
		);

		$this->add_control(
			'post_comm',
			[
				'label'        => __( 'Comment Visibility', 'staco-core' ),
				'type'         => Controls_Manager::SWITCHER,
				'label_on'     => __( 'Show', 'staco-core' ),
				'label_off'    => __( 'Hide', 'staco-core' ),
				'return_value' => 'yes',
				'default'      => 'yes',
			]
		);

		$this->add_control(
			'more_btn',
			[
				'label'        => __( 'Read More Visibility', 'staco-core' ),
				'type'         => Controls_Manager::SWITCHER,
				'label_on'     => __( 'Show', 'staco-core' ),
				'label_off'    => __( 'Hide', 'staco-core' ),
				'return_value' => 'yes',
				'default'      => 'yes',
			]
		);
		$this->end_controls_section();

		// Title Settings
		//=====================================================================
		$this->start_controls_section(
			'title_style',
			[
				'label' => __( 'Title Style', 'staco-core' ),
				'tab'   => Controls_Manager::TAB_STYLE,
			]
		);
		$this->add_group_control(
			Group_Control_Typography::get_type(),
			[
				'name'     => 'title_typography',
				'selector' => '{{WRAPPER}} .content-box_header__title a',
			]
		);
		$this->add_control(
			'title_spacing',
			[
				'label'              => __( 'Title Spacing', 'staco-core' ),
				'type'               => Controls_Manager::DIMENSIONS,
				'size_units'         => [ 'px' ],
				'selectors'          => [
					'{{WRAPPER}} .content-box_header__title a' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				],
				'allowed_dimensions' => 'vertical',
				'default'            => [
					'top'      => '',
					'right'    => '',
					'bottom'   => '14',
					'left'     => '',
					'isLinked' => false,
				],
			]
		);
		$this->start_controls_tabs(
			'title_style_tabs'
		);
		$this->start_controls_tab(
			'title_normal_tab',
			[
				'label' => __( 'Normal', 'staco-core' ),
			]
		);
		$this->add_control(
			'title_color',
			[
				'label'     => __( 'Title Color', 'staco-core' ),
				'type'      => \Elementor\Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .content-box_header__title a' => 'color: {{VALUE}}',
				],
			]
		);
		$this->end_controls_tab();

		$this->start_controls_tab(
			'title_hover_tab',
			[
				'label' => __( 'Hover', 'staco-core' ),
			]
		);
		$this->add_control(
			'title_hover_color',
			[
				'label'     => __( 'Title Hover Color', 'staco-core' ),
				'type'      => \Elementor\Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .content-box_header__title a:hover' => 'color: {{VALUE}} !important',
				],
			]
		);
		$this->end_controls_tab();

		$this->end_controls_tabs();

		$this->end_controls_section();


		// Content Settings
		//=====================================================================

		$this->start_controls_section(
			'content_style',
			[
				'label' => __( 'Excerpt Style', 'staco-core' ),
				'tab'   => \Elementor\Controls_Manager::TAB_STYLE,
			]
		);
		$this->add_group_control(
			\Elementor\Group_Control_Typography::get_type(),
			[
				'name'      => 'content_typography',
				'selector'  => '{{WRAPPER}} .content-box_body p',
			]
		);
		$this->add_control(
			'content_spacing',
			[
				'label'              => __( 'Excerpt Spacing', 'staco-core' ),
				'type'               => Controls_Manager::DIMENSIONS,
				'size_units'         => [ 'px' ],
				'selectors'          => [
					'{{WRAPPER}} .content-box_body' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				],
				'allowed_dimensions' => 'vertical',
				'default'            => [
					'top'      => '',
					'right'    => '',
					'bottom'   => '',
					'left'     => '',
					'isLinked' => false,
				],
			]
		);
		$this->add_control(
			'content_color',
			[
				'label'     => __( 'Content Color', 'staco-core' ),
				'type'      => \Elementor\Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .content-box_body p' => 'color: {{VALUE}}',
				],
			]
		);
		$this->end_controls_section();

		
		// Meta Settings
		//=====================================================================
		$this->start_controls_section(
			'meta_style',
			[
				'label' => __( 'Meta Style', 'staco-core' ),
				'tab'   => Controls_Manager::TAB_STYLE,
			]
		);
		$this->add_group_control(
			Group_Control_Typography::get_type(),
			[
				'name'     => 'meta_typography',
				'selector' => '{{WRAPPER}} ul.entry-meta li',
			]
		);
		$this->start_controls_tabs(
			'meta_style_tabs'
		);
		$this->start_controls_tab(
			'meta_normal_tab',
			[
				'label' => __( 'Normal', 'staco-core' ),
			]
		);
		$this->add_control(
			'meta_color',
			[
				'label'     => __( 'Meta Color', 'staco-core' ),
				'type'      => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} ul.entry-meta li' => 'color: {{VALUE}}',
				],
			]
		);
		$this->add_control(
			'meta_link_color',
			[
				'label'     => __( 'Meta Link Color', 'staco-core' ),
				'type'      => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} ul.entry-meta li a' => 'color: {{VALUE}}',
				],
			]
		);
		$this->end_controls_tab();

		$this->start_controls_tab(
			'meta_hover_tab',
			[
				'label' => __( 'Hover', 'staco-core' ),
			]
		);
		$this->add_control(
			'meta_hover_color',
			[
				'label'     => __( 'Meta Link Hover Color', 'staco-core' ),
				'type'      => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} ul.entry-meta li a:hover' => 'color: {{VALUE}} !important',
				],
			]
		);
		$this->end_controls_tab();

		$this->end_controls_tabs();

		$this->end_controls_section();

		// Read More Settings
		//=====================================================================
		$this->start_controls_section(
			'read_more_style',
			[
				'label' => __( 'Read More/Comments Style', 'staco-core' ),
				'tab'   => Controls_Manager::TAB_STYLE,
			]
		);
		$this->add_group_control(
			Group_Control_Typography::get_type(),
			[
				'name'     => 'read_more_typography',
				'selector' => '{{WRAPPER}} .content-box_footer a',
			]
		);
		$this->start_controls_tabs(
			'read_more_style_tabs'
		);
		$this->start_controls_tab(
			'read_more_normal_tab',
			[
				'label' => __( 'Normal', 'staco-core' ),
			]
		);
		$this->add_control(
			'read_more_color',
			[
				'label'     => __( 'Meta Color', 'staco-core' ),
				'type'      => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .content-box_footer a' => 'color: {{VALUE}}',
				],
			]
		);
		$this->end_controls_tab();

		$this->start_controls_tab(
			'read_more_hover_tab',
			[
				'label' => __( 'Hover', 'staco-core' ),
			]
		);
		$this->add_control(
			'read_more_hover_color',
			[
				'label'     => __( 'Meta Link Hover Color', 'staco-core' ),
				'type'      => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .content-box_footer a:hover' => 'color: {{VALUE}} !important',
				],
			]
		);
		$this->end_controls_tab();

		$this->end_controls_tabs();

		$this->end_controls_section();
	}

	protected function render() {
		$data = $this->get_settings();
		$template = 'view';
		if ( 'style2' == $data['layout'] ) {
			$template = 'view-2';
		}
		$this->rt_template( $template, $data );
	}

}