<?php
/**
 * This file can be overridden by copying it to yourtheme/elementor-custom/posts/view-1.php
 * 
 * @author  RadiusTheme
 * @since   1.0
 * @version 1.0
 */

namespace UiGigs\Staco_Core;
use UiGigs\staco\Helper; 

extract( $data );

$cols = $gird_column;
$excerpt = $content_limit;
$padmin = $post_admin;
$pdate = $post_date;
$pcats = $post_cat;
$pcomnt = $post_comm;
$more = $more_btn;

$grid_query= null;
if ( $query_type == 'cats' && !empty( $postbycats ) ) {
    $args = array(
        'post_type'      => 'post',
        'post_status'    => 'publish',
        'posts_per_page' => $post_limit,
        'orderby'        => $orderby,
        'order'        	 => $order,
        'tax_query' => array(
            array(
                'taxonomy' => 'category',
                'field' => 'id',
                'terms' => $postbycats
            )
        ),
    );
} elseif ( $query_type == 'titles' && !empty( $postbytitle ) ) {
    $args = array(
        'post_type'      => 'post',
        'post_status'    => 'publish',
        'posts_per_page' => $post_limit,
        'orderby'        => $orderby,
        'order'        	 => $order,
        'taxonomy'       => 'category',
        'post__in'       => $postbytitle
    );
} else {
    $args = array(
        'post_type'      => 'post',
        'post_status'    => 'publish',
        'posts_per_page' => $post_limit,
        'orderby'        => $orderby,
        'order'        	 => $order,
        'offset'         => $offset,
        'taxonomy'       => 'category'
    );
}

$grid_query = new \WP_Query( $args );

if ( $grid_query->have_posts() ): 

?>


<div class="latest-articles-content">
    <div class="row">
        <?php 
            while ( $grid_query->have_posts() ) : $grid_query->the_post(); 
            $post_id = get_the_ID();
            $post_admin     = get_the_author();

            $comments_number = get_comments_number($post_id);
            $comments_text   = sprintf( _n( '%s', '%s', $comments_number, 'staco' ), number_format_i18n( $comments_number ) );
            if ( has_post_thumbnail() ){
                $thumb_img = '';
            } else {
                $thumb_img = 'no-image';
            } 
        ?>
        <div class="col-md-4 col-sm-6">
            <div class="latest-articles-card">
                <?php if ( has_post_thumbnail() ) : ?>
                    <div class="articles-img">
                    <?php the_post_thumbnail(); ?>
                    </div>
                <?php endif; ?>
                <div class="latest-articles-text">
                    <p><?php the_category(); ?></p>
                    <a href="<?php the_permalink(); ?>"><h4 data-splitting><?php echo the_title(); ?></h4></a>
                    <div class="articles-footer">
                        <p><?php echo get_the_date(); ?></p>
                        <?php echo wp_get_attachment_image( $data['details_icon']['id'], 'full' ); ?>
                    </div>
                </div>
            </div>
        </div>
        <?php endwhile; wp_reset_postdata(); ?> 

    </div>
</div>

<?php endif; ?>