<?php
/**
 * @author  UiGigs
 * @since   1.0
 * @version 1.0
 */
namespace UiGigs\Staco_Core;
use Elementor\Repeater;
use Elementor\Controls_Manager;
use Elementor\Group_Control_Border;
use Elementor\Group_Control_Box_Shadow;
use Elementor\Group_Control_Typography;
use Elementor\Group_Control_Background;

if ( ! defined( 'ABSPATH' ) ) {
	exit;
}
class priceTable extends Custom_Widget_Base {
	public function __construct( $data = [], $args = null ) {
		$this->rt_name = esc_html__( 'Price Table', 'staco-core' );
		$this->rt_base = 'staco-price-table';
		parent::__construct( $data, $args );
	}
	protected function register_controls() {
		$this->start_controls_section(
            '_section_price',
            [
                'label' => esc_html__( 'Pricing Table', 'uigigs' ),
                'tab' => Controls_Manager::TAB_CONTENT,
            ]
        );
        $this->add_control(
			'layout',
			[
				'label' => __('Layout Type', 'staco-core'),
				'type' => Controls_Manager::SELECT,
				'default' => 'style1',
				'options' => [
					'style1' => __( 'Style 1', 'staco-core' ),
					'style2' => __( 'Style 2', 'staco-core' ),
				],
				'label_block' => true,
			]
		);
        $this->add_control(
			'column_row',
			[
				'label' => __('Price Column', 'staco-core'),
				'type' => Controls_Manager::SELECT,
				'default' => 'column4',
				'options' => [
					'1' => __( '12', 'staco-core' ),
                    '2' => __( '6', 'staco-core' ),
                    '3' => __( '4', 'staco-core' ),
                    '4' => __( '3', 'staco-core' ),
                    '6' => __( '2', 'staco-core' ),
                    '12' => __( '1', 'staco-core' ),

				],
				'label_block' => true,
			]
		);
        $this->add_control(
			'equal_height',
			[
				'label' => __('Price Equal Height', 'staco-core'),
				'type' => Controls_Manager::SELECT,
				'default' => 'no',
				'options' => [
					'no' => __( 'No', 'staco-core' ),
                    'yes' => __( 'Yes', 'staco-core' ),

				],
				'label_block' => true,
			]
		);
        $this->add_control(
			'icon_postion',
			[
				'label' => __('Top Icon Show/Hide', 'staco-core'),
				'type' => Controls_Manager::SELECT,
				'default' => 'bottom',
				'options' => [
					'top' => __( 'Button Top', 'staco-core' ),
                    'bottom' => __( 'Button Bottom', 'staco-core' ),

				],
				'label_block' => true,
			]
		);
        $this->add_control(
			'button_position',
			[
				'label' => __('Button Icon/Text', 'staco-core'),
				'type' => Controls_Manager::SELECT,
				'default' => 'bottom',
				'options' => [
					'top' => __( 'Button Top', 'staco-core' ),
                    'bottom' => __( 'Button Bottom', 'staco-core' ),

				],
				'label_block' => true,
			]
		);
        $this->add_control(
			'button_style',
			[
				'label' => __('Button Icon/Text', 'staco-core'),
				'type' => Controls_Manager::SELECT,
				'default' => 'btn_icon',
				'options' => [
					'btn_icon' => __( 'Button Icon', 'staco-core' ),
                    'btn_text' => __( 'Button Text', 'staco-core' ),

				],
				'label_block' => true,
			]
		);
        
        $this->add_control(
            'yearly_discount',
            [
                'label' => esc_html__( 'Yearly Discount', 'uigigs' ),
                'type' => Controls_Manager::TEXT,
                'default' => '(20% Off)',
            ]
        );
        $repeater = new Repeater();

        $repeater->add_control(
			'active_switcher',
			[
				'label' => esc_html__( 'Active', 'staco-core' ),
				'type' => Controls_Manager::SWITCHER,
				'label_on' => esc_html__( 'Show', 'staco-core' ),
				'label_off' => esc_html__( 'Hide', 'staco-core' ),
				'return_value' => 'yes',
				'default' => 'no',
			]
		);

        $repeater->add_control(
            'most_popular',
            [
                'label' => esc_html__( 'Most Popular', 'uigigs' ),
                'type' => Controls_Manager::TEXT,
                'condition'      => ['active_switcher' => ['yes']],
            ]
        );

        $repeater->add_control(
            'monthly_options',
            [
                'label' => esc_html__( 'Monthly Pricing Here', 'uigigs' ),
                'type' => Controls_Manager::HEADING,
                'separator' => 'before',
            ]
        );

        $repeater->add_control(
            'title',
            [
                'label' => esc_html__( 'Title', 'uigigs' ),
                'type' => Controls_Manager::TEXT,
                'label_block' => false,
                'default' => esc_html__( 'Basic', 'uigigs' ),
            ]
        );

        $repeater->add_control(
			'image_icon',
			[
				'label'   => __( 'Icon Image', 'staco-core' ),
				'type'    => \Elementor\Controls_Manager::MEDIA,
				'default' => [
					'url' => \Elementor\Utils::get_placeholder_image_src(),
				],
			]
		);
        $repeater->add_control(
			'custom_icon',
			[
				'label'   => __( 'Custom Icon Image', 'staco-core' ),
				'type'    => \Elementor\Controls_Manager::MEDIA,
				'default' => [
					'url' => \Elementor\Utils::get_placeholder_image_src(),
				],
			]
		);

        $repeater->add_control(
            'price',
            [
                'label' => esc_html__( 'Price', 'uigigs' ),
                'type' => Controls_Manager::TEXT,
                'default' => esc_html__( '$29.00', 'uigigs' ),
            ]
        );
        $repeater->add_control(
            'monthly_title',
            [
                'label' => esc_html__( '/Month', 'uigigs' ),
                'type' => Controls_Manager::TEXT,
                'default' => 'Monthly',
            ]
        );
       

        $repeater->add_control(
            'description',
            [
                'label' => esc_html__( 'Description', 'uigigs' ),
                'type' => Controls_Manager::TEXT,
                'default' => esc_html__( 'Perfect for Prosonal', 'uigigs' ),
            ]
        );

        $repeater->add_control(
            'price_subtitle',
            [
                'label' => esc_html__( 'Price Subtitle', 'uigigs' ),
                'type' => Controls_Manager::TEXT,
            ]
        );

        $repeater->add_control(
            'features',
            [
                'label'   => esc_html__( 'Features (Use List Style)', 'uigigs' ),
                'type'    => Controls_Manager::WYSIWYG,
                'rows'    => 10, 
                'default' => esc_html__( '1 Users', 'uigigs' ),          
            ]
        );

        $repeater->add_control(
            'button_text',
            [
                'label' => esc_html__( 'Button Text', 'uigigs' ),
                'type' => Controls_Manager::TEXT,
                'default' => esc_html__( 'Get Started', 'uigigs' ),
                'placeholder' => esc_html__( 'Type button text here', 'uigigs' ),
                'label_block' => false,
            ]
        );

        $repeater->add_control(
            'button_link',
            [
                'label' => esc_html__( 'Link', 'uigigs' ),
                'type' => Controls_Manager::URL,
                'label_block' => true,
                'placeholder' => esc_html__( 'https://example.com/', 'uigigs' ),
                'dynamic' => [
                    'active' => true,
                ],
            ]
        );
        //Yearly Content
        $repeater->add_control(
            'yearly_options',
            [
                'label' => esc_html__( 'Yearly Pricing Here', 'uigigs' ),
                'type' => Controls_Manager::HEADING,
                'separator' => 'before',
            ]
        );
        $repeater->add_control(
			'image_icon_yearly',
			[
				'label'   => __( 'Icon Image', 'staco-core' ),
				'type'    => \Elementor\Controls_Manager::MEDIA,
				'default' => [
					'url' => \Elementor\Utils::get_placeholder_image_src(),
				],
			]
		);
        $repeater->add_control(
			'custom_icon_yearly',
			[
				'label'   => __( 'Custom Icon Image', 'staco-core' ),
				'type'    => \Elementor\Controls_Manager::MEDIA,
				'default' => [
					'url' => \Elementor\Utils::get_placeholder_image_src(),
				],
			]
		);
        $repeater->add_control(
            'title_yearly',
            [
                'label' => esc_html__( 'Title', 'uigigs' ),
                'type' => Controls_Manager::TEXT,
                'label_block' => false,
                'default' => esc_html__( 'Basic', 'uigigs' ),
            ]
        );
        $repeater->add_control(
            'price_yearly',
            [
                'label' => esc_html__( 'Price', 'uigigs' ),
                'type' => Controls_Manager::TEXT,
                'default' => esc_html__( '$59.00', 'uigigs' ),
            ]
        );
         $repeater->add_control(
            'yearly_title',
            [
                'label' => esc_html__( '/Year', 'uigigs' ),
                'type' => Controls_Manager::TEXT,
                'default' => 'Yearly',
            ]
        );
        $repeater->add_control(
            'description_yearly',
            [
                'label' => esc_html__( 'Description', 'uigigs' ),
                'type' => Controls_Manager::TEXT,
                'default' => esc_html__( 'Perfect for Prosonal', 'uigigs' ),               
            ]
        );
        $repeater->add_control(
            'price_subtitle_yearly',
            [
                'label' => esc_html__( 'Price Subtitle', 'uigigs' ),
                'type' => Controls_Manager::TEXT,
            ]
        );
        $repeater->add_control(
            'features_yearly',
            [
                'label'   => esc_html__( 'Features (Use List Style)', 'uigigs' ),
                'type'    => Controls_Manager::WYSIWYG,
                'rows'    => 10,
                'default' => esc_html__( '1 Users', 'uigigs' ),         
            ]
        );
        $repeater->add_control(
            'button_text_yearly',
            [
                'label' => esc_html__( 'Button Text', 'uigigs' ),
                'type' => Controls_Manager::TEXT,
                'default' => esc_html__( 'Get Started', 'uigigs' ),
                'placeholder' => esc_html__( 'Type button text here', 'uigigs' ),
                'label_block' => false,
            ]
        );
        $repeater->add_control(
            'button_link_yearly',
            [
                'label' => esc_html__( 'Link', 'uigigs' ),
                'type' => Controls_Manager::URL,
                'label_block' => true,
                'placeholder' => esc_html__( 'https://example.com/', 'uigigs' ),
                'dynamic' => [
                    'active' => true,
                ],
            ]
        );
        $this->add_control(
            'price_list',
            [
                'show_label' => false,
                'type' => Controls_Manager::REPEATER,
                'fields' => $repeater->get_controls(),
                'title_field' => '{{{ title }}}',
            ]
        ); 

        $this->end_controls_section();

        $this->start_controls_section(
            '_section_style_general',
            [
                'label' => esc_html__( 'Item Style', 'uigigs' ),
                'tab'   => Controls_Manager::TAB_STYLE,
            ]
        );
        $this->add_group_control(
            Group_Control_Background::get_type(),
            [
                'name' => 'background_color',
                'label' => esc_html__( 'Background', 'uigigs' ),
                'types' => [ 'classic', 'gradient' ],
                'selector' => '{{WRAPPER}} .pricing-wrapper > li',
            ]
        );

        $this->add_group_control(
            Group_Control_Box_Shadow::get_type(),
            [
                'name' => 'general_box_shadow',
                'exclude' => [
                    'box_shadow_position',
                ],
                'selector' => '{{WRAPPER}} .pricing-wrapper > li',
            ]
        );

        $this->add_responsive_control(
            'item_border_radius',
            [
                'label' => esc_html__( 'Border Radius', 'uigigs' ),
                'type' => Controls_Manager::DIMENSIONS,
                'size_units' => [ 'px', '%' ],
                'selectors' => [
                    '{{WRAPPER}} .pricing-card, {{WRAPPER}} .pricing-wrapper > li' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );

        $this->add_responsive_control(
            'item_padding',
            [
                'label' => esc_html__( 'Padding', 'uigigs' ),
                'type' => Controls_Manager::DIMENSIONS,
                'size_units' => [ 'px', 'em', '%' ],
                'selectors' => [
                    '{{WRAPPER}} .pricing-card' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );
        $this->add_group_control(
            Group_Control_Border::get_type(),
            [
                'name' => 'item_border',
                'selector' => '{{WRAPPER}} .pricing-card',
            ]
        );
        $this->add_control(
			'difference_color',
			[
				'label' => __('Difference Color', 'staco-core'),
				'type' => Controls_Manager::SELECT,
				'default' => 'no',
				'options' => [
					'yes' => __( 'Yes', 'staco-core' ),
					'no' => __( 'No', 'staco-core' ),
				],
				'label_block' => true,
			]
		);

        $this->add_control(
            'dif_color_title1',
            [
                'label' => esc_html__( 'Title Color 1', 'uigigs' ),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .price_list1 .pricing-card span.title' => 'color: {{VALUE}};',
                ],
                'condition' => ['difference_color' => ['yes']],
            ]
        );
        $this->add_control(
            'dif_color_title2',
            [
                'label' => esc_html__( 'Title Color 2', 'uigigs' ),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .price_list2 .pricing-card span.title' => 'color: {{VALUE}};',
                ],
                'condition' => ['difference_color' => ['yes']],
            ]
        );
        $this->add_control(
            'dif_color_title3',
            [
                'label' => esc_html__( 'Title Color 3', 'uigigs' ),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .price_list3 .pricing-card span.title' => 'color: {{VALUE}};',
                ],
                'condition' => ['difference_color' => ['yes']],
            ]
        );

        $this->add_control(
            'item_border1',
            [
                'label' => esc_html__( 'Border Color 1', 'uigigs' ),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .price_list1 .pricing-card' => 'border-color: {{VALUE}};',
                ],
                'condition'      => ['difference_color' => ['yes']],
            ]
        );
        $this->add_control(
            'item_border2',
            [
                'label' => esc_html__( 'Border Color 2', 'uigigs' ),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .price_list2 .pricing-card' => 'border-color: {{VALUE}};',
                ],
                'condition'      => ['difference_color' => ['yes']],
            ]
        );
        $this->add_control(
            'item_border3',
            [
                'label' => esc_html__( 'Border Color 3', 'uigigs' ),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .price_list3 .pricing-card' => 'border-color: {{VALUE}};',
                ],
                'condition'      => ['difference_color' => ['yes']],
            ]
        );

        $this->add_control(
            'dif_text_color1',
            [
                'label' => esc_html__( 'Text Color 1', 'uigigs' ),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .price_list1 .pricing-card-body, {{WRAPPER}} .price_list1 .pricing-card-header h3 span, {{WRAPPER}} .price_list1 .pricing-card-header h3, {{WRAPPER}} .price_list1 .pricing-card-header p' => 'color: {{VALUE}};',
                ],
                'condition' => ['difference_color' => ['yes']],
            ]
        );
        $this->add_control(
            'dif_text_color2',
            [
                'label' => esc_html__( 'Text Color 2', 'uigigs' ),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .price_list2 .pricing-card-body, {{WRAPPER}} .price_list2 .pricing-card-header h3 span, {{WRAPPER}} .price_list2 .pricing-card-header h3, {{WRAPPER}} .price_list2 .pricing-card-header p' => 'color: {{VALUE}};',
                ],
                'condition' => ['difference_color' => ['yes']],
            ]
        );
        $this->add_control(
            'dif_text_color3',
            [
                'label' => esc_html__( 'Text Color 3', 'uigigs' ),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .price_list3 .pricing-card-body, {{WRAPPER}} .price_list3 .pricing-card-header h3 span, {{WRAPPER}} .price_list3 .pricing-card-header h3, {{WRAPPER}} .price_list3 .pricing-card-header p' => 'color: {{VALUE}};',
                ],
                'condition' => ['difference_color' => ['yes']],
            ]
        );

        $this->add_control(
            'dif_bg_color1',
            [
                'label' => esc_html__( 'Background Color 1', 'uigigs' ),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .price_list1 .pricing-card' => 'background: {{VALUE}};',
                ],
                'condition' => ['difference_color' => ['yes']],
            ]
        );
        $this->add_control(
            'dif_bg_color2',
            [
                'label' => esc_html__( 'Background Color 2', 'uigigs' ),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .price_list2 .pricing-card' => 'background: {{VALUE}};',
                ],
                'condition' => ['difference_color' => ['yes']],
            ]
        );
        $this->add_control(
            'dif_bg_color3',
            [
                'label' => esc_html__( 'Background Color 3', 'uigigs' ),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .price_list3 .pricing-card' => 'background: {{VALUE}};',
                ],
                'condition' => ['difference_color' => ['yes']],
            ]
        );

        $this->add_control(
            'dif_btn_color1',
            [
                'label' => esc_html__( 'Button Background 1', 'uigigs' ),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .price_list1 .pricing-card .bg-blue-btn' => 'background: {{VALUE}};',
                ],
                'condition' => ['difference_color' => ['yes']],
            ]
        );
        $this->add_control(
            'dif_btn_color2',
            [
                'label' => esc_html__( 'Button Background 2', 'uigigs' ),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .price_list2 .pricing-card .bg-blue-btn' => 'background: {{VALUE}};',
                ],
                'condition' => ['difference_color' => ['yes']],
            ]
        );
        $this->add_control(
            'dif_btn_color3',
            [
                'label' => esc_html__( 'Button Background 3', 'uigigs' ),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .price_list3 .pricing-card .bg-blue-btn' => 'background: {{VALUE}};',
                ],
                'condition' => ['difference_color' => ['yes']],
            ]
        );
        $this->add_control(
            'dif_btn_border_color1',
            [
                'label' => esc_html__( 'Button Border-Color 1', 'uigigs' ),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .price_list1 .pricing-card .bg-blue-btn' => 'border-color: {{VALUE}};',
                ],
                'condition' => ['difference_color' => ['yes']],
            ]
        );
        $this->add_control(
            'dif_btn_border_color2',
            [
                'label' => esc_html__( 'Button Border-Color 2', 'uigigs' ),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .price_list2 .pricing-card .bg-blue-btn' => 'border-color: {{VALUE}};',
                ],
                'condition' => ['difference_color' => ['yes']],
            ]
        );
        $this->add_control(
            'dif_btn_border_color3',
            [
                'label' => esc_html__( 'Button Border-Color 3', 'uigigs' ),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .price_list3 .pricing-card .bg-blue-btn' => 'border-color: {{VALUE}};',
                ],
                'condition' => ['difference_color' => ['yes']],
            ]
        );

        $this->end_controls_section();

        $this->start_controls_section(
            '_section_style_months',
            [
                'label' => esc_html__( 'Monthly & Yearly Style', 'uigigs' ),
                'tab'   => Controls_Manager::TAB_STYLE,
            ]
        );

        $this->add_responsive_control(
			'alignment_menu',
			[
				'label'     => __( 'Alignment', 'staco-core' ),
				'type'      => Controls_Manager::CHOOSE,
				'options'   => [
					'flex-start'   => [
						'title' => __( 'Left', 'staco-core' ),
						'icon'  => 'eicon-text-align-left',
					],
					'center' => [
						'title' => __( 'Center', 'staco-core' ),
						'icon'  => 'eicon-text-align-center',
					],
					'flex-end'  => [
						'title' => __( 'Right', 'staco-core' ),
						'icon'  => 'eicon-text-align-right',
					],
				],
				'selectors' => [
					'{{WRAPPER}} .pricing-selector' => 'justify-content: {{VALUE}};',
				],
				'separator' => 'before',
			]
		);

        $this->add_group_control(
            Group_Control_Background::get_type(),
            [
                'name' => 'background_colors_fie',
                'label' => esc_html__( 'Background', 'uigigs' ),
                'types' => [ 'classic', 'gradient' ],
                'selector' => '{{WRAPPER}} .pricing-switcher .fieldset',
            ]
        );

        $this->add_control(
            'switcher_bg_color',
            [
                'label' => esc_html__( 'Background Color (Switcher)', 'uigigs' ),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .pricing-switcher .switch' => 'background-color: {{VALUE}};',
                ],
            ]
        );

        $this->add_control(
            'switcher_normal_color',
            [
                'label' => esc_html__( 'Switcher Color (Normal)', 'uigigs' ),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .pricing-selector form button:not(.pricing-yearly-btn span), {{WRAPPER}} .pricing-switcher label' => 'color: {{VALUE}};',
                ],
            ]
        );

        $this->add_control(
            'switcher_border_color',
            [
                'label' => esc_html__( 'Switcher Border Color', 'uigigs' ),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .pricing-selector form input[type="checkbox"]' => 'border-color: {{VALUE}};',
                ],
            ]
        );

        $this->add_control(
            'switcher_active_color',
            [
                'label' => esc_html__( 'Switcher Color (Active)', 'uigigs' ),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .pricing-selector form button span, {{WRAPPER}} .pricing-switcher .fieldset.mnt-ac .rs-mnt, .pricing-switcher .fieldset.mnt-acs .rs-yrs' => 'color: {{VALUE}} !important;',
                ],
            ]
        );

        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'name' => 'switcher_typography',
                'label' => esc_html__( 'Typography', 'uigigs' ),
                'selector' => '{{WRAPPER}} .pricing-switcher label',
            ]
        );

        $this->add_responsive_control(
            'year_padding',
            [
                'label' => esc_html__( 'Padding', 'uigigs' ),
                'type' => Controls_Manager::DIMENSIONS,
                'size_units' => [ 'px', 'em', '%' ],
                'selectors' => [
                    '{{WRAPPER}} .pricing-switcher .fieldset' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );
        $this->add_responsive_control(
            'price_margin',
            [
                'label' => esc_html__( 'Area Margin', 'uigigs' ),
                'type' => Controls_Manager::DIMENSIONS,
                'size_units' => [ 'px', 'em', '%' ],
                'selectors' => [
                    '{{WRAPPER}} .pricing-selector' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );
        $this->add_responsive_control(
            'top_area_margin',
            [
                'label' => esc_html__( 'Area Padding', 'uigigs' ),
                'type' => Controls_Manager::DIMENSIONS,
                'size_units' => [ 'px', 'em', '%' ],
                'selectors' => [
                    '{{WRAPPER}} .pricing-section' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );
        $this->end_controls_section();


        $this->start_controls_section(
            '_section_style_header',
            [
                'label' => esc_html__( 'Header Style', 'uigigs' ),
                'tab'   => Controls_Manager::TAB_STYLE,
            ]
        );

        $this->add_control(
            'headtitle_color',
            [
                'label' => esc_html__( 'Title Color', 'uigigs' ),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .pricing-card h2' => 'color: {{VALUE}};',
                ],
            ]
        );
        $this->add_responsive_control(
            'title_paddings',
            [
                'label' => esc_html__( 'Padding', 'uigigs' ),
                'type' => Controls_Manager::DIMENSIONS,
                'size_units' => [ 'px', 'em', '%' ],
                'selectors' => [
                    '{{WRAPPER}} .rs-pricing-container .pricing-header' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );
        $this->add_responsive_control(
            'title_margin',
            [
                'label' => esc_html__( 'Margin', 'uigigs' ),
                'type' => Controls_Manager::DIMENSIONS,
                'size_units' => [ 'px', 'em', '%' ],
                'selectors' => [
                    '{{WRAPPER}} .pricing-card h2, {{WRAPPER}} .pricing-card-title, {{WRAPPER}} .rs-pricing-container .pricing-header' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );

        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [   
                'label' => esc_html__( 'Title Typography', 'uigigs' ),
                'name' => 'title_typography',
                'selector' => '{{WRAPPER}} .pricing-card h2',
            ]
        );

        $this->add_control(
            'price_color',
            [
                'label' => esc_html__( 'Price Color', 'uigigs' ),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .pricing-card h3' => 'color: {{VALUE}};',
                ],
            ]
        );

        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [   
                'label' => esc_html__( 'Price Typography', 'uigigs' ),
                'name' => 'price_typography',
                'selector' => '{{WRAPPER}} .pricing-card h3',
            ]
        );
        $this->add_control(
            'price_month',
            [
                'label' => esc_html__( 'Month Color', 'uigigs' ),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .pricing-card h3 span' => 'color: {{VALUE}};',
                ],
            ]
        );

        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [   
                'label' => esc_html__( 'Month Typography', 'uigigs' ),
                'name' => 'Month_typography',
                'selector' => '{{WRAPPER}} .pricing-card h3 span',
            ]
        );

        

        $this->add_control(
            'short_desc_margin',
            [
                'label' => esc_html__( 'Margin', 'uigigs' ),
                'type' => Controls_Manager::DIMENSIONS,
                'selectors' => [
                    '{{WRAPPER}} .rs-pricing-container .pricing-header' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );

        $this->add_control(
            'heading_border',
            [
                'label' => esc_html__( 'Border Color', 'uigigs' ),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .rs-pricing-container .pricing-header:after' => 'background: {{VALUE}}; opacity:1;',
                ],
            ]
        );

        $this->end_controls_section();

        $this->start_controls_section(
            '_section_style_body',
            [
                'label' => esc_html__( 'Pricing Body Style', 'uigigs' ),
                'tab'   => Controls_Manager::TAB_STYLE,
            ]
        );

        $this->add_control(
            'custom_icon_margin',
            [
                'label' => esc_html__( 'Icon Image Margin', 'uigigs' ),
                'type' => Controls_Manager::DIMENSIONS,
                'selectors' => [
                    '{{WRAPPER}} .custom-icon' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );

        $this->add_control(
            'des_list_color',
            [
                'label' => esc_html__( 'Description Color', 'uigigs' ),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .rs-pricing-container .pricing-body .description' => 'color: {{VALUE}}; opacity:1;',
                ],
            ]
        );

        $this->add_control(
            'des_list_margin',
            [
                'label' => esc_html__( 'Description Margin', 'uigigs' ),
                'type' => Controls_Manager::DIMENSIONS,
                'selectors' => [
                    '{{WRAPPER}} .pricing-card-header p' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );

        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [   
                'label' => esc_html__( 'Description Typography', 'uigigs' ),
                'name' => 'des_typography',
                'selector' => '{{WRAPPER}} .rs-pricing-container .pricing-body .description',
            ]
        );

        $this->add_control(
            'text_features_color',
            [
                'label' => esc_html__( 'Features Color', 'uigigs' ),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .pricing-card-body ul li' => 'color: {{VALUE}};',
                ],
            ]
        );

        $this->add_control(
            'icon_features_color',
            [
                'label' => esc_html__( 'Features Dots Color', 'uigigs' ),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .pricing-card-body ul li:before' => 'background-color: {{VALUE}};',
                ],
            ]
        );

        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [   
                'label' => esc_html__( 'Features Typography', 'uigigs' ),
                'name' => 'features_typography',
                'selector' => ' {{WRAPPER}} .pricing-card-body ul li',
            ]
        );
        $this->add_control(
            'item_fea_desc_margin',
            [
                'label' => esc_html__( 'Margin (Per Item)', 'uigigs' ),
                'type' => Controls_Manager::DIMENSIONS,
                'selectors' => [
                    '{{WRAPPER}} .pricing-card-body ul' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );
        $this->add_responsive_control(
            'body_padding',
            [
                'label' => esc_html__( 'Padding', 'uigigs' ),
                'type' => Controls_Manager::DIMENSIONS,
                'size_units' => [ 'px', 'em', '%' ],
                'selectors' => [
                    '{{WRAPPER}} .pricing-card-body ul li' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );

        

        $this->end_controls_section();



        $this->start_controls_section(
            '_section_style_button',
            [
                'label' => esc_html__( 'Button Style', 'uigigs' ),
                'tab' => Controls_Manager::TAB_STYLE,
            ]
        );

        $this->start_controls_tabs( '_tabs_button' );
        $this->start_controls_tab(
            '_tab_button_normal',
            [
                'label' => esc_html__( 'Normal', 'uigigs' ),
            ]
        );
        $this->add_control(
            'button_color',
            [
                'label' => esc_html__( 'Text Color', 'uigigs' ),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .bg-blue-btn span, {{WRAPPER}} .pricing-btn, {{WRAPPER}} .best-pricing-btn' => 'color: {{VALUE}};',
                ],
            ]
        );
        $this->add_group_control(
            \Elementor\Group_Control_Background::get_type(),
            [
                'name' => 'background__sd',
                'label' => __( 'Background Color', 'plugin-domain' ),
                'types' => [ 'classic', 'gradient' ],
                'selector' => '{{WRAPPER}} .bg-blue-btn, {{WRAPPER}} .pricing-btn, {{WRAPPER}} .best-pricing-btn',
            ]
        );

        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'name' => 'button_typography',
                'selector' => '{{WRAPPER}} .bg-blue-btn, {{WRAPPER}} .pricing-btn, {{WRAPPER}} .best-pricing-btn',
            ]
        );

        $this->add_group_control(
            Group_Control_Border::get_type(),
            [
                'name' => 'button_border',
                'selector' => '{{WRAPPER}} .bg-blue-btn, {{WRAPPER}} .pricing-btn, {{WRAPPER}} .best-pricing-btn',
            ]
        );

        $this->add_control(
            'button_border_radius',
            [
                'label' => esc_html__( 'Border Radius', 'uigigs' ),
                'type' => Controls_Manager::DIMENSIONS,
                'size_units' => [ 'px', '%' ],
                'selectors' => [
                    '{{WRAPPER}} .bg-blue-btn, {{WRAPPER}} .pricing-btn, {{WRAPPER}} .best-pricing-btn' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );

        $this->add_group_control(
            Group_Control_Box_Shadow::get_type(),
            [
                'name' => 'button_box_shadow',
                'selector' => '{{WRAPPER}} .bg-blue-btn, {{WRAPPER}} .pricing-btn, {{WRAPPER}} .best-pricing-btn',
            ]
        );

        $this->add_responsive_control(
            'button_margin',
            [
                'label' => esc_html__( 'Margin', 'uigigs' ),
                'type' => Controls_Manager::DIMENSIONS,
                'size_units' => [ 'px', 'em', '%' ],
                'selectors' => [
                    '{{WRAPPER}} .bg-blue-btn, {{WRAPPER}} .pricing-btn, {{WRAPPER}} .best-pricing-btn' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );

        $this->add_responsive_control(
            'button_padding',
            [
                'label' => esc_html__( 'Padding', 'uigigs' ),
                'type' => Controls_Manager::DIMENSIONS,
                'size_units' => [ 'px', 'em', '%' ],
                'selectors' => [
                    '{{WRAPPER}} .bg-blue-btn, {{WRAPPER}} .pricing-btn, {{WRAPPER}} .best-pricing-btn' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );  
       $this->add_responsive_control(
            'btn_width',
            [
                'label' => esc_html__(' Width', 'staco'),
                'type' => Controls_Manager::SLIDER,
                'size_units' => ['px', '%'],
                'range' => [
                    'px' => [
                        'min' => 1,
                        'max' => 2000,
                    ],
                    '%' => [
                        'min' => 1,
                        'max' => 100,
                    ],
                ],
                'selectors' => [
                    '{{WRAPPER}} .bg-blue-btn, {{WRAPPER}} .pricing-btn, {{WRAPPER}} .best-pricing-btn' => 'width: {{SIZE}}{{UNIT}};',
                ],
            ]
        );

        $this->end_controls_tab();

        $this->start_controls_tab(
            '_tab_button_hover',
            [
                'label' => esc_html__( 'Active & Hover', 'uigigs' ),
            ]
        );

        $this->add_control(
            'button_hover_color',
            [
                'label' => esc_html__( 'Text Color', 'uigigs' ),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .bg-blue-btn:hover, {{WRAPPER}} .yes .best-pricing-btn, {{WRAPPER}} .pricing-btn:hover, {{WRAPPER}} .best-pricing-btn:hover' => 'color: {{VALUE}};',
                ],
            ]
        );


        $this->add_group_control(
            Group_Control_Border::get_type(),
            [
                'name' => 'button_hover_border',
                'selector' => '{{WRAPPER}} .yes .best-pricing-btn, {{WRAPPER}} .pricing-btn:hover, {{WRAPPER}} .best-pricing-btn:hover',
            ]
        );

        $this->add_group_control(
            Group_Control_Box_Shadow::get_type(),
            [
                'name' => 'button_hover_box_shadow',
                'selector' => '{{WRAPPER}} .bg-blue-btn:hover,{{WRAPPER}} .yes .best-pricing-btn, {{WRAPPER}} .pricing-btn:hover, {{WRAPPER}} .best-pricing-btn:hover',
            ]
        );

        $this->add_group_control(
            \Elementor\Group_Control_Background::get_type(),
            [
                'name' => 'background_btn_hover',
                'label' => __( 'Background Color', 'plugin-domain' ),
                'types' => [ 'classic', 'gradient' ],
                'selector' => '{{WRAPPER}} .bg-blue-btn:hover,{{WRAPPER}} .yes .best-pricing-btn, {{WRAPPER}} .pricing-btn:hover, {{WRAPPER}} .best-pricing-btn:hover',
            ]
        );
        $this->end_controls_tab();
        $this->end_controls_tabs();
        $this->end_controls_section();
    }

    protected function render() {
		$data     = $this->get_settings();
		$template = 'view';
		if ( 'style2' == $data['layout'] ) {
			$template = 'view-2';
		}
		$this->rt_template( $template, $data );
	}

}