<?php
/**
 * @author  UiGigs
 * @since   1.0
 * @version 1.0
 */
// namespace UiGigs\Staco_Core;
use UiGigs\staco\Helper;  ?>

<!-- best pricing section start -->
<section class="best-pricing-sections">
    <div class="row">
        <div class="col-md-12">
            <div class="best-pricing-selector">
                <form action="/" method="post">
                    <button type="button" class="best-pricing-monthly-btn"><?php echo wp_kses_post($data['monthly_title']);?></button>
                    <input type="checkbox" name="best-pricing-selector" id="best-pricing-selector">
                    <button type="button" class="best-pricing-yearly-btn"><?php echo wp_kses_post($data['yearly_title']);?> <span><?php echo wp_kses_post($data['yearly_discount']);?></span></button>
                </form>
            </div>
        </div>
    </div>
    <div class="row">
        <div class="col-md-12">
            <div class="best-pricing-grid monthly">
             <?php foreach ( $data['price_list'] as $items => $item ) { 
                    $title          = !empty($item['title']) ? $item['title'] : '';                            
                    $price          = !empty($item['price']) ? $item['price'] : '';                            
                    $description    = !empty($item['description']) ? $item['description'] : '';                            
                    $features       = !empty($item['features']) ? $item['features'] : '';                            
                    $most_popular   = !empty($item['most_popular']) ? $item['most_popular'] : '';                            
                    $button_text    = !empty($item['button_text']) ? $item['button_text'] : '';                            
                    $image_icon     = !empty($item['image_icon']) ? $item['image_icon'] : '';                            
                    $custom_icon     = !empty($item['custom_icon']) ? $item['custom_icon'] : '';                                        
                    $target         = !empty($item['button_link']['is_external']) ? 'target=_blank' : '';  
                    $button_link    = !empty($item['button_link']['url']) ? $item['button_link']['url'] : '';
                    $title_yearly           = !empty($item['title_yearly']) ? $item['title_yearly'] : '';                            
                    $price_yearly           = !empty($item['price_yearly']) ? $item['price_yearly'] : '';                            
                    $description_yearly     = !empty($item['description_yearly']) ? $item['description_yearly'] : '';
                    $features_yearly        = !empty($item['features_yearly']) ? $item['features_yearly'] : '';                            
                    $button_text_yearly     = !empty($item['button_text_yearly']) ? $item['button_text_yearly'] : '';       
                    $target                 = !empty($item['button_link_yearly']['is_external']) ? 'target=_blank' : '';  
                    $button_link_yearly     = !empty($item['button_link_yearly']['url']) ? $item['button_link_yearly']['url'] : '';
                ?>   
                <div class="best-pricing-card <?php if(!empty($item['most_popular'])){ echo "active"; } ?>">
                    <?php if(!empty($item['most_popular'])){?>
                    <div class="overlay">
                        <p><?php echo wp_kses_post ($most_popular);?></p>
                    </div>
                    <?php } ?>   
                    <div class="best-pricing-card-header">
                        <div class="best-pricing-card-title">
                            <h2><?php echo wp_kses_post ($title);?></h2>
                           <?php echo wp_get_attachment_image( $item['image_icon']['id'], 'full' ); ?>
                        </div>
                        <p><?php echo wp_kses_post ($description);?></p>
                        <?php if(!empty($price)){ ?>    
                            <h3><?php echo wp_kses_post ($price);?> <span><?php echo esc_html__('/month', 'staco-core');?></span></h3>
                        <?php } ?>
                        <?php echo wp_get_attachment_image( $item['custom_icon']['id'], 'full' ); ?>
                    </div>
                    <div class="best-pricing-card-body">
                        <?php if($button_text){?>
                            <a class="start-free-btn" href="<?php echo wp_kses_post ($button_link);?>"><?php echo esc_attr ($button_text);?></a>
                        <?php } ?>    
                        <?php echo wp_kses_post ($features);?>
                    </div>
                </div>
                <?php } ?>
            </div>
            <div class="best-pricing-grid yearly">
                <?php foreach ( $data['price_list'] as $items => $item ) { 
                    $title          = !empty($item['title']) ? $item['title'] : '';                            
                    $price          = !empty($item['price']) ? $item['price'] : '';                            
                    $description    = !empty($item['description']) ? $item['description'] : '';  
                    $most_popular   = !empty($item['most_popular']) ? $item['most_popular'] : '';                          
                    $features       = !empty($item['features']) ? $item['features'] : '';                            
                    $button_text    = !empty($item['button_text']) ? $item['button_text'] : '';                            
                    $image_icon_yearly    = !empty($item['image_icon_yearly']) ? $item['image_icon_yearly'] : '';                            
                    $custom_icon_yearly    = !empty($item['custom_icon_yearly']) ? $item['custom_icon_yearly'] : '';                            
                    $target         = !empty($item['button_link']['is_external']) ? 'target=_blank' : '';  
                    $button_link    = !empty($item['button_link']['url']) ? $item['button_link']['url'] : '';
                    $title_yearly           = !empty($item['title_yearly']) ? $item['title_yearly'] : '';                            
                    $price_yearly           = !empty($item['price_yearly']) ? $item['price_yearly'] : '';                            
                    $description_yearly     = !empty($item['description_yearly']) ? $item['description_yearly'] : '';
                    $features_yearly        = !empty($item['features_yearly']) ? $item['features_yearly'] : '';                            
                    $button_text_yearly     = !empty($item['button_text_yearly']) ? $item['button_text_yearly'] : '';       
                    $target                 = !empty($item['button_link_yearly']['is_external']) ? 'target=_blank' : '';  
                    $button_link_yearly     = !empty($item['button_link_yearly']['url']) ? $item['button_link_yearly']['url'] : '';
                ?>  
                <div class="best-pricing-card <?php if(!empty($item['most_popular'])){ echo "active"; } ?>">
                    <?php if(!empty($item['most_popular'])){?>
                    <div class="overlay">
                        <p><?php echo wp_kses_post ($most_popular);?></p>
                    </div>
                    <?php } ?> 
                    <div class="best-pricing-card-header">
                        <div class="best-pricing-card-title">
                            <h2><?php echo esc_attr ($title_yearly);?></h2>
                            <?php echo wp_get_attachment_image( $item['image_icon_yearly']['id'], 'full' ); ?>
                        </div>
                        <p><?php echo wp_kses_post ($description_yearly);?></p>

                        <?php if(!empty($price_yearly)){ ?>
                        <h3><?php echo esc_attr ($price_yearly);?> <span><?php echo esc_html__('/year', 'staco-core');?></span></h3>
                        <?php } ?> 

                        <?php echo wp_get_attachment_image( $item['custom_icon_yearly']['id'], 'full' ); ?>


                    </div>
                    <div class="best-pricing-card-body">
                        <?php if($button_text_yearly){?>
                            <a class="start-free-btn" href="<?php echo wp_kses_post ($button_link_yearly);?>"><?php echo esc_attr ($button_text_yearly);?></a>
                        <?php } ?>    
                        <?php echo wp_kses_post ($features_yearly);?>
                    </div>
                </div> 
                <?php } ?>
            </div>
        </div>
    </div>
</section>
<!-- best pricing section end -->








