<?php
/**
 * @author  UiGigs
 * @since   1.0
 * @version 1.0
 */

namespace UiGigs\Staco_Core;

use Elementor\Controls_Manager;

if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

class Roadmap_Box extends Custom_Widget_Base {

	public function __construct( $data = [], $args = null ) {
		$this->rt_name = esc_html__( 'Roadmap Box', 'staco-core' );
		$this->rt_base = 'staco-roadmap-box';
		parent::__construct( $data, $args );
	}

	protected function register_controls() {
		$this->start_controls_section(
			'roadmap_box_section',
			[
				'label' => esc_html__( 'Content', 'staco-core' ),
				'tab'   => Controls_Manager::TAB_CONTENT,
			]
		);

		$this->add_control(
			'icon',
			[
				'label' => esc_html__( 'Icon', 'plugin-name' ),
				'type' => \Elementor\Controls_Manager::ICONS,
				'default' => [
					'value' => 'far fa-circle',
					'library' => 'fa-solid',
				],
				'recommended' => [
					'fa-solid' => [
						'circle',
						'dot-circle',
						'square-full',
					],
					'fa-regular' => [
						'circle',
						'dot-circle',
						'square-full',
					],
				],
			]
		);

		$this->add_control(
			'title', [
				'label'       => __( 'Title', 'staco-core' ),
				'type'        => \Elementor\Controls_Manager::TEXT,
				'default'     => '80% Sold out',
				'label_block' => true,
			]
		);

		$this->add_control(
			'desc', [
				'label'       => __( 'Description', 'staco-core' ),
				'type'        => \Elementor\Controls_Manager::TEXTAREA,
				'default'     => __( 'On the other hand, we denounce with righteous indignation and dislike men', 'staco-core' ),
				'label_block' => true,
				'rows'        => 4,
			]
		);

		$this->end_controls_section();

		// Title Settings
		//============================================

		$this->start_controls_section(
			'section_style_title',
			[
				'label'     => __( 'Title', 'staco-core' ),
				'tab'       => Controls_Manager::TAB_STYLE
			]
		);
		$this->add_control(
			'title_color',
			[
				'label'     => __( 'Title Color', 'staco-core' ),
				'type'      => Controls_Manager::COLOR,
				'default'   => '#00FFA3',
				'selectors' => [
					'{{WRAPPER}} .v2_roadmap_card h3' => 'color: {{VALUE}};',
				],
			]
		);
		$this->add_group_control(
			\Elementor\Group_Control_Typography::get_type(),
			[
				'name'     => 'title_typography',
				'label'    => __( 'Typography', 'staco-core' ),
				'selector' => '{{WRAPPER}} .v2_roadmap_card h3',
			]
		);
		$this->end_controls_section();

		// Icon Settings
		//============================================
		$this->start_controls_section(
			'section_style_icon',
			[
				'label'     => __( 'Icon', 'staco-core' ),
				'tab'       => Controls_Manager::TAB_STYLE
			]
		);

		$this->add_control(
			'icon_size',
			[
				'label' => esc_html__( 'Size', 'staco-core' ),
				'type' => \Elementor\Controls_Manager::SLIDER,
				'size_units' => [ 'px', '%' ],
				'range' => [
					'px' => [
						'min' => 10,
						'max' => 30,
						'step' => 1,
					],
					'%' => [
						'min' => 50,
						'max' => 100,
					],
				],
				'default' => [
					'unit' => 'px',
					'size' => 14,
				],
				'selectors' => [
					'{{WRAPPER}} .v2_roadmap_card h3 i' => 'font-size: {{SIZE}}{{UNIT}};',
				],
			]
		);

		$this->add_control(
			'icon_color',
			[
				'label'     => __( 'Icon Color', 'staco-core' ),
				'type'      => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .v2_roadmap_card h3 i' => 'color: {{VALUE}};',
				],
			]
		);

		$this->end_controls_section();

		// Description Settings
		//============================================
		$this->start_controls_section(
			'section_style_desc',
			[
				'label'     => __( 'Description', 'staco-core' ),
				'tab'       => Controls_Manager::TAB_STYLE
			]
		);

		$this->add_control(
			'desc_color',
			[
				'label'     => __( 'Description Color', 'staco-core' ),
				'type'      => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .v2_roadmap_card p' => 'color: {{VALUE}};',
				],
			]
		);

		$this->add_group_control(
			\Elementor\Group_Control_Typography::get_type(),
			[
				'name'     => 'desc_typography',
				'label'    => __( 'Typography', 'staco-core' ),
				'selector' => '{{WRAPPER}} .v2_roadmap_card p',
			]
		);

		$this->end_controls_section();

		// Box Settings
		//============================================
		$this->start_controls_section(
			'section_style_box',
			[
				'label'     => __( 'Box', 'staco-core' ),
				'tab'       => Controls_Manager::TAB_STYLE
			]
		);

		$this->add_control(
			'box_bg',
			[
				'label'     => __( 'Background', 'staco-core' ),
				'type'      => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .v2_roadmap_card' => 'background-color: {{VALUE}};',
					'{{WRAPPER}} .v2_roadmap_card_sect .v2_roadmap_card_box' => 'background-color: {{VALUE}};',
				],
			]
		);
		$this->add_responsive_control(
			'box_margin',
			[
				'label'      => __( 'Margin', 'staco-core' ),
				'type'       => Controls_Manager::DIMENSIONS,
				'size_units' => [ 'px', '%' ],
				'selectors'  => [
					'{{WRAPPER}} .v2_roadmap_card' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}}',
				],
			]
		);
		$this->add_responsive_control(
			'box_padding',
			[
				'label'      => __( 'Padding', 'staco-core' ),
				'type'       => Controls_Manager::DIMENSIONS,
				'size_units' => [ 'px', '%' ],
				'selectors'  => [
					'{{WRAPPER}} .v2_roadmap_card' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}}',
				],
			]
		);

		$this->end_controls_section();
	}

	protected function render() {
		$data = $this->get_settings();
		$template = 'view';
		$this->rt_template( $template, $data );
	}

}