<?php
/**
 * @author  UiGigs
 * @since   1.0
 * @version 1.0
 */

namespace UiGigs\Staco_Core;

use Elementor\Controls_Manager;

if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

class Roadmap extends Custom_Widget_Base {

	public function __construct( $data = [], $args = null ) {
		$this->rt_name = esc_html__( 'Roadmap Slider', 'staco-core' );
		$this->rt_base = 'staco-roadmap';
		parent::__construct( $data, $args );
	}

	protected function register_controls() {
		$this->start_controls_section(
			'section_slider',
			[
				'label' => __( 'Slider Items', 'staco-core' ),
			]
		);

		$repeater = new \Elementor\Repeater();

		$repeater->add_control(
			'slider_image',
			[
				'label'   => __( 'Image', 'staco-core' ),
				'type'    => \Elementor\Controls_Manager::MEDIA,
				'default' => [
					'url' => \Elementor\Utils::get_placeholder_image_src(),
				],
			]
		);

		$repeater->add_control(
			'title', [
				'label'       => __( 'Title', 'staco-core' ),
				'type'        => \Elementor\Controls_Manager::TEXTAREA,
				'default'     => '80% Sold out',
				'label_block' => true,
				'rows'        => 2,
			]
		);

		$repeater->add_control(
			'subtitle', [
				'label'       => __( 'Sub title', 'staco-core' ),
				'type'        => \Elementor\Controls_Manager::TEXT,
				'default'     => __( 'PHASE 01', 'staco-core' ),
				'label_block' => true,
				'rows'        => 4,
			]
		);

		$repeater->add_control(
			'desc', [
				'label'       => __( 'Description', 'staco-core' ),
				'type'        => \Elementor\Controls_Manager::TEXTAREA,
				'default'     => __( 'On the other hand, we denounce with righteous indignation and dislike men', 'staco-core' ),
				'label_block' => true,
				'rows'        => 4,
			]
		);

		$this->add_control(
			'roadmaps',
			[
				'label'       => esc_html__( 'Road Map Slide', 'staco-core' ),
				'type'        => \Elementor\Controls_Manager::REPEATER,
				'fields'      => $repeater->get_controls(),
				'default'     => [
					[
						'title'    => esc_html__( '80% Sold out', 'staco-core'),
						'subtitle' => esc_html__( 'Phase 01', 'staco-core' ),
						'desc'     => esc_html__( 'Reproduced below for those interested. Sections 1.10.32 and 1.10.33 from "de Finibus Bonorum et Malorum" by Cicero are also reproduced.', 'staco-core' ),
					],
					[
						'title'    => esc_html__( '80% Sold out', 'staco-core'),
						'subtitle' => esc_html__( 'Phase 02', 'staco-core' ),
						'desc' 	   => esc_html__( 'Reproduced below for those interested. Sections 1.10.32 and 1.10.33 from "de Finibus Bonorum et Malorum" by Cicero are also reproduced.', 'staco-core' ),
					],
				],
				'title_field' => '{{{ title }}}'
			]
		);

		$this->end_controls_section();


		// Additional Options
		//============================================================
		$this->start_controls_section(
			'section_additional_options',
			[
				'label' => __( 'Slider Options', 'staco-core' ),
			]
		);

		$this->add_control(
			'autoplay',
			[
				'label'   => __( 'Autoplay', 'staco-core' ),
				'type'    => Controls_Manager::SWITCHER,
				'label'       => esc_html__( 'Autoplay', 'evacon-core' ),
				'label_on'    => esc_html__( 'On', 'evacon-core' ),
				'label_off'   => esc_html__( 'Off', 'evacon-core' ),
				'description' => esc_html__( 'Enable or disable autoplay. Default: On', 'evacon-core' ),
			]
		);

		$this->add_control(
			'autoplay_speed',
			[
				'label'       => __( 'Autoplay Speed', 'staco-core' ),
				'type'        => Controls_Manager::NUMBER,
				'default'     => 5000,
				'condition'   => [
					'autoplay' => 'yes',
				],
				'render_type' => 'none',
			]
		);

		$this->add_responsive_control(
			'spaceBetween',
			[
				'label'     => __( 'Space Between', 'staco-core' ),
				'type'      => Controls_Manager::NUMBER,
				'default'   => 30,
			]
		);

		$this->add_responsive_control(
			'slidesPerView',
			[
				'label'              => __( 'Slides Per View', 'staco-core' ),
				'type'               => Controls_Manager::NUMBER,
				'default'            => 4,
			]
		);
		$this->add_responsive_control(
			'col_lg',
			[
				'label'              => __( 'Desktop > 1024', 'staco-core' ),
				'type'               => Controls_Manager::NUMBER,
				'default'            => 4,
				'frontend_available' => true,
			]
		);
		$this->add_responsive_control(
			'col_md',
			[
				'label'              => __( 'Tab > 768', 'staco-core' ),
				'type'               => Controls_Manager::NUMBER,
				'default'            => 3,
				'frontend_available' => true,
			]
		);
		$this->add_responsive_control(
			'col_sm',
			[
				'label'              => __( 'Phone > 576', 'staco-core' ),
				'type'               => Controls_Manager::NUMBER,
				'default'            => 2,
				'frontend_available' => true,
			]
		);
		$this->add_responsive_control(
			'col_xs',
			[
				'label'              => __( 'Samll Phone > 0', 'staco-core' ),
				'type'               => Controls_Manager::NUMBER,
				'default'            => 1,
				'frontend_available' => true,
			]
		);

		$this->end_controls_section();

		// Title Settings
		//============================================

		$this->start_controls_section(
			'section_style_title',
			[
				'label'     => __( 'Title Settings', 'staco-core' ),
				'tab'       => Controls_Manager::TAB_STYLE
			]
		);
		$this->add_control(
			'title_color',
			[
				'label'     => __( 'Title Color', 'staco-core' ),
				'type'      => Controls_Manager::COLOR,
				'default'   => '#ffffff',
				'selectors' => [
					'{{WRAPPER}} .v1_roadmap_contents_text h3' => 'color: {{VALUE}};',
				],
			]
		);
		$this->add_group_control(
			\Elementor\Group_Control_Typography::get_type(),
			[
				'name'     => 'title_typography',
				'label'    => __( 'Typography', 'staco-core' ),
				'selector' => '{{WRAPPER}} .v1_roadmap_contents_text h3',
			]
		);
		$this->end_controls_section();


		// Subtitle Settings
		//============================================
		$this->start_controls_section(
			'section_style_subtitle',
			[
				'label'     => __( 'Sub Title Settings', 'staco-core' ),
				'tab'       => Controls_Manager::TAB_STYLE
			]
		);
		$this->add_control(
			'subtitle_color',
			[
				'label'     => __( 'Sub Title Color', 'staco-core' ),
				'type'      => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .v1_roadmap_contents_text h5' => 'color: {{VALUE}};',
				],
			]
		);
		$this->add_group_control(
			\Elementor\Group_Control_Typography::get_type(),
			[
				'name'     => 'subtitle_typography',
				'label'    => __( 'Typography', 'staco-core' ),
				'selector' => '{{WRAPPER}} .v1_roadmap_contents_text h5',
			]
		);
		$this->end_controls_section();

		// Description Settings
		//============================================
		$this->start_controls_section(
			'section_style_desc',
			[
				'label'     => __( 'Description Settings', 'staco-core' ),
				'tab'       => Controls_Manager::TAB_STYLE
			]
		);
		$this->add_control(
			'desc_color',
			[
				'label'     => __( 'Description Color', 'staco-core' ),
				'type'      => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .v1_roadmap_contents_text p' => 'color: {{VALUE}};',
				],
			]
		);
		$this->add_group_control(
			\Elementor\Group_Control_Typography::get_type(),
			[
				'name'     => 'desc_typography',
				'label'    => __( 'Typography', 'staco-core' ),
				'selector' => '{{WRAPPER}} .v1_roadmap_contents_text p',
			]
		);
		$this->end_controls_section();
	}
	public function swiper(){
		// wp_enqueue_style( 'swiper' );
		wp_enqueue_script( 'swiper-min' );
		wp_enqueue_script( 'swiper-func' );	
	}
	protected function render() {
		$data = $this->get_settings();
		$this->swiper();
		$swiper_data = array(
			'col_xl'   		=> absint($data['slidesPerView']),
			'spaceBetween'  => absint($data['spaceBetween']),
			'autoplay' 		=> $data['autoplay'] == 'yes' ? true : false,
			'autoplayspeed' => $data['autoplay_speed'],
			'col_lg'  		=> absint($data['col_lg']),
			'col_md'  		=> absint($data['col_md']),
			'col_sm'  		=> absint($data['col_sm']),
			'col_xs'  		=> absint($data['col_xs']),
		);
		$data['swiper_data'] = json_encode( $swiper_data );

		$template = 'view';
		$this->rt_template( $template, $data );
	}

}