<?php
/**
 * @author  UiGigs
 * @since   1.0
 * @version 1.0
 */

namespace UiGigs\Staco_Core;
use Elementor\Controls_Manager;

if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

class rotateIcon extends Custom_Widget_Base {

	public function __construct( $data = [], $args = null ) {
		$this->rt_name = esc_html__( 'Rotate Icon', 'staco-core' );
		$this->rt_base = 'staco-rotateicon';
		parent::__construct( $data, $args );
	}

	protected function register_controls() {
		$this->start_controls_section(
			'section_title',
			[
				'label' => esc_html__('Rotate Icon', 'staco-core'),
				'tab' => Controls_Manager::TAB_CONTENT,
			]
		);
		$this->add_control(
			'layout',
			[
				'label' => __('Layout Type', 'staco-core'),
				'type' => Controls_Manager::SELECT,
				'default' => 'style1',
				'options' => [
					'style1' => __( 'Defualt Style', 'staco-core' ),
					'style2' => __( 'Reverse Style', 'staco-core' ),
				],
				'label_block' => true,
			]
		);

		
		$this->add_control(
			'image',
			[
				'label' => esc_html__('Image', 'scaddon'),
				'type' => Controls_Manager::MEDIA,
				'separator' => 'before',
			]
		);
		$this->add_control(
			'image_icon',
			[
				'label' => esc_html__('Icon Image', 'scaddon'),
				'type' => Controls_Manager::MEDIA,
				'separator' => 'before',
			]
		);
		$this->add_control(
			'link',
			[
				'label_block' => true,
				'label' => esc_html__(' Link', 'scaddon'),
				'type' => Controls_Manager::TEXT,
				'placeholder' => esc_html__('#', 'scaddon'),
			]
		);
		$this->end_controls_section();
    }

	protected function render() {
		$data     = $this->get_settings();
		$template = 'view';
		$this->rt_template( $template, $data );
	}

}