<?php
/**
 * @author  UiGigs
 * @since   1.0
 * @version 1.0
 */

namespace UiGigs\Staco_Core;
use Elementor\Repeater;
use Elementor\Group_Control_Typography;
use Elementor\Controls_Manager;

if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

class scrollLogo extends Custom_Widget_Base {

	public function __construct( $data = [], $args = null ) {
		$this->rt_name = esc_html__( 'Scroll Logo', 'staco-core' );
		$this->rt_base = 'scrollLogo';
		parent::__construct( $data, $args );
	}

	protected function register_controls() {
        

		$this->start_controls_section(
            '_section_price',
            [
                'label' => esc_html__( 'Scroll Logo 1', 'staco-core' ),
                'tab' => Controls_Manager::TAB_CONTENT,
            ]
        );
        
        $repeater = new Repeater();
        $repeater->add_control(
            'title',
            [
                'label' => esc_html__( 'Title', 'staco-core' ),
                'type' => Controls_Manager::TEXT,
            ]
        );
        $repeater->add_control(
			'image_icon',
			[
				'label'   => __( 'Icon Image', 'staco-core' ),
				'type'    => \Elementor\Controls_Manager::MEDIA,
				'default' => [
					'url' => \Elementor\Utils::get_placeholder_image_src(),
				],
			]
		);
        $this->add_control(
            'logo_list',
            [
                'show_label' => false,
                'type' => Controls_Manager::REPEATER,
                'fields' => $repeater->get_controls(),
                'title_field' => '{{{ title }}}',
            ]
        ); 
        $this->end_controls_section();

		$this->start_controls_section(
            '_section_price2',
            [
                'label' => esc_html__( 'Scroll Logo 2', 'staco-core' ),
                'tab' => Controls_Manager::TAB_CONTENT,
            ]
        );
        $repeater = new Repeater();
        $repeater->add_control(
            'title2',
            [
                'label' => esc_html__( 'Title', 'staco-core' ),
                'type' => Controls_Manager::TEXT,
            ]
        );

        $repeater->add_control(
			'image_icon2',
			[
				'label'   => __( 'Icon Image', 'staco-core' ),
				'type'    => \Elementor\Controls_Manager::MEDIA,
				'default' => [
					'url' => \Elementor\Utils::get_placeholder_image_src(),
				],
			]
		);
        $this->add_control(
            'logo_list2',
            [
                'show_label' => false,
                'type' => Controls_Manager::REPEATER,
                'fields' => $repeater->get_controls(),
                'title_field' => '{{{ title2 }}}',
            ]
        ); 
        $this->end_controls_section();

        


        

		/* = Box Settings
		==============================================================*/
		$this->start_controls_section(
			'logo_style',
			[
				'label' => esc_html__( 'Box Settings', 'staco-core' ),
				'tab'   => Controls_Manager::TAB_STYLE,
			]
		);
        $this->add_control(
			'layout',
			[
				'label' => __('Style', 'staco-core'),
				'type' => Controls_Manager::SELECT,
				'default' => 'style1',
				'options' => [
					'style1' => __( 'Style 1', 'staco-core' ),
					'style2' => __( 'Style 2', 'staco-core' ),
				],
			]
		);
        $this->add_control(
			'title_color',
			[
				'type'      => Controls_Manager::COLOR,
				'label'     => esc_html__( 'Color', 'staco-core' ),
				'selectors' => [
					'{{WRAPPER}} .index5-scroll-carousel-section ul li strong' => 'color: {{VALUE}}',
				],
			]
		);
        

        $this->add_group_control(
			Group_Control_Typography::get_type(),
			[
				'name'     => 'title_typo',
				'label'    => esc_html__( 'Typography', 'staco-core' ),
				'selector' => '{{WRAPPER}} .index5-scroll-carousel-section ul li strong',
			]
		);

        $this->add_control(
			'item_bg',
			[
				'type'      => Controls_Manager::COLOR,
				'label'     => esc_html__( 'Color', 'staco-core' ),
				'selectors' => [
					'{{WRAPPER}} .our-partners-list .item' => 'background: {{VALUE}}',
				],
                'condition'      => ['layout' => ['style2']],
			]
		);

        
        
        $this->end_controls_section();
    }
    protected function render() {
		$data     = $this->get_settings();
		$template = 'view';
		if ( 'style2' == $data['layout'] ) {
			$template = 'view-2';
		}
		$this->rt_template( $template, $data );
	}
}