<?php
/**
 * @author  UiGigs
 * @since   1.0
 * @version 1.0
 */

use Elementor\Icons_Manager; ?>



<div class="partners-logos">
    <?php if ($data['logo_list']) : ?>
    <div class="our-partners-list our-partners-list-left">
        <?php foreach ($data['logo_list'] as $list): ?>
            <div class="item"><?php echo wp_get_attachment_image( $list['image_icon']['id'], 'full' ); ?></div>
        <?php endforeach; ?>
    </div>
    <?php endif; ?>

    <?php if ($data['logo_list2']) : ?>        
    <div class="our-partners-list our-partners-list-right">
        <?php foreach ($data['logo_list2'] as $list): ?>
            <div class="item"><?php echo wp_get_attachment_image( $list['image_icon2']['id'], 'full' ); ?></div>
        <?php endforeach; ?>
    </div>
    <?php endif; ?>
</div>


<script>
    (function ($) {
    ("use strict");
        $(document).ready(function () {

        var partnersLogosLeft = $(".our-partners-list-left");
            if (partnersLogosLeft.length) {
                $(window).on("scroll", function () {
                    var cryptoBannerImg = $(".our-partners-list-left");
                    var y = window.scrollY;
                    var x;
                    x = cryptoBannerImg.offset().top;
                    x = x - 400;

                    let animationValue = 1;
                    animationValue = (y - x) / 8;            

                    let animationStop = 100;

                    if (animationValue < 0) {
                        animationValue > 0;
                    }

                    if (animationValue > animationStop) {
                        animationValue = animationStop;
                    }

                    cryptoBannerImg.css("transform", `translateX(${animationValue}px)`);
                });
            }
            /*-- our-partners-scroll-effect-js End --*/
            
            /*-- our-partners-scroll-effect-js start --*/
            var partnersLogosRight = $(".our-partners-list-right");
            if (partnersLogosRight.length) {
                $(window).on("scroll", function () {
                    var cryptoBannerImg = $(".our-partners-list-right");
                    var y = window.scrollY;
                    var x;
                    x = cryptoBannerImg.offset().top;
                    x = x - 400;

                    let animationValue = 1;
                    animationValue = (-1* (y - x)) / 8;

                    let animationStop = 100;

                    if (animationValue < 0) {
                        animationValue > 0;
                    }

                    if (animationValue > animationStop) {
                        animationValue = animationStop;
                    }

                    cryptoBannerImg.css("transform", `translateX(${animationValue}px)`);
                });
            }
            
        });
    })(jQuery);
</script>








