<?php
/**
 * @author  UiGigs
 * @since   1.0
 * @version 1.0
 */

use Elementor\Icons_Manager; ?>

<div class="index5-scroll-carousel-section">
    <?php if ($data['logo_list']) : ?>
    <ul class="slide-left">
        <?php foreach ($data['logo_list'] as $list): ?>
            <li>
                <span><?php echo wp_get_attachment_image( $list['image_icon']['id'], 'full' ); ?></span
                ><strong><?php echo wp_kses_post($list['title']) ?></strong>
            </li>
        <?php endforeach; ?>
    </ul>
    <?php endif; ?>

    <?php if ($data['logo_list2']) : ?>
    <ul class="slide-right"
        <?php foreach ($data['logo_list2'] as $list): ?>
            <li>
                <span><?php echo wp_get_attachment_image( $list['image_icon2']['id'], 'full' ); ?></span
                ><strong><?php echo wp_kses_post($list['title2']) ?></strong>
            </li>
        <?php endforeach; ?>
    </ul>
    <?php endif; ?>
</div>

<script>
    (function ($) {
    ("use strict");
        $(document).ready(function () {

        

         /*-- index5 img effect when scrolling scripts start --*/
    var hero5 = $(".index5-scroll-carousel-section");
    if (hero5.length) {
        $(window).on("scroll", function () {
            var indexVImg = $(".index5-scroll-carousel-section");
            var y = window.scrollY;
            var x;
            var heroVImg;
            x = indexVImg.offset().top;
            heroVImg = indexVImg.find(".index5-hero-img img");
            x = x - 400;

            console.log(y);
            console.log(x);

            let animationValue = 40;
            animationValue = (animationValue - (y - x)) / 5;

            let animationStop = 0;

            if (animationValue > 40) {
                animationValue = 40;
            }

            if (animationValue < animationStop) {
                animationValue = animationStop;
            }

            if (y > x) {
                heroVImg.css("transform", `rotateX(${animationValue}deg)`);
            } else {
                heroVImg.css("transform", `rotateX(${animationValue}deg)`);
            }

            var scrollSlider = $(".index5-scroll-carousel-section");
            var z = scrollSlider.offset().top;
            z = z - 500;
            var val = (-1 * y) / 4;
            var val2 = y / 4;
            if (y > z) {
                $(".slide-left").css("transform", `translateX(${val}px)`);
                $(".slide-right").css("transform", `translateX(${val2}px)`);
            }
        });
    }
            
        });
    })(jQuery);
</script>








