<?php
/**
 * @author  UiGigs
 * @since   1.0
 * @version 1.0
 */
namespace UiGigs\Staco_Core;
use Elementor\Repeater;
use Elementor\Controls_Manager;
use Elementor\Group_Control_Border;
use Elementor\Group_Control_Box_Shadow;
use Elementor\Group_Control_Typography;
use Elementor\Group_Control_Background;

if ( ! defined( 'ABSPATH' ) ) {
	exit;
}
class scrollSlider extends Custom_Widget_Base {
	public function __construct( $data = [], $args = null ) {
		$this->rt_name = esc_html__( 'Scroll Slider', 'staco-core' );
		$this->rt_base = 'staco-scroll-slider';
		parent::__construct( $data, $args );
	}
	protected function register_controls() {
		$this->start_controls_section(
            '_section_price',
            [
                'label' => esc_html__( 'Scroll Slider', 'rsaddon' ),
                'tab' => Controls_Manager::TAB_CONTENT,
            ]
        );
        $this->add_control(
			'layout',
			[
				'label' => __('Layout Type', 'staco-core'),
				'type' => Controls_Manager::SELECT,
				'default' => 'style1',
				'options' => [
					'style1' => __( 'Style 1', 'staco-core' ),
					'style2' => __( 'Style 2', 'staco-core' ),
					'style3' => __( 'Style 3', 'staco-core' ),
				],
				'label_block' => true,
			]
		);
        $repeater = new Repeater();

        $repeater->add_control(
            'serial_number',
            [
                'label' => esc_html__( 'Serial Number', 'rsaddon' ),
                'type' => Controls_Manager::TEXT,
            ]
        );

        $repeater->add_control(
            'step_title',
            [
                'label' => esc_html__( 'Step Title', 'rsaddon' ),
                'type' => Controls_Manager::TEXT,
            ]
        );

        $repeater->add_control(
            'monthly_options',
            [
                'label' => esc_html__( 'Slider Content', 'rsaddon' ),
                'type' => Controls_Manager::HEADING,
                'separator' => 'before',
            ]
        );

        $repeater->add_control(
			'image_icon',
			[
				'label'   => __( 'Icon Image', 'staco-core' ),
				'type'    => \Elementor\Controls_Manager::MEDIA,
				'default' => [
					'url' => \Elementor\Utils::get_placeholder_image_src(),
				],
			]
		);

        $repeater->add_control(
            'title',
            [
                'label' => esc_html__( 'Title', 'rsaddon' ),
                'type' => Controls_Manager::TEXT,
                'label_block' => false,
                'default' => esc_html__( 'Basic', 'rsaddon' ),
            ]
        );
    
        $repeater->add_control(
            'features',
            [
                'label'   => esc_html__( 'Features (Use List Style)', 'rsaddon' ),
                'type'    => Controls_Manager::WYSIWYG,
                'rows'    => 10, 
                'default' => esc_html__( '1 Users', 'rsaddon' ),          
            ]
        );

        $repeater->add_control(
            'number1',
            [
                'label' => esc_html__( 'Number One', 'rsaddon' ),
                'type' => Controls_Manager::TEXT,
                'label_block' => false,
            ]
        );

        $repeater->add_control(
            'numbertext1',
            [
                'label' => esc_html__( 'Number Text One', 'rsaddon' ),
                'type' => Controls_Manager::TEXT,
                'label_block' => false,
            ]
        );

        $repeater->add_control(
            'number2',
            [
                'label' => esc_html__( 'Number Two', 'rsaddon' ),
                'type' => Controls_Manager::TEXT,
                'label_block' => false,
            ]
        );

        $repeater->add_control(
            'numbertext2',
            [
                'label' => esc_html__( 'Number Text Two', 'rsaddon' ),
                'type' => Controls_Manager::TEXT,
                'label_block' => false,
            ]
        );

        $repeater->add_control(
			'icon1',
			[
				'label'   => __( 'Icon One', 'staco-core' ),
				'type'    => \Elementor\Controls_Manager::MEDIA,
			]
		);

        $repeater->add_control(
            'icon_text1',
            [
                'label' => esc_html__( 'Icon Text One', 'rsaddon' ),
                'type' => Controls_Manager::TEXT,
                'label_block' => false,
            ]
        );

        $repeater->add_control(
			'icon2',
			[
				'label'   => __( 'Icon Two', 'staco-core' ),
				'type'    => \Elementor\Controls_Manager::MEDIA,
			]
		);

        $repeater->add_control(
            'icon_text2',
            [
                'label' => esc_html__( 'Icon Text Two', 'rsaddon' ),
                'type' => Controls_Manager::TEXT,
                'label_block' => false,
            ]
        );

        $repeater->add_control(
            'btn_text',
            [
                'label' => esc_html__( 'Button Text', 'rsaddon' ),
                'type' => Controls_Manager::TEXT,
                'label_block' => false,
            ]
        );

        $repeater->add_control(
            'btn_link',
            [
                'label' => esc_html__( 'Button Link', 'rsaddon' ),
                'type' => Controls_Manager::TEXT,
                'label_block' => false,
            ]
        );

        $this->add_control(
            'price_list',
            [
                'show_label' => false,
                'type' => Controls_Manager::REPEATER,
                'fields' => $repeater->get_controls(),
                'title_field' => '{{{ step_title }}}',
            ]
        ); 

        $this->end_controls_section();

        $this->start_controls_section(
            'global_style_area',
            [
                'label' => esc_html__( 'Global Style', 'rsaddon' ),
                'tab'   => Controls_Manager::TAB_STYLE,
            ]
        );
        $this->add_responsive_control(
            'sec_padding',
            [
                'label' => esc_html__( 'Padding', 'rsaddon' ),
                'type' => Controls_Manager::DIMENSIONS,
                'size_units' => [ 'px', 'em', '%' ],
                'selectors' => [
                    '{{WRAPPER}} .why-choose-section' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );
        $this->end_controls_section();

        $this->start_controls_section(
            'number_style_months',
            [
                'label' => esc_html__( 'Top Number', 'rsaddon' ),
                'tab'   => Controls_Manager::TAB_STYLE,
            ]
        );

        $this->add_control(
            'number_color',
            [
                'label' => esc_html__( 'Number Color', 'rsaddon' ),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .why-choose-tab .tab-buttons button span' => 'color: {{VALUE}};',
                ],
            ]
        );

        $this->add_control(
            'number_active_color',
            [
                'label' => esc_html__( 'Number Active Color', 'rsaddon' ),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .why-choose-tab .tab-buttons button.active span' => 'color: {{VALUE}};',
                ],
            ]
        );

        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'name' => 'number_typography',
                'label' => esc_html__( 'Number Typography', 'rsaddon' ),
                'selector' => '{{WRAPPER}} .why-choose-tab .tab-buttons button span',
            ]
        );
        $this->end_controls_section();
       
        $this->start_controls_section(
            'top_menu_style',
            [
                'label' => esc_html__( 'Top Menu', 'rsaddon' ),
                'tab'   => Controls_Manager::TAB_STYLE,
            ]
        );

        $this->add_control(
            'menu_color',
            [
                'label' => esc_html__( 'Menu Color', 'rsaddon' ),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .app-convert-visitors-nav .app-nav-list .nav-item .tab-btn, {{WRAPPER}} .why-choose-tab .tab-buttons button' => 'color: {{VALUE}};',
                ],
            ]
        );

        $this->add_control(
            'menu_active_color',
            [
                'label' => esc_html__( 'Menu Active Color', 'rsaddon' ),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .app-convert-visitors-nav .app-nav-list .nav-item .tab-btn, {{WRAPPER}} .why-choose-tab .tab-buttons.active button' => 'color: {{VALUE}};',
                ],
            ]
        );
        $this->end_controls_section();

        $this->start_controls_section(
            '_section_style_general',
            [
                'label' => esc_html__( 'Item Style', 'rsaddon' ),
                'tab'   => Controls_Manager::TAB_STYLE,
            ]
        );

        $this->add_control(
            'title_color',
            [
                'label' => esc_html__( 'Title Color', 'rsaddon' ),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .section-title .title, {{WRAPPER}} .why-choose-section .tab-body h2' => 'color: {{VALUE}};',
                ],
            ]
        );

        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'name' => 'title_typography',
                'label' => esc_html__( 'Number Typography', 'rsaddon' ),
                'selector' => '{{WRAPPER}} .section-title .title, {{WRAPPER}} .why-choose-section .tab-body .tab-body-title',
            ]
        );
        $this->add_responsive_control(
            'title_margin',
            [
                'label' => esc_html__( 'Margin', 'rsaddon' ),
                'type' => Controls_Manager::DIMENSIONS,
                'size_units' => [ 'px', 'em', '%' ],
                'selectors' => [
                    '{{WRAPPER}} .section-title .title, {{WRAPPER}} .why-choose-section .tab-body .tab-body-title' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );
        $this->add_control(
            'desc_color',
            [
                'label' => esc_html__( 'Descriptin Color', 'rsaddon' ),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .convert-visitors-text p, {{WRAPPER}} .why-choose-section .tab-body .description' => 'color: {{VALUE}};',
                ],
            ]
        );
        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'name' => 'desc_typography',
                'label' => esc_html__( 'Descriptin Typography', 'rsaddon' ),
                'selector' => '{{WRAPPER}} .convert-visitors-text p, {{WRAPPER}} .why-choose-section .tab-body .description',
            ]
        );

        $this->add_control(
            'btn_color',
            [
                'label' => esc_html__( 'Descriptin Color', 'rsaddon' ),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .star-free-btn' => 'color: {{VALUE}};',
                ],
            ]
        );
        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'name' => 'btn_typography',
                'label' => esc_html__( 'Descriptin Typography', 'rsaddon' ),
                'selector' => '{{WRAPPER}} .star-free-btn',
            ]
        );
        $this->end_controls_section();

    }

    protected function render() {
		$data     = $this->get_settings();
		$template = 'view';
		if ( 'style1' == $data['layout'] ) {
			$template = 'view';
		} elseif ( 'style2' == $data['layout'] ) {
			$template = 'view-2';
		} elseif ( 'style3' == $data['layout'] ) {
			$template = 'view-3';
		} 
		$this->rt_template( $template, $data );
	}

}